/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.torque.generator.configuration.controller.LoggingAdapter;
import org.apache.torque.generator.configuration.controller.Loglevel;

public class Log4jLoggingAdapter
implements LoggingAdapter {
    private static Log log = LogFactory.getLog(Log4jLoggingAdapter.class);
    private final Map<Loglevel, Level> log4jLevels;

    public Log4jLoggingAdapter() {
        HashMap<Loglevel, Level> levels = new HashMap<Loglevel, Level>();
        levels.put(Loglevel.TRACE, Level.TRACE);
        levels.put(Loglevel.DEBUG, Level.DEBUG);
        levels.put(Loglevel.INFO, Level.INFO);
        levels.put(Loglevel.WARN, Level.WARN);
        levels.put(Loglevel.ERROR, Level.ERROR);
        this.log4jLevels = Collections.unmodifiableMap(levels);
    }

    @Override
    public Loglevel getCurrentLoglevel() {
        Level level = Logger.getRootLogger().getLevel();
        for (Map.Entry<Loglevel, Level> loglevel : this.log4jLevels.entrySet()) {
            if (!loglevel.getValue().equals((Object)level)) continue;
            return loglevel.getKey();
        }
        return Loglevel.INFO;
    }

    @Override
    public void setLoglevel(Loglevel loglevel) {
        if (loglevel == null) {
            return;
        }
        Level log4jLevel = this.log4jLevels.get((Object)loglevel);
        if (Logger.getRootLogger().getLevel() != this.log4jLevels.get((Object)loglevel)) {
            log.info((Object)("apply() : Setting loglevel to " + (Object)((Object)loglevel)));
            Logger.getRootLogger().setLevel(log4jLevel);
        }
    }
}

