/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.platform;

import java.util.Date;
import org.apache.torque.templates.platform.PlatformDefaultImpl;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;

public class PlatformHsqldbImpl
extends PlatformDefaultImpl {
    private static final String DATE_FORMAT = "''yyyy-MM-dd''";
    private static final String TIME_FORMAT = "''HH:mm:ss''";

    public PlatformHsqldbImpl() {
        this.initialize();
    }

    private void initialize() {
        this.setSchemaTypeToSqlTypeMapping(SchemaType.CHAR, new SqlType("VARCHAR", "1"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BOOLEANCHAR, new SqlType("VARCHAR", "1"));
    }

    @Override
    public String getAutoIncrement() {
        return "GENERATED BY DEFAULT AS IDENTITY (START WITH 1)";
    }

    @Override
    public boolean createNotNullBeforeAutoincrement() {
        return false;
    }

    @Override
    protected boolean escapeBackslashes() {
        return false;
    }

    @Override
    public String getDateString(Date date) {
        return this.formatDateTimeString(date, DATE_FORMAT);
    }

    @Override
    public String getTimeString(Date date) {
        return this.formatDateTimeString(date, TIME_FORMAT);
    }

    @Override
    public boolean usesStandaloneSchema() {
        return true;
    }

    @Override
    public boolean hasSize(String sqlType) {
        return "VARCHAR".equals(sqlType) || "VARBINARY".equals(sqlType) || "BINARY".equals(sqlType);
    }

    @Override
    public boolean hasScale(String sqlType) {
        return "TIMESTAMP".equals(sqlType) || "DATE".equals(sqlType) || "TIME".equals(sqlType);
    }
}

