/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.typemapping;

import org.apache.commons.lang.StringUtils;

public class SqlType {
    private String size;
    private String scale;
    private String defaultValue;
    private final String sqlTypeName;

    public SqlType(String sqlTypeName) {
        this.sqlTypeName = sqlTypeName;
    }

    public SqlType(String sqlTypeName, String size) {
        this(sqlTypeName);
        this.size = size;
    }

    public SqlType(String sqlTypeName, String size, String scale) {
        this(sqlTypeName, size);
        this.scale = scale;
    }

    public SqlType(String sqlTypeName, String size, String scale, String defaultValue) {
        this(sqlTypeName, size, scale);
        this.defaultValue = defaultValue;
    }

    public SqlType(SqlType sqlType, String size, String scale, String defaultValue) {
        this(sqlType.getSqlTypeName());
        this.size = size != null ? size : sqlType.getSize();
        this.scale = scale != null ? scale : sqlType.getScale();
        this.defaultValue = defaultValue != null ? defaultValue : sqlType.getDefaultValue();
    }

    public String getScale() {
        return this.scale;
    }

    public String getSize() {
        return this.size;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getSqlTypeName() {
        return this.sqlTypeName;
    }

    public String printSize(String sizeSuffix) {
        if (StringUtils.isNotBlank((String)this.size) && StringUtils.isNotBlank((String)this.scale)) {
            return '(' + this.size + sizeSuffix + ',' + this.scale + ')';
        }
        if (StringUtils.isNotBlank((String)this.size)) {
            return '(' + this.size + sizeSuffix + ')';
        }
        return "";
    }

    public SqlType getNew(String size, String scale, String defaultValue) {
        return new SqlType(this, size, scale, defaultValue);
    }
}

