/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.file;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public class WildcardFilter
implements FileFilter {
    private String expression;
    private boolean acceptDir;
    private boolean acceptFile;

    public WildcardFilter(String expression, boolean acceptDir, boolean acceptFile) {
        this.expression = expression;
        this.acceptDir = acceptDir;
        this.acceptFile = acceptFile;
    }

    public boolean accept(File file) {
        if (!this.acceptDir && file.isDirectory()) {
            return false;
        }
        if (!this.acceptFile && file.isFile()) {
            return false;
        }
        return FilenameUtils.wildcardMatch((String)file.getName(), (String)this.expression, (IOCase)IOCase.SENSITIVE);
    }
}

