/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.dfs.DeltaBaseCache;
import org.eclipse.jgit.storage.dfs.DfsBlock;
import org.eclipse.jgit.storage.dfs.DfsCachedPack;
import org.eclipse.jgit.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.storage.dfs.DfsPackFile;
import org.eclipse.jgit.storage.dfs.DfsPackKey;
import org.eclipse.jgit.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.storage.dfs.ReadAheadTask;
import org.eclipse.jgit.storage.pack.CachedPack;
import org.eclipse.jgit.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackOutputStream;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.util.BlockList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfsReader
extends ObjectReader
implements ObjectReuseAsIs {
    final byte[] tempId = new byte[20];
    final DfsObjDatabase db;
    private Inflater inf;
    private DfsBlock block;
    private DeltaBaseCache baseCache;
    private DfsPackFile last;
    private boolean wantReadAhead;
    private List<ReadAheadTask.BlockFuture> pendingReadAhead;
    private static final Comparator<FoundObject<?>> FOUND_OBJECT_SORT = new Comparator<FoundObject<?>>(){

        @Override
        public int compare(FoundObject<?> a, FoundObject<?> b) {
            int cmp = a.packIndex - b.packIndex;
            if (cmp == 0) {
                cmp = Long.signum(a.offset - b.offset);
            }
            return cmp;
        }
    };
    private static final Comparator<DfsObjectRepresentation> REPRESENTATION_SORT = new Comparator<DfsObjectRepresentation>(){

        @Override
        public int compare(DfsObjectRepresentation a, DfsObjectRepresentation b) {
            int cmp = a.packIndex - b.packIndex;
            if (cmp == 0) {
                cmp = Long.signum(a.offset - b.offset);
            }
            return cmp;
        }
    };
    private static final Comparator<ObjectToPack> WRITE_SORT = new Comparator<ObjectToPack>(){

        @Override
        public int compare(ObjectToPack o1, ObjectToPack o2) {
            DfsObjectToPack a = (DfsObjectToPack)o1;
            DfsObjectToPack b = (DfsObjectToPack)o2;
            int cmp = a.packIndex - b.packIndex;
            if (cmp == 0) {
                cmp = Long.signum(a.offset - b.offset);
            }
            return cmp;
        }
    };

    DfsReader(DfsObjDatabase db) {
        this.db = db;
    }

    DfsReaderOptions getOptions() {
        return this.db.getReaderOptions();
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache(this);
        }
        return this.baseCache;
    }

    int getStreamFileThreshold() {
        return this.getOptions().getStreamFileThreshold();
    }

    @Override
    public ObjectReader newReader() {
        return new DfsReader(this.db);
    }

    @Override
    public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
        if (id.isComplete()) {
            return Collections.singleton(id.toObjectId());
        }
        HashSet<ObjectId> matches = new HashSet<ObjectId>(4);
        for (DfsPackFile pack : this.db.getPacks()) {
            pack.resolve(this, matches, id, 256);
            if (256 <= matches.size()) break;
        }
        return matches;
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        if (this.last != null && this.last.hasObject(this, objectId)) {
            return true;
        }
        for (DfsPackFile pack : this.db.getPacks()) {
            if (this.last == pack || !pack.hasObject(this, objectId)) continue;
            this.last = pack;
            return true;
        }
        return false;
    }

    @Override
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr;
        if (this.last != null && (ldr = this.last.get(this, objectId)) != null) {
            return ldr;
        }
        for (DfsPackFile pack : this.db.getPacks()) {
            ObjectLoader ldr2;
            if (pack == this.last || (ldr2 = pack.get(this, objectId)) == null) continue;
            this.last = pack;
            return ldr2;
        }
        if (typeHint == -1) {
            throw new MissingObjectException(objectId.copy(), "unknown");
        }
        throw new MissingObjectException(objectId.copy(), typeHint);
    }

    private <T extends ObjectId> Iterable<FoundObject<T>> findAll(Iterable<T> objectIds) throws IOException {
        ArrayList<FoundObject<T>> r = new ArrayList<FoundObject<T>>();
        DfsPackFile[] packList = this.db.getPacks();
        if (packList.length == 0) {
            for (ObjectId t : objectIds) {
                r.add(new FoundObject<ObjectId>(t));
            }
            return r;
        }
        int lastIdx = 0;
        DfsPackFile lastPack = packList[lastIdx];
        block5: for (ObjectId t : objectIds) {
            try {
                long p = lastPack.findOffset(this, t);
                if (0L < p) {
                    r.add(new FoundObject<ObjectId>(t, lastIdx, lastPack, p));
                    continue;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            for (int i = 0; i < packList.length; ++i) {
                if (i == lastIdx) continue;
                DfsPackFile pack = packList[i];
                try {
                    long p = pack.findOffset(this, t);
                    if (0L >= p) continue;
                    r.add(new FoundObject<ObjectId>(t, i, pack, p));
                    lastIdx = i;
                    lastPack = pack;
                    continue block5;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            r.add(new FoundObject<ObjectId>(t));
        }
        Collections.sort(r, FOUND_OBJECT_SORT);
        this.last = lastPack;
        return r;
    }

    @Override
    public <T extends ObjectId> AsyncObjectLoaderQueue<T> open(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        this.wantReadAhead = true;
        IOException error = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e) {
            order = Collections.emptyList();
            error = e;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error;
        return new AsyncObjectLoaderQueue<T>(){
            private FoundObject<T> cur;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                DfsReader.this.cancelReadAhead();
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public ObjectLoader open() throws IOException {
                if (this.cur.pack == null) {
                    throw new MissingObjectException((ObjectId)this.cur.id, "unknown");
                }
                return this.cur.pack.load(DfsReader.this, this.cur.offset);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                DfsReader.this.cancelReadAhead();
                return true;
            }

            @Override
            public void release() {
                DfsReader.this.cancelReadAhead();
            }
        };
    }

    @Override
    public <T extends ObjectId> AsyncObjectSizeQueue<T> getObjectSize(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        this.wantReadAhead = true;
        IOException error = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e) {
            order = Collections.emptyList();
            error = e;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error;
        return new AsyncObjectSizeQueue<T>(){
            private FoundObject<T> cur;
            private long sz;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    if (this.cur.pack == null) {
                        throw new MissingObjectException((ObjectId)this.cur.id, "unknown");
                    }
                    this.sz = this.cur.pack.getObjectSize(DfsReader.this, this.cur.offset);
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                DfsReader.this.cancelReadAhead();
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public long getSize() {
                return this.sz;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                DfsReader.this.cancelReadAhead();
                return true;
            }

            @Override
            public void release() {
                DfsReader.this.cancelReadAhead();
            }
        };
    }

    @Override
    public void walkAdviceBeginCommits(RevWalk walk, Collection<RevCommit> roots) {
        this.wantReadAhead = true;
    }

    @Override
    public void walkAdviceBeginTrees(ObjectWalk ow, RevCommit min, RevCommit max) {
        this.wantReadAhead = true;
    }

    @Override
    public void walkAdviceEnd() {
        this.cancelReadAhead();
    }

    @Override
    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        long sz;
        if (this.last != null && 0L <= (sz = this.last.getObjectSize(this, objectId))) {
            return sz;
        }
        for (DfsPackFile pack : this.db.getPacks()) {
            long sz2;
            if (pack == this.last || 0L > (sz2 = pack.getObjectSize(this, objectId))) continue;
            this.last = pack;
            return sz2;
        }
        if (typeHint == -1) {
            throw new MissingObjectException(objectId.copy(), "unknown");
        }
        throw new MissingObjectException(objectId.copy(), typeHint);
    }

    @Override
    public DfsObjectToPack newObjectToPack(RevObject obj) {
        return new DfsObjectToPack(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectObjectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects) throws IOException, MissingObjectException {
        DfsPackFile[] packList = this.db.getPacks();
        if (packList.length == 0) {
            Iterator<ObjectToPack> itr = objects.iterator();
            if (itr.hasNext()) {
                throw new MissingObjectException((ObjectId)itr.next(), "unknown");
            }
            return;
        }
        int objectCount = 0;
        int updated = 0;
        int posted = 0;
        BlockList all = new BlockList();
        for (ObjectToPack otp : objects) {
            boolean found = false;
            for (int packIndex = 0; packIndex < packList.length; ++packIndex) {
                DfsPackFile pack = packList[packIndex];
                long p = pack.findOffset(this, otp);
                if (0L >= p) continue;
                DfsObjectRepresentation r = new DfsObjectRepresentation(otp);
                r.pack = pack;
                r.packIndex = packIndex;
                r.offset = p;
                all.add(r);
                found = true;
            }
            if (!found) {
                throw new MissingObjectException((ObjectId)otp, otp.getType());
            }
            if ((++updated & 1) == 1) {
                monitor.update(1);
                ++posted;
            }
            ++objectCount;
        }
        Collections.sort(all, REPRESENTATION_SORT);
        try {
            this.wantReadAhead = true;
            for (DfsObjectRepresentation r : all) {
                r.pack.representation(this, r);
                packer.select(r.object, r);
                if ((++updated & 1) != 1 || posted >= objectCount) continue;
                monitor.update(1);
                ++posted;
            }
        }
        finally {
            this.cancelReadAhead();
        }
        if (posted < objectCount) {
            monitor.update(objectCount - posted);
        }
    }

    @Override
    public void copyObjectAsIs(PackOutputStream out, ObjectToPack otp, boolean validate) throws IOException, StoredObjectRepresentationNotAvailableException {
        DfsObjectToPack src = (DfsObjectToPack)otp;
        src.pack.copyAsIs(out, src, validate, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        switch (list.get(0).getType()) {
            case 2: 
            case 3: {
                Collections.sort(list, WRITE_SORT);
            }
        }
        try {
            this.wantReadAhead = true;
            for (ObjectToPack otp : list) {
                out.writeObject(otp);
            }
        }
        finally {
            this.cancelReadAhead();
        }
    }

    @Override
    public Collection<CachedPack> getCachedPacks() throws IOException {
        DfsPackFile[] packList = this.db.getPacks();
        ArrayList<CachedPack> cached = new ArrayList<CachedPack>(packList.length);
        for (DfsPackFile pack : packList) {
            DfsPackDescription desc = pack.getPackDescription();
            if (!DfsReader.canBeCachedPack(desc)) continue;
            cached.add(new DfsCachedPack(pack));
        }
        return cached;
    }

    private static boolean canBeCachedPack(DfsPackDescription desc) {
        return desc.getTips() != null && !desc.getTips().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyPackAsIs(PackOutputStream out, CachedPack pack, boolean validate) throws IOException {
        try {
            this.wantReadAhead = true;
            ((DfsCachedPack)pack).copyAsIs(out, validate, this);
        }
        finally {
            this.cancelReadAhead();
        }
    }

    int copy(DfsPackFile pack, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        if (cnt == 0) {
            return 0;
        }
        long length = pack.length;
        if (0L <= length && length <= position) {
            return 0;
        }
        int need = cnt;
        do {
            this.pin(pack, position);
            int r = this.block.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
            need -= r;
            if (length >= 0L) continue;
            length = pack.length;
        } while (0 < need && position < length);
        return cnt - need;
    }

    void copyPackAsIs(DfsPackFile pack, long length, boolean validate, PackOutputStream out) throws IOException {
        int n;
        MessageDigest md = null;
        if (validate) {
            md = Constants.newMessageDigest();
            byte[] buf = out.getCopyBuffer();
            this.pin(pack, 0L);
            if (this.block.copy(0, buf, 0, 12) != 12) {
                pack.setInvalid();
                throw new IOException(JGitText.get().packfileIsTruncated);
            }
            md.update(buf, 0, 12);
        }
        long position = 12L;
        for (long remaining = length - 32L; 0L < remaining; remaining -= (long)n) {
            this.pin(pack, position);
            int ptr = (int)(position - this.block.start);
            n = (int)Math.min((long)(this.block.size() - ptr), remaining);
            this.block.write(out, position, n, md);
            position += (long)n;
        }
        if (md != null) {
            byte[] buf = new byte[20];
            byte[] actHash = md.digest();
            this.pin(pack, position);
            if (this.block.copy(position, buf, 0, 20) != 20) {
                pack.setInvalid();
                throw new IOException(JGitText.get().packfileIsTruncated);
            }
            if (!Arrays.equals(actHash, buf)) {
                pack.setInvalid();
                throw new IOException(MessageFormat.format(JGitText.get().packfileCorruptionDetected, pack.getPackDescription().getPackName()));
            }
        }
    }

    int inflate(DfsPackFile pack, long position, byte[] dstbuf, boolean headerOnly) throws IOException, DataFormatException {
        this.prepareInflater();
        this.pin(pack, position);
        int dstoff = 0;
        while (true) {
            dstoff = this.block.inflate(this.inf, position, dstbuf, dstoff);
            if (headerOnly && dstoff == dstbuf.length) {
                return dstoff;
            }
            if (!this.inf.needsInput()) break;
            position += (long)this.block.remaining(position);
            this.pin(pack, position);
        }
        if (this.inf.finished()) {
            return dstoff;
        }
        throw new DataFormatException();
    }

    DfsBlock quickCopy(DfsPackFile p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.block.contains(p.key, pos + (cnt - 1L))) {
            return this.block;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(DfsPackFile pack, long position) throws IOException {
        DfsBlock b = this.block;
        if (b == null || !b.contains(pack.key, position)) {
            this.block = null;
            if (this.pendingReadAhead != null) {
                this.waitForBlock(pack.key, position);
            }
            this.block = pack.getOrLoadBlock(position, this);
        }
    }

    boolean wantReadAhead() {
        return this.wantReadAhead;
    }

    void startedReadAhead(List<ReadAheadTask.BlockFuture> blocks) {
        if (this.pendingReadAhead == null) {
            this.pendingReadAhead = new LinkedList<ReadAheadTask.BlockFuture>();
        }
        this.pendingReadAhead.addAll(blocks);
    }

    private void cancelReadAhead() {
        if (this.pendingReadAhead != null) {
            for (ReadAheadTask.BlockFuture f : this.pendingReadAhead) {
                f.cancel(true);
            }
            this.pendingReadAhead = null;
        }
        this.wantReadAhead = false;
    }

    private void waitForBlock(DfsPackKey key, long position) throws InterruptedIOException {
        Iterator<ReadAheadTask.BlockFuture> itr = this.pendingReadAhead.iterator();
        while (itr.hasNext()) {
            ReadAheadTask.BlockFuture f = itr.next();
            if (!f.contains(key, position)) continue;
            try {
                f.get();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            catch (ExecutionException e) {
                // empty catch block
            }
            itr.remove();
            if (!this.pendingReadAhead.isEmpty()) break;
            this.pendingReadAhead = null;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.cancelReadAhead();
        this.last = null;
        this.block = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FoundObject<T extends ObjectId> {
        final T id;
        final DfsPackFile pack;
        final long offset;
        final int packIndex;

        FoundObject(T objectId, int packIdx, DfsPackFile pack, long offset) {
            this.id = objectId;
            this.pack = pack;
            this.offset = offset;
            this.packIndex = packIdx;
        }

        FoundObject(T objectId) {
            this.id = objectId;
            this.pack = null;
            this.offset = 0L;
            this.packIndex = 0;
        }
    }
}

