/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control.existingtargetstrategy;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.UnitConfiguration;
import org.apache.torque.generator.control.ControllerException;
import org.apache.torque.generator.control.ControllerHelper;
import org.apache.torque.generator.control.existingtargetstrategy.ExistingTargetStrategy;
import org.apache.torque.generator.outlet.OutletResult;

public class ReplaceTargetFileStrategy
implements ExistingTargetStrategy {
    public static final String STRATEGY_NAME = "replace";

    public boolean beforeGeneration(String outputDirKey, String outputPath, String encoding, UnitConfiguration unitConfiguration) {
        return true;
    }

    public void afterGeneration(String outputDirKey, String outputPath, String encoding, OutletResult generationResult, UnitConfiguration unitConfiguration) throws GeneratorException {
        File outputFile = ControllerHelper.getOutputFile(outputDirKey, outputPath, unitConfiguration);
        try {
            if (generationResult.isStringResult()) {
                FileUtils.writeStringToFile((File)outputFile, (String)generationResult.getStringResult(), (String)encoding);
            } else {
                FileUtils.writeByteArrayToFile((File)outputFile, (byte[])generationResult.getByteArrayResult());
            }
        }
        catch (IOException e) {
            throw new ControllerException("Could not write file \"" + outputFile.getAbsolutePath() + "\"", e);
        }
    }

    public String getStrategyName() {
        return STRATEGY_NAME;
    }
}

