/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ReadMeFilesTest
extends BaseJDBCTestCase {
    private static final String DB_README_FILE_NAME = "README_DO_NOT_TOUCH_FILES.txt";
    static String logDir = BaseTestCase.getSystemProperty("derby.system.home") + File.separator + "abcs";

    public ReadMeFilesTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReadMeFilesTest");
        baseTestSuite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator(TestConfiguration.embeddedSuite(ReadMeFilesTest.class)));
        logDir = BaseTestCase.getSystemProperty("derby.system.home") + File.separator + "abcs";
        baseTestSuite.addTest(Decorator.logDeviceAttributeDatabase(TestConfiguration.embeddedSuite(ReadMeFilesTest.class), logDir));
        return baseTestSuite;
    }

    public void testReadMeFilesExist() throws IOException, SQLException {
        this.getConnection();
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        String string = testConfiguration.getDatabasePath(testConfiguration.getDefaultDatabaseName());
        this.lookForReadmeFile(string);
        this.lookForReadmeFile(string + File.separator + "seg0");
        String string2 = testConfiguration.getConnectionAttributes().getProperty("logDevice");
        if (string2 != null) {
            this.lookForReadmeFile(logDir + File.separator + "log");
        } else {
            this.lookForReadmeFile(string + File.separator + "log");
        }
    }

    private void lookForReadmeFile(String string) throws IOException {
        File file = new File(string, DB_README_FILE_NAME);
        ReadMeFilesTest.assertTrue((String)(String.valueOf(file) + "doesn't exist"), (boolean)PrivilegedFileOpsForTests.exists(file));
    }
}

