/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class URCoveringIndexTest
extends BaseJDBCTestCase {
    public static Test suite() {
        return TestConfiguration.defaultSuite(URCoveringIndexTest.class);
    }

    public URCoveringIndexTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        Connection con = this.getConnection();
        con.setAutoCommit(false);
        String createTableWithPK = "CREATE TABLE tableWithPK (c1 int primary key,c2 int)";
        String insertData = "INSERT INTO tableWithPK values (1, 1)";
        Statement stmt = con.createStatement();
        stmt.execute(createTableWithPK);
        stmt.execute(insertData);
        stmt.close();
    }

    private void testUpdateUpdatedTupleWithCoveringIndex(boolean scroll, boolean usePositionedUpdate) throws SQLException {
        SQLWarning w = null;
        int resultsetType = scroll ? 1004 : 1003;
        Connection con = this.getConnection();
        if (!con.getMetaData().supportsResultSetConcurrency(resultsetType, 1008)) {
            return;
        }
        Statement updStmt = con.createStatement(resultsetType, 1008);
        Statement roStmt = con.createStatement();
        ResultSet rs = updStmt.executeQuery("SELECT c1 FROM tableWithPK");
        rs.next();
        int orig_c1 = rs.getInt(1);
        roStmt.executeUpdate("UPDATE tableWithPK SET c1 = " + (orig_c1 + 10) + "WHERE c1 = " + rs.getInt(1));
        rs.clearWarnings();
        if (usePositionedUpdate) {
            roStmt.executeUpdate("UPDATE tableWithPK set c1 = " + (orig_c1 + 20) + "WHERE CURRENT OF " + rs.getCursorName());
            w = roStmt.getWarnings();
        } else {
            rs.updateInt(1, orig_c1 + 20);
            rs.updateRow();
            w = rs.getWarnings();
        }
        JDBC.assertNoWarnings(w);
        rs.close();
        rs = roStmt.executeQuery("SELECT c1 FROM tableWithPK");
        rs.next();
        URCoveringIndexTest.assertEquals((String)("Expecting c1 to be " + orig_c1 + " + 20"), (int)rs.getInt(1), (int)(orig_c1 + 20));
        rs.close();
        roStmt.close();
        updStmt.close();
    }

    public void testUpdateUpdatedTupleScrollPostitioned() throws SQLException {
        this.testUpdateUpdatedTupleWithCoveringIndex(true, true);
    }

    public void testUpdateUpdatedTupleScrollUpdateRow() throws SQLException {
        this.testUpdateUpdatedTupleWithCoveringIndex(true, false);
    }

    public void testUpdateUpdatedTupleFOPositioned() throws SQLException {
        this.testUpdateUpdatedTupleWithCoveringIndex(false, true);
    }

    public void testUpdateUpdatedTupleFOUpdateRow() throws SQLException {
        this.testUpdateUpdatedTupleWithCoveringIndex(false, false);
    }
}

