/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class NormalizeResultSetNode
extends SingleChildResultSetNode {
    private boolean forUpdate;

    NormalizeResultSetNode(ResultSetNode chldRes, ResultColumnList targetResultColumnList, Properties tableProperties, boolean forUpdate, ContextManager cm) throws StandardException {
        super(chldRes, tableProperties, cm);
        this.forUpdate = forUpdate;
        ResultColumnList rcl = chldRes.getResultColumns();
        ResultColumnList targetRCL = targetResultColumnList;
        ResultColumnList prRCList = rcl;
        chldRes.setResultColumns(rcl.copyListAndObjects());
        prRCList.removeGeneratedGroupingColumns();
        prRCList.removeOrderByColumns();
        prRCList.genVirtualColumnNodes(chldRes, chldRes.getResultColumns());
        this.setResultColumns(prRCList);
        if (chldRes.getReferencedTableMap() != null) {
            this.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
        }
        if (targetResultColumnList != null) {
            int size = Math.min(targetRCL.size(), this.getResultColumns().size());
            for (int index = 0; index < size; ++index) {
                ResultColumn sourceRC = (ResultColumn)this.getResultColumns().elementAt(index);
                ResultColumn resultColumn = (ResultColumn)targetRCL.elementAt(index);
                sourceRC.setType(resultColumn.getTypeServices());
            }
        }
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.getResultColumns() != null, "Tree structure bad");
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        int erdNumber = acb.addItem(this.makeResultDescription());
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        mb.push(this.getResultSetNumber());
        mb.push(erdNumber);
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.push(this.forUpdate);
        mb.callMethod((short)185, null, "getNormalizeResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    @Override
    void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.childResult.setRefActionInfo(fkIndexConglomId, fkColArray, parentResultSetId, dependentScan);
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.childResult.pushQueryExpressionSuffix();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.childResult.pushOrderByList(orderByList);
    }

    @Override
    void pushOffsetFetchFirst(ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause) {
        this.childResult.pushOffsetFetchFirst(offset, fetchFirst, hasJDBClimitClause);
    }
}

