/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.IdentitySequenceTest;
import org.apache.derbyTesting.functionTests.util.TestInputStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class AlterTableTest
extends BaseJDBCTestCase {
    private static final String CANNOT_ALTER_NON_IDENTITY_COLUMN = "42Z29";
    private static final String CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN = "42Z23";
    private static final String DUPLICATE_KEY = "23505";
    private static final String EXHAUSTED_IDENTITY_COLUMN = "2200H";

    public AlterTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("AlterTableTest Test");
        suite.addTest(TestConfiguration.defaultSuite(AlterTableTest.class));
        return TestConfiguration.sqlAuthorizationDecorator((Test)suite);
    }

    private void createTestObjects(Statement st) throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        CleanDatabaseTestSetup.cleanDatabase(conn, false);
        st.executeUpdate("create table t0(c1 int not null constraint p1 primary key)");
        st.executeUpdate("create table t0_1(c1 int)");
        st.executeUpdate("create table t0_2(c1 int)");
        st.executeUpdate("create table t0_3(c1 int)");
        st.executeUpdate("create table t1(c1 int)");
        st.executeUpdate("create table t1_1(c1 int)");
        st.executeUpdate("create table t2(c1 int)");
        st.executeUpdate("create table t3(c1 int)");
        st.executeUpdate("create table t4(c1 int not null)");
        st.executeUpdate("create view v1 as select * from t2");
        st.executeUpdate("create view v2 as select c1 from t2");
        st.executeUpdate("create index i0_1 on t0_1(c1)");
        st.executeUpdate("create index i0_2 on t0_2(c1)");
        st.executeUpdate("insert into t1 values 1");
        st.executeUpdate("insert into t1_1 values 1");
        st.executeUpdate("insert into t2 values 1");
        st.executeUpdate("insert into t2 values 2");
        st.executeUpdate("insert into t3 values 1");
        st.executeUpdate("insert into t3 values 2");
        st.executeUpdate("insert into t3 values 3");
        st.executeUpdate("insert into t4 values 1, 2, 3, 1");
        st.executeUpdate("create schema emptyschema");
    }

    private void checkWarning(Statement st, String expectedWarning) throws Exception {
        SQLWarning sqlWarn = st == null ? this.getConnection().getWarnings() : st.getWarnings();
        AlterTableTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
        AlterTableTest.assertSQLState(expectedWarning, sqlWarn);
    }

    public void testAddColumn() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        this.commit();
        AlterTableTest.assertStatementError("42Y55", st, "alter table notexists add column c1 int");
        AlterTableTest.assertStatementError("X0Y32", st, "alter table t0 add column c1 int");
        AlterTableTest.assertStatementError("42XA9", st, "alter table t0 add column y");
        AlterTableTest.assertStatementError("42X62", st, "alter table sys.systables add column c1 int");
        AlterTableTest.assertStatementError("42Y62", st, "alter table v2 add column c2 int");
        AlterTableTest.assertStatementError("X0Y58", st, "alter table t0 add column c2 int not null default 0 primary key");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, st, "alter table t3 add column c2 int not null default 0 unique");
        PreparedStatement ps_c1 = this.prepareStatement("select * from t1");
        ResultSet c1 = ps_c1.executeQuery();
        if (AlterTableTest.usingEmbedded()) {
            AlterTableTest.assertStatementError("X0X95", st, " alter table t1 add column c2 int");
        }
        c1.close();
        ps_c1.close();
        st.executeUpdate("alter table t1 add column c2 int not null default 0");
        st.executeUpdate("alter table t1 add column c3 int not null default 0 primary key");
        st.executeUpdate("alter table t1 add column c4 int check(c4 = 1)");
        ResultSet rs = st.executeQuery("select * from v1");
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}});
        PreparedStatement pSt = this.prepareStatement("select * from t2");
        rs = pSt.executeQuery();
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}});
        st.executeUpdate("alter table t2 add column c2 int");
        rs = st.executeQuery("select * from v1");
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}});
        rs = pSt.executeQuery();
        JDBC.assertColumnNames(rs, "C1", "C2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", null}, {"2", null}});
        st.executeUpdate("alter table t0 add column c2 int not null default 0");
        st.executeUpdate("insert into t0 values (1, default)");
        rs = st.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1", "C2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "0"}});
        st.executeUpdate("drop table t0");
        this.rollback();
        rs = st.executeQuery(" select  * from t0");
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("alter table t0_1 add column c2 int not null primary key default 0");
        st.executeUpdate("insert into t0_1 values (1, 1)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, st, "insert into t0_1 values (1, 1)");
        rs = st.executeQuery("select * from t0_1");
        JDBC.assertColumnNames(rs, "C1", "C2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "1"}});
        this.rollback();
        st.executeUpdate("alter table t0_1 add column c2 int not null unique  default 0");
        st.executeUpdate(" insert into t0_1 values (1, default)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, st, " insert into t0_1 values (2, default)");
        st.executeUpdate("insert into t0_1 values (3, 1)");
        st.executeUpdate("drop table t1");
        st.executeUpdate("create table t1(c1 int)");
        st.executeUpdate(" alter table t1 add column c2 int not null unique default 0");
        st.executeUpdate("insert into t1 values (2, 2)");
        st.executeUpdate("insert into t1 values (3, 1)");
        rs = st.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T'");
        Object[][] expRS = new String[][]{{"T0", "1"}, {"T0_1", "1"}, {"T0_2", "1"}, {"T0_3", "1"}, {"T1", "1"}, {"T1_1", "1"}, {"T2", "1"}, {"T3", "1"}, {"T4", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        this.rollback();
        st.executeUpdate(" create function countopens() returns varchar(128) language java parameter style java external name 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.countOpens'");
        this.commit();
        rs = st.executeQuery("values countopens()");
        JDBC.assertFullResultSet(rs, new String[][]{{"No open scans, etc."}});
    }

    public void testAddIdentityColumn() throws SQLException {
        Statement s = this.createStatement();
        this.createTestObjects(s);
        this.commit();
        s.execute("alter table t0 add column id int generated always as identity");
        ResultSet rs = s.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1", "ID");
        ResultSetMetaData rsmd = rs.getMetaData();
        AlterTableTest.assertTrue((boolean)rsmd.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)rsmd.isNullable(2));
        rs.close();
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t0(c1, id) values (1, 1)");
        s.execute("insert into t0(c1, id) values (1, default)");
        s.execute("insert into t0(c1) values 2,3,4");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}});
        this.assertCompileError("428C1", "alter table t0 add column id2 bigint generated always as identity");
        s.execute("create table table_with_identity(id int generated always as identity)");
        this.assertCompileError("428C1", "alter table table_with_identity add column id2 bigint generated always as identity");
        this.rollback();
        s.execute("insert into t0 values 1,2,3,4,5");
        s.execute("alter table t0 add column id int generated always as identity (start with 100, increment by 5)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "100"}, {"2", "105"}, {"3", "110"}, {"4", "115"}, {"5", "120"}});
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "125"}, {"2", "130"}, {"3", "135"}});
        this.rollback();
        s.execute("alter table t0 add column id int generated by default as identity");
        rs = s.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1", "ID");
        rsmd = rs.getMetaData();
        AlterTableTest.assertTrue((boolean)rsmd.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)rsmd.isNullable(2));
        rs.close();
        s.execute("insert into t0(c1) values 1,2,3");
        s.execute("insert into t0(c1, id) values (9, 10)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"9", "10"}});
        this.rollback();
        s.execute("insert into t0 values 1");
        s.execute("alter table t0 add column id int generated by default as identity");
        JDBC.assertSingleValueResultSet(s.executeQuery("select id from t0"), "1");
        s.execute("insert into t0(c1) values 5,6,7");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 where c1 > 1 order by c1"), new String[][]{{"5", "2"}, {"6", "3"}, {"7", "4"}});
        this.rollback();
        this.assertCompileError("42XA9", "alter table t0 add column id generated always as identity");
        s.execute("insert into t0 values 1,2,3,4");
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, s, "alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        this.rollback();
        s.execute("insert into t0 values 1,2,3");
        s.execute("alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "30000"}, {"2", "31000"}, {"3", "32000"}});
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, s, "insert into t0(c1) values 4");
        this.rollback();
        s.execute("alter table t0 add column id int generated always as identity");
        s.execute("insert into t0(c1) values 1");
        s.execute("alter table t0 drop column id");
        rs = s.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertSingleValueResultSet(rs, "1");
        this.rollback();
        s.execute("alter table t0 add column id int generated always as identity");
        s.execute("alter table t0 drop column id");
        s.execute("drop table t0");
        this.rollback();
        s.execute("alter table t0_1 add column id int primary key generated always as identity");
        this.rollback();
    }

    public void testAddIdentityColumn5() throws SQLException {
        Statement s = this.createStatement();
        this.createTestObjects(s);
        this.commit();
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        this.rollback();
        s.execute("alter table t0 add column id int generated by default as identity");
        ResultSet rs = s.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1", "ID");
        ResultSetMetaData rsmd = rs.getMetaData();
        AlterTableTest.assertTrue((boolean)rsmd.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)rsmd.isNullable(2));
        rs.close();
        this.rollback();
        s.execute("insert into t0 values 1");
        s.execute("alter table t0 add column id int generated by default as identity");
        JDBC.assertSingleValueResultSet(s.executeQuery("select id from t0"), "1");
        s.execute("insert into t0(c1) values 5,6,7");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 where c1 > 1 order by c1"), new String[][]{{"5", "2"}, {"6", "3"}, {"7", "4"}});
        this.rollback();
    }

    public void testAddIdentityColumn4() throws SQLException {
        Statement s = this.createStatement();
        this.createTestObjects(s);
        this.commit();
        s.execute("alter table t0 add column id int generated always as identity (start with 100, increment by 5)");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        this.rollback();
        s.execute("alter table t0 add column id int generated by default as identity");
        ResultSet rs = s.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1", "ID");
        ResultSetMetaData rsmd = rs.getMetaData();
        AlterTableTest.assertTrue((boolean)rsmd.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)rsmd.isNullable(2));
        rs.close();
        s.execute("insert into t0(c1) values 1,2,3");
        s.execute("insert into t0(c1, id) values (9, 10)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"9", "10"}});
        this.rollback();
        s.execute("insert into t0 values 1");
        s.execute("alter table t0 add column id int generated by default as identity");
        JDBC.assertSingleValueResultSet(s.executeQuery("select id from t0"), "1");
        s.execute("insert into t0(c1) values 5,6,7");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 where c1 > 1 order by c1"), new String[][]{{"5", "2"}, {"6", "3"}, {"7", "4"}});
        this.rollback();
    }

    public void testAddIdentityColumn3() throws SQLException {
        Statement s = this.createStatement();
        this.createTestObjects(s);
        this.commit();
        s.execute("insert into t0 values 1,2,3,4,5");
        s.execute("alter table t0 add column id int generated always as identity (start with 100, increment by 5)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "100"}, {"2", "105"}, {"3", "110"}, {"4", "115"}, {"5", "120"}});
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "125"}, {"2", "130"}, {"3", "135"}});
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        this.rollback();
        s.execute("alter table t0 add column id int generated by default as identity");
        ResultSet rs = s.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1", "ID");
        ResultSetMetaData rsmd = rs.getMetaData();
        AlterTableTest.assertTrue((boolean)rsmd.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)rsmd.isNullable(2));
        rs.close();
        s.execute("insert into t0(c1) values 1,2,3");
        s.execute("insert into t0(c1, id) values (9, 10)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"9", "10"}});
        this.rollback();
        s.execute("insert into t0 values 1");
        s.execute("alter table t0 add column id int generated by default as identity");
        JDBC.assertSingleValueResultSet(s.executeQuery("select id from t0"), "1");
        s.execute("insert into t0(c1) values 5,6,7");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 where c1 > 1 order by c1"), new String[][]{{"5", "2"}, {"6", "3"}, {"7", "4"}});
        this.rollback();
        this.assertCompileError("42XA9", "alter table t0 add column id generated always as identity");
        s.execute("insert into t0 values 1,2,3,4");
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, s, "alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        this.rollback();
        s.execute("insert into t0 values 1,2,3");
        s.execute("alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "30000"}, {"2", "31000"}, {"3", "32000"}});
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, s, "insert into t0(c1) values 4");
        this.rollback();
        s.execute("alter table t0 add column id int generated always as identity");
        s.execute("insert into t0(c1) values 1");
        s.execute("alter table t0 drop column id");
        rs = s.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertSingleValueResultSet(rs, "1");
        this.rollback();
        s.execute("alter table t0 add column id int generated always as identity");
        s.execute("alter table t0 drop column id");
        s.execute("drop table t0");
        this.rollback();
        s.execute("alter table t0_1 add column id int primary key generated always as identity");
        this.rollback();
    }

    public void testAddIdentityColumn2() throws SQLException {
        Statement s = this.createStatement();
        this.createTestObjects(s);
        this.commit();
        s.execute("alter table t0 add column id int generated always as identity");
        ResultSet rs = s.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1", "ID");
        ResultSetMetaData rsmd = rs.getMetaData();
        AlterTableTest.assertTrue((boolean)rsmd.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)rsmd.isNullable(2));
        rs.close();
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t0(c1, id) values (1, 1)");
        s.execute("insert into t0(c1, id) values (1, default)");
        s.execute("insert into t0(c1) values 2,3,4");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}});
        this.assertCompileError("428C1", "alter table t0 add column id2 bigint generated always as identity");
        s.execute("create table table_with_identity(id int generated always as identity)");
        this.assertCompileError("428C1", "alter table table_with_identity add column id2 bigint generated always as identity");
        this.rollback();
        s.execute("insert into t0 values 1,2,3,4,5");
        s.execute("alter table t0 add column id int generated always as identity (start with 100, increment by 5)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "100"}, {"2", "105"}, {"3", "110"}, {"4", "115"}, {"5", "120"}});
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "125"}, {"2", "130"}, {"3", "135"}});
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        s.execute("delete from t0");
        s.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        this.rollback();
        s.execute("alter table t0 add column id int generated by default as identity");
        rs = s.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1", "ID");
        rsmd = rs.getMetaData();
        AlterTableTest.assertTrue((boolean)rsmd.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)rsmd.isNullable(2));
        rs.close();
        s.execute("insert into t0(c1) values 1,2,3");
        s.execute("insert into t0(c1, id) values (9, 10)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"9", "10"}});
        this.rollback();
        s.execute("insert into t0 values 1");
        s.execute("alter table t0 add column id int generated by default as identity");
        JDBC.assertSingleValueResultSet(s.executeQuery("select id from t0"), "1");
        s.execute("insert into t0(c1) values 5,6,7");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 where c1 > 1 order by c1"), new String[][]{{"5", "2"}, {"6", "3"}, {"7", "4"}});
        this.rollback();
        this.assertCompileError("42XA9", "alter table t0 add column id generated always as identity");
        s.execute("insert into t0 values 1,2,3,4");
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, s, "alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        this.rollback();
        s.execute("insert into t0 values 1,2,3");
        s.execute("alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        JDBC.assertFullResultSet(s.executeQuery("select * from t0 order by id"), new String[][]{{"1", "30000"}, {"2", "31000"}, {"3", "32000"}});
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, s, "insert into t0(c1) values 4");
        this.rollback();
        s.execute("alter table t0 add column id int generated always as identity");
        s.execute("insert into t0(c1) values 1");
        s.execute("alter table t0 drop column id");
        rs = s.executeQuery("select * from t0");
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertSingleValueResultSet(rs, "1");
        this.rollback();
        s.execute("alter table t0 add column id int generated always as identity");
        s.execute("alter table t0 drop column id");
        s.execute("drop table t0");
        this.rollback();
        s.execute("alter table t0_1 add column id int primary key generated always as identity");
        this.rollback();
    }

    public void testDropObjects() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create table tab1 (c1 int, c2 int not null constraint tab1pk primary key, c3 double, c4 int)");
        st.executeUpdate("create index i11 on tab1 (c1)");
        st.executeUpdate("create unique index i12 on tab1 (c1)");
        st.executeUpdate("create index i13 on tab1 (c3, c1, c4)");
        st.executeUpdate("create unique index i14 on tab1 (c3, c1)");
        st.executeUpdate("insert into tab1 values (6, 5, 4.5, 90)");
        st.executeUpdate("insert into tab1 values (10, 3, 8.9, -5)");
        st.executeUpdate("insert into tab1 values (100, 15, 4.5, 9)");
        st.executeUpdate("insert into tab1 values (2, 8, 4.4, 8)");
        st.executeUpdate("insert into tab1 values (11, 9, 2.5, 88)");
        st.executeUpdate("insert into tab1 values(null,10, 3.5, 99)");
        st.executeUpdate("create view vw1 (col_sum, col_diff) as select c1+c4, c1-c4 from tab1");
        st.executeUpdate("create view vw2 (c1) as select c3 from tab1");
        st.executeUpdate("create table tab2 (c1 int not null unique, c2 double, c3 int, c4 int not null constraint c4_PK primary key, c5 int, constraint t2ck check (c2+c3<100.0))");
        st.executeUpdate("create table tab3 (c1 int, c2 int, c3 int, c4 int,constraint t3fk foreign key (c2) references tab2(c1), constraint t3ck check (c2-c3<80))");
        st.executeUpdate("create view vw3 (c1, c2) as select c5, tab3.c4 from tab2, tab3 where tab3.c1 > 0");
        st.executeUpdate(" create view vw4 (c1) as select c4 from tab3 where c2 > 8");
        st.executeUpdate("create table tab4 (c1 int, c2 int, c3 int, c4 int)");
        st.executeUpdate("create table tab5 (c1 int)");
        st.executeUpdate("insert into tab4 values (1,2,3,4)");
        st.executeUpdate("create trigger tr1 after update of c2, c3, c4 on tab4 for each row insert into tab5 values (1)");
        st.executeUpdate("create trigger tr2 after update of c3, c4 on tab4 for each row insert into tab5 values (2)");
        st.executeUpdate("drop trigger tr1");
        ResultSet rs = st.executeQuery("select * from tab5");
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertDrainResults(rs, 0);
        AlterTableTest.assertUpdateCount(st, 1, "update tab4 set c3 = 33");
        AlterTableTest.assertUpdateCount(st, 1, " update tab4 set c4 = 44");
        rs = st.executeQuery("select * from tab5");
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertFullResultSet(rs, new String[][]{{"2"}, {"2"}});
        st.executeUpdate("drop trigger tr2");
        AlterTableTest.assertUpdateCount(st, 1, "update tab4 set c4 = 444");
        rs = st.executeQuery("select * from tab2");
        String[] expColNames = new String[]{"C1", "C2", "C3", "C4", "C5"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("drop view vw2");
        st.executeUpdate("create view vw2 (c1) as select c3 from tab1");
        st.executeUpdate("drop view vw1");
        AlterTableTest.assertStatementError("42X05", st, "select * from vw1");
        st.executeUpdate("create index i13 on tab1 (c3, c1, c4)");
        this.checkWarning(st, "01504");
        st.executeUpdate("create unique index i14 on tab1 (c3, c1)");
        this.checkWarning(st, "01504");
        st.executeUpdate("create unique index i12 on tab1 (c1)");
        this.checkWarning(st, "01504");
        rs = st.executeQuery("select c2, c3, c4 from tab1 order by c3");
        expColNames = new String[]{"C2", "C3", "C4"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"9", "2.5", "88"}, {"10", "3.5", "99"}, {"8", "4.4", "8"}, {"15", "4.5", "9"}, {"5", "4.5", "90"}, {"3", "8.9", "-5"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop index i12");
        st.executeUpdate("drop index i13");
        st.executeUpdate("drop index i14");
        st.executeUpdate("insert into tab1 (c2, c3, c4) values (22, 8.9, 5)");
        st.executeUpdate("insert into tab1 (c2, c3, c4) values (11, 4.5, 67)");
        rs = st.executeQuery("select c2 from tab1");
        expColNames = new String[]{"C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"3"}, {"5"}, {"8"}, {"9"}, {"10"}, {"11"}, {"15"}, {"22"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("alter table tab1 add column c5 double");
        st.executeUpdate("drop view vw2");
        st.executeUpdate(" create view vw2 (c1) as select c5 from tab1 where c2 > 5");
        st.executeUpdate("drop view vw2");
        st.executeUpdate("alter table tab1 drop constraint tab1pk");
        rs = st.executeQuery("select c4 from tab1 order by 1");
        expRS = new String[][]{{"-5"}, {"5"}, {"8"}, {"9"}, {"67"}, {"88"}, {"90"}, {"99"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create index i13 on tab1 (c3, c1, c4)");
        st.executeUpdate("alter table tab2 drop constraint t2ck");
        st.executeUpdate("alter table tab3 drop constraint t3fk");
        st.executeUpdate("alter table tab2 drop constraint c4_PK");
        st.executeUpdate("insert into tab3 values (1,2,3,4)");
        st.executeUpdate("drop view vw3");
        st.executeUpdate("insert into tab3 (c1, c2, c3) values (81, 1, 2)");
        st.executeUpdate("insert into tab3 (c1, c2, c3) values (81, 2, 2)");
        st.executeUpdate("alter table tab3 drop constraint t3ck");
        st.executeUpdate("drop view vw4");
        st.executeUpdate("insert into tab3 (c2, c3) values (-82, 9)");
        st.executeUpdate(" create view vw4 (c1) as select c3 from tab3 where c3+5>c4");
        st.executeUpdate("drop view vw4");
        this.rollback();
        st.executeUpdate("create table tt1(a int, b int not null constraint tt1uc unique)");
        st.executeUpdate(" create table reftt1(a int constraint reftt1rc references tt1(b))");
        rs = st.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where t.tableid = c.tableid and t.tablename = 'REFTT1'");
        JDBC.assertSingleValueResultSet(rs, "2");
        st.executeUpdate("alter table reftt1 drop constraint reftt1rc");
        st.executeUpdate("alter table tt1 drop constraint tt1uc");
        rs = st.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where t.tableid = c.tableid and t.tablename = 'REFTT1'");
        JDBC.assertSingleValueResultSet(rs, "1");
        this.rollback();
    }

    public void testAddConstraint() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("alter table t0 add column c3 int");
        AlterTableTest.assertStatementError("42831", st, " alter table t0 add constraint cons1 primary key(c3)");
        AlterTableTest.assertStatementError("42831", st, " alter table t0 add primary key(c3)");
        AlterTableTest.assertStatementError("42X14", st, "alter table t4 add constraint t4pk primary key(\"c1\")");
        AlterTableTest.assertStatementError("42X14", st, " alter table t4 add constraint t4uq unique(\"c1\")");
        AlterTableTest.assertStatementError("42X14", st, " alter table t4 add constraint t4fk foreign key (\"c1\") references t0");
        AlterTableTest.assertStatementError("42X04", st, " alter table t4 add constraint t4ck check (\"c1\" <> 4)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, st, "alter table t4 add primary key(c1)");
        st.executeUpdate("alter table t0_1 add column c2 int not null constraint p2 primary key default 0");
        st.executeUpdate("insert into t0_1 values (1, 1)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, st, "insert into t0_1 values (1, 1)");
        ResultSet rs = st.executeQuery("select * from t0_1");
        JDBC.assertColumnNames(rs, "C1", "C2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "1"}});
        st.executeUpdate("alter table t0_1 add column c3 int check(c3 != 3)");
        st.executeUpdate("insert into t0_1 values (1, 2, 1)");
        AlterTableTest.assertStatementError("23513", st, "insert into t0_1 values (1, 3, 3)");
        st.executeUpdate("insert into t0_1 values (1, 4, 1)");
        rs = st.executeQuery("select c1,c3 from t0_1");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", null}, {"1", "1"}, {"1", "1"}});
        st.executeUpdate("alter table t0_1 add column c4 int");
        st.executeUpdate("delete from t0_1");
        st.executeUpdate("insert into t0_1 values (1, 5,1,1)");
        st.executeUpdate("insert into t0_1 values (2, 6,1,2)");
        st.executeUpdate(" alter table t0_1 add constraint ck1 check(c4 = c1)");
        rs = st.executeQuery("select c1,c4 from t0_1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "1"}, {"2", "2"}});
        AlterTableTest.assertStatementError("23513", st, "insert into t0_1(c1,c4) values (1, 3)");
        st.executeUpdate("drop table t0_1");
        st.executeUpdate("create table t0_1 (c1 int)");
        st.executeUpdate("alter table t0_1 add column c2 int");
        st.executeUpdate("insert into t0_1 values (1, 1)");
        st.executeUpdate("insert into t0_1 values (2, 2)");
        st.executeUpdate("insert into t0_1 values (2, 2)");
        st.executeUpdate("insert into t0_1 values (666, 2)");
        st.executeUpdate("insert into t0_1 values (2, 2)");
        st.executeUpdate("insert into t0_1 values (3, 3)");
        st.executeUpdate("insert into t0_1 values (666, 3)");
        st.executeUpdate("insert into t0_1 values (666, 3)");
        st.executeUpdate("insert into t0_1 values (3, 3)");
        AlterTableTest.assertStatementError("X0Y59", st, " alter table t0_1 add constraint ck1 check(c2 = c1)");
        st.executeUpdate("insert into t0_1 values (1, 3)");
        rs = st.executeQuery(" select * from t0_1");
        String[] expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "1"}, {"2", "2"}, {"2", "2"}, {"666", "2"}, {"2", "2"}, {"3", "3"}, {"666", "3"}, {"666", "3"}, {"3", "3"}, {"1", "3"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create table t0_4(c1 int)");
        st.executeUpdate("alter table t0_4 add column c2 int not null constraint p2 primary key default 0");
        st.executeUpdate("alter table t0_4 add check(c2 = c1)");
        st.executeUpdate("insert into t0_4 values (1, 1)");
        AlterTableTest.assertStatementError("23513", st, "insert into t0_4 values (1, 2)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, st, "insert into t0_4 values (1, 1)");
        AlterTableTest.assertStatementError("23513", st, "insert into t0_4 values (2, 1)");
        st.executeUpdate("insert into t0_4 values (2, 2)");
        rs = st.executeQuery("select * from t0_4");
        JDBC.assertColumnNames(rs, "C1", "C2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "1"}, {"2", "2"}});
        st.executeUpdate("drop table t0_4");
        st.executeUpdate("alter table t3 add column c3 int");
        st.executeUpdate("alter table t3 add unique(c3)");
        st.executeUpdate("alter table t0_2 add column c2 int not null unique default 0");
        st.executeUpdate("insert into t0_2 values (1, default)");
        st.executeUpdate("insert into t0_2 values (1, 1)");
        AlterTableTest.assertUpdateCount(st, 1, " delete from t1_1");
        st.executeUpdate("alter table t1_1 add column c2 int not null unique default 0");
        st.executeUpdate("insert into t1_1 values (1, 2)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, st, " insert into t1_1 values (1, 2)");
        st.executeUpdate("insert into t1_1 values (1, 1)");
        st.executeUpdate("alter table t3 add unique(c1)");
        this.assertCompileError("42Y55", "alter table xxx add check(c2 = 1)");
        st.executeUpdate("create table xxx(c1 int, c2 int)");
        PreparedStatement pSt = this.prepareStatement("alter table xxx add check(c2 = 1)");
        AlterTableTest.assertUpdateCount(pSt, 0);
        st.executeUpdate("drop table xxx");
        st.executeUpdate("create table xxx(c1 int)");
        AlterTableTest.assertStatementError("42X04", pSt);
        st.executeUpdate("alter table xxx add column c2 int");
        AlterTableTest.assertUpdateCount(pSt, 0);
        st.executeUpdate("drop table xxx");
        rs = st.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T'");
        expColNames = new String[]{"TABLENAME", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T0", "1"}, {"T0_1", "1"}, {"T0_2", "1"}, {"T0_3", "1"}, {"T1", "1"}, {"T1_1", "1"}, {"T2", "1"}, {"T3", "1"}, {"T4", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
    }

    public void testDropConstraint() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        AlterTableTest.assertStatementError("42X86", st, "alter table t0 drop constraint notexists");
        AlterTableTest.assertStatementError("42X86", st, "alter table t1 drop constraint p1");
        AlterTableTest.assertStatementError("42831", st, "alter table t0_1 add constraint p2 primary key(c1)");
        AlterTableTest.assertStatementError("42X86", st, " alter table t0_1 drop constraint p2");
        st.executeUpdate("alter table t0_1 add column c2 int not null constraint p2 primary key default 0");
        AlterTableTest.assertUpdateCount(st, 0, "delete from t0_1");
        st.executeUpdate("alter table t0_1 drop constraint p2");
        st.executeUpdate("alter table t0_1 add constraint p2 primary key(c2)");
        st.executeUpdate("alter table t0_1 drop constraint p2");
        st.executeUpdate("alter table t0_1 add constraint p2 primary key(c2)");
        st.executeUpdate("insert into t0_1 values (1,1)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, st, "insert into t0_1 values (1,1)");
        ResultSet rs = st.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T' and tablename = 'T0_1'");
        String[] expColNames = new String[]{"TABLENAME", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"T0_1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        PreparedStatement pSt = this.prepareStatement("alter table t0_1 drop constraint p2");
        AlterTableTest.assertUpdateCount(pSt, 0);
        st.executeUpdate("drop table t0_1");
        st.executeUpdate(" create table t0_1 (c1 int, c2 int not null constraint p2 primary key)");
        AlterTableTest.assertUpdateCount(pSt, 0);
        rs = st.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('SYS', tablename) from sys.systables where tabletype = 'S' and tablename != 'SYSDUMMY1' order by tablename");
        expRS = new String[][]{{"SYSALIASES", "1"}, {"SYSCHECKS", "1"}, {"SYSCOLPERMS", "1"}, {"SYSCOLUMNS", "1"}, {"SYSCONGLOMERATES", "1"}, {"SYSCONSTRAINTS", "1"}, {"SYSDEPENDS", "1"}, {"SYSFILES", "1"}, {"SYSFOREIGNKEYS", "1"}, {"SYSKEYS", "1"}, {"SYSPERMS", "1"}, {"SYSROLES", "1"}, {"SYSROUTINEPERMS", "1"}, {"SYSSCHEMAS", "1"}, {"SYSSEQUENCES", "1"}, {"SYSSTATEMENTS", "1"}, {"SYSSTATISTICS", "1"}, {"SYSTABLEPERMS", "1"}, {"SYSTABLES", "1"}, {"SYSTRIGGERS", "1"}, {"SYSUSERS", "1"}, {"SYSVIEWS", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T'");
        expRS = new String[][]{{"T0", "1"}, {"T0_2", "1"}, {"T0_3", "1"}, {"T1", "1"}, {"T1_1", "1"}, {"T2", "1"}, {"T3", "1"}, {"T4", "1"}, {"T0_1", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st.executeUpdate("create table b793 (pn1 int not null constraint named_primary primary key, pn2 int constraint named_pn2 check (pn2 > 3))");
        st.executeUpdate("alter table b793 drop constraint named_primary");
        st.executeUpdate("drop table b793");
        st.executeUpdate("drop table t1");
        st.executeUpdate(" create table t1(a int not null constraint t1_pri primary key)");
        st.executeUpdate(" create table reft1(a int constraint t1_ref references t1(a))");
        rs = st.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where c.tableid = t.tableid and t.tablename = 'REFT1'");
        JDBC.assertSingleValueResultSet(rs, "2");
        st.executeUpdate("alter table reft1 drop constraint t1_ref");
        st.executeUpdate("alter table t1 drop constraint t1_pri");
        rs = st.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where c.tableid = t.tableid and t.tablename = 'REFT1'");
        JDBC.assertSingleValueResultSet(rs, "1");
        st.executeUpdate("drop table reft1");
        st.executeUpdate("drop view v2");
        st.executeUpdate("drop view v1");
        st.executeUpdate("drop table t0");
        st.executeUpdate("drop table t0_1");
        st.executeUpdate("drop table t0_2");
        st.executeUpdate("drop table t0_3");
        st.executeUpdate("drop table t1");
        st.executeUpdate("drop table t1_1");
        st.executeUpdate("drop table t3");
        st.executeUpdate("drop table t4");
    }

    public void testWithSchema() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create schema newschema");
        AlterTableTest.assertStatementError("42Y55", st, "drop table x");
        st.executeUpdate("create table x (x int not null, y int not null)");
        st.executeUpdate("alter table x add constraint NEWCONS primary key (x)");
        ResultSet rs = st.executeQuery("select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "NEWCONS"}});
        AlterTableTest.assertStatementError(DUPLICATE_KEY, st, " insert into x values (1,1),(1,1)");
        st.executeUpdate(" alter table x drop constraint TEST_DBO.newcons");
        st.executeUpdate(" alter table x add constraint newcons primary key (x)");
        rs = st.executeQuery("select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "NEWCONS"}});
        AlterTableTest.assertStatementError("42Y07", st, "alter table x drop constraint badschema.newcons");
        AlterTableTest.assertStatementError("42X86", st, "alter table x drop constraint newschema.newcons");
        st.executeUpdate("alter table x drop constraint TEST_DBO.newcons");
        AlterTableTest.assertStatementError("42X85", st, "alter table x add constraint badschema.newcons primary key (x)");
        st.executeUpdate("drop table x");
        st.executeUpdate("create table x (x int not null, y int not null)");
        st.executeUpdate("alter table x add constraint con check (x > 1)");
        AlterTableTest.assertStatementError("42X85", st, " alter table x add constraint newschema.con check (x > 1)");
        rs = st.executeQuery(" select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "CON"}});
        st.executeUpdate("set schema emptyschema");
        AlterTableTest.assertStatementError("42X86", st, "alter table TEST_DBO.x drop constraint emptyschema.con");
        rs = st.executeQuery(" select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "CON"}});
        st.executeUpdate(" set schema newschema");
        st.executeUpdate("alter table TEST_DBO.x add constraint con2 check (x > 1)");
        rs = st.executeQuery("select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1,2");
        JDBC.assertFullResultSet(rs, new String[][]{{"TEST_DBO", "CON"}, {"TEST_DBO", "CON2"}, {"TEST_DBO", "P1"}});
        st.executeUpdate("drop table TEST_DBO.x");
        st.executeUpdate("drop schema newschema restrict");
    }

    public void testTemporaryTable() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        AlterTableTest.assertUpdateCount(st, 0, "declare global temporary table session.t1 (c11 int) not logged");
        AlterTableTest.assertUpdateCount(st, 0, " declare global temporary table session.t2 (c21 int) on commit delete rows not logged");
        AlterTableTest.assertUpdateCount(st, 0, " declare global temporary table session.t3 (c31 int) on commit preserve rows not logged");
        st.executeUpdate("drop table session.t1");
        st.executeUpdate("drop table session.t2");
        st.executeUpdate("drop table session.t3");
        AlterTableTest.assertStatementError("42Y55", st, "drop table session.t1");
        st.executeUpdate("drop table t1");
        st.executeUpdate("create table t1(c1 int, c2 int not null primary key)");
        st.executeUpdate("insert into t1 values (1, 1)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, st, "insert into t1 values (1, 1)");
        st.executeUpdate("alter table t1 drop primary key");
        st.executeUpdate("insert into t1 values (1, 1)");
        ResultSet rs = st.executeQuery("select * from t1");
        String[] expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "1"}, {"1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        AlterTableTest.assertStatementError("42X86", st, " alter table t1 drop primary key");
        AlterTableTest.assertStatementError("42X86", st, " alter table t1 drop constraint emptyschema.C1");
        AlterTableTest.assertStatementError("42Y07", st, " alter table t1 drop constraint nosuchschema.C2");
        AlterTableTest.assertStatementError("42X85", st, " alter table t1 add constraint emptyschema.C1_PLUS_C2 check ((c1 + c2) < 100)");
        st.executeUpdate(" alter table t1 add constraint C1_PLUS_C2 check ((c1 + c2) < 100)");
        PreparedStatement pSt = this.prepareStatement("alter table t1 drop constraint C1_PLUS_C2");
        st.executeUpdate(" alter table TEST_DBO.t1 drop constraint TEST_DBO.C1_PLUS_C2");
        AlterTableTest.assertStatementError("42X86", pSt);
        st.executeUpdate(" drop table t1");
        st.executeUpdate("create table LOGGED(c11 int)");
        st.executeUpdate("drop table LOGGED");
        st.executeUpdate("create table logged(logged int)");
        st.executeUpdate("drop table logged");
        AlterTableTest.assertUpdateCount(st, 0, " declare global temporary table session.logged(logged int) on commit delete rows not logged");
    }

    public void testRenameAutoincrementColumn() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set schema app");
        st.executeUpdate("create table d4693(a int generated always as identity, b int)");
        this.vetSequenceState("D4693", "INTEGER NOT NULL", 1L, 1L, 1L);
        st.executeUpdate("insert into d4693 (b) values (1)");
        st.executeUpdate("rename column d4693.a to a2");
        this.vetSequenceState("D4693", "INTEGER NOT NULL", 2L, 1L, 1L);
        st.executeUpdate("insert into d4693 (b) values (2)");
        JDBC.assertFullResultSet(st.executeQuery("select a2, b from d4693 order by a2"), new String[][]{{"1", "1"}, {"2", "2"}});
        st.executeUpdate("drop table d4693");
        String[] colspecs = new String[]{"autoinc int generated always as identity (start with 100)", "autoinc1 int generated always as identity (increment by 100)", "autoinc2 int generated always as identity (start with 101, increment by 100)", "a11 int generated always as identity (start with  0, increment by -1)", "a21 int generated always as identity (start with  +0, increment by -1)", "a31 int generated always as identity (start with  -1, increment by -1)", "a41 int generated always as identity (start with  -11, increment by +100)"};
        String[] cn = new String[]{"AUTOINC", "AUTOINC1", "AUTOINC2", "A11", "A21", "A31", "A41"};
        String[] val = new String[]{"100", "1", "101", "0", "0", "-1", "-11"};
        String[] start = new String[]{"100", "1", "101", "0", "0", "-1", "-11"};
        String[] inc = new String[]{"1", "100", "100", "-1", "-1", "-1", "100"};
        for (int i = 0; i < colspecs.length; ++i) {
            st.executeUpdate("create table d4693 (" + colspecs[i] + ")");
            this.checkValStartInc(st, cn[i], val[i], start[i], inc[i]);
            st.executeUpdate("rename column d4693." + cn[i] + " to " + cn[i] + "2");
            this.checkValStartInc(st, cn[i] + "2", val[i], start[i], inc[i]);
            st.executeUpdate("drop table d4693");
        }
    }

    private void vetSequenceState(String tableName, String columnDatatype, long currentValue, long startValue, long stepValue) throws Exception {
        Connection conn = this.getConnection();
        String sequenceName = IdentitySequenceTest.getIdentitySequenceName(conn, tableName);
        ResultSet rs = conn.prepareStatement("select s.sequenceDatatype, s.startValue, s.increment\nfrom sys.syssequences s\nwhere sequenceName = '" + sequenceName + "'").executeQuery();
        String[][] expectedRows = new String[][]{{columnDatatype, Long.toString(startValue), Long.toString(stepValue)}};
        JDBC.assertFullResultSet(rs, expectedRows);
        rs = conn.prepareStatement("values syscs_util.syscs_peek_at_identity( 'APP', '" + tableName.toUpperCase() + "' )").executeQuery();
        expectedRows = new String[][]{{Long.toString(currentValue)}};
        JDBC.assertFullResultSet(rs, expectedRows);
    }

    private void checkValStartInc(Statement st, String nm, String v, String s, String inc) throws Exception {
        JDBC.assertFullResultSet(st.executeQuery("select autoincrementvalue,autoincrementstart,autoincrementinc from sys.syscolumns where columnname = '" + nm + "' and       referenceid in (select tableid              from sys.systables where tablename = 'D4693')"), new String[][]{{v, s, inc}});
    }

    private void testAlterColumnNullability(Statement st, boolean standardSyntax) throws SQLException {
        int i;
        String setNotNull = standardSyntax ? "SET NOT NULL" : "NOT NULL";
        String dropNotNull = standardSyntax ? "DROP NOT NULL" : "NULL";
        st.executeUpdate("create table atmcn_1 (a integer, b integer not null)");
        AlterTableTest.assertStatementError("23502", st, "insert into atmcn_1 (a) values (1)");
        st.executeUpdate("insert into atmcn_1 values (1,1)");
        ResultSet rs = st.executeQuery("select * from atmcn_1");
        String[] expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("alter table atmcn_1 alter column a " + setNotNull);
        AlterTableTest.assertStatementError("23502", st, "insert into atmcn_1 (b) values (2)");
        st.executeUpdate("insert into atmcn_1 values (2,2)");
        rs = st.executeQuery("select * from atmcn_1");
        expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("alter table atmcn_1 alter column b " + dropNotNull);
        st.executeUpdate("insert into atmcn_1 (a) values (1)");
        rs = st.executeQuery("select * from atmcn_1");
        expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}, {"2", "2"}, {"1", null}};
        JDBC.assertFullResultSet(rs, expRS, true);
        AlterTableTest.assertStatementError("X0Y80", st, "alter table atmcn_1 alter column b " + setNotNull);
        st.executeUpdate("create table atmcn_2 (a integer not null primary key, b integer not null)");
        AlterTableTest.assertStatementError("42Z20", st, " alter table atmcn_2 alter column a " + dropNotNull);
        st.executeUpdate(" create table atmcn_3 (a integer not null, b integer not null)");
        st.executeUpdate(" alter table atmcn_3 add constraint atmcn_3_pk primary key(a, b)");
        AlterTableTest.assertStatementError("42Z20", st, " alter table atmcn_3 alter column b " + dropNotNull);
        st.executeUpdate("create table atmcn_4 (a integer not null, b integer)");
        st.executeUpdate("alter table atmcn_4 alter a " + dropNotNull);
        st.executeUpdate("create table atmcn_5 (a integer not null, b integer not null unique)");
        st.executeUpdate("alter table atmcn_5 alter column b " + dropNotNull);
        st.execute("create table atmcn_6 (a integer not null, b integer)");
        for (i = 0; i < 2; ++i) {
            st.execute("alter table atmcn_6 alter column a " + setNotNull);
            st.execute("alter table atmcn_6 alter column b " + dropNotNull);
            rs = st.executeQuery("select * from atmcn_6");
            JDBC.assertNullability(rs, new boolean[]{false, true});
            JDBC.assertEmpty(rs);
        }
        for (i = 0; i < 2; ++i) {
            st.execute("alter table atmcn_6 alter column a " + dropNotNull);
            st.execute("alter table atmcn_6 alter column b " + setNotNull);
            rs = st.executeQuery("select * from atmcn_6");
            JDBC.assertNullability(rs, new boolean[]{true, false});
            JDBC.assertEmpty(rs);
        }
        this.assertCompileError("42X01", "alter table t alter column c set null");
        this.assertCompileError("42X01", "alter table t alter column c drop null");
        this.rollback();
    }

    public void testAlterColumn() throws Exception {
        int i;
        this.setAutoCommit(false);
        Statement st = this.createStatement();
        this.createTestObjects(st);
        this.testAlterColumnNullability(st, true);
        this.testAlterColumnNullability(st, false);
        st.executeUpdate("create table atmod_1 (a integer, b varchar(10))");
        st.executeUpdate("insert into atmod_1 values (1, 'one')");
        st.executeUpdate("alter table atmod_1 alter column a default -1");
        st.executeUpdate("insert into atmod_1 values (default, 'minus one')");
        st.executeUpdate("insert into atmod_1 (b) values ('b')");
        ResultSet rs = st.executeQuery("select * from atmod_1");
        JDBC.assertColumnNames(rs, "A", "B");
        Object[][] expRS = new String[][]{{"1", "one"}, {"-1", "minus one"}, {"-1", "b"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("alter table atmod_1 alter a default 42");
        st.executeUpdate("insert into atmod_1 values(3, 'three')");
        st.executeUpdate("insert into atmod_1 values (default, 'forty two')");
        rs = st.executeQuery("select * from atmod_1");
        JDBC.assertColumnNames(rs, "A", "B");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "one"}, {"-1", "minus one"}, {"-1", "b"}, {"3", "three"}, {"42", "forty two"}});
        st.executeUpdate("create table renc_1 (a int, b varchar(10), c timestamp, d double)");
        AlterTableTest.assertStatementError("42Y55", st, "rename column renc_no_such.a to b");
        AlterTableTest.assertStatementError("42X14", st, "rename column renc_1.no_such to e");
        AlterTableTest.assertStatementError("X0Y32", st, "rename column renc_1.a to c");
        AlterTableTest.assertStatementError("X0Y32", st, "rename column renc_1.b to b");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1.a to select");
        AlterTableTest.assertStatementError("42X62", st, "rename column sys.sysconglomerates.isindex to is_an_index");
        st.executeUpdate("create view renc_vw_1 (v1, v2) as select b, d from renc_1");
        AlterTableTest.assertStatementError("42Y62", st, " rename column renc_vw_1.v2 to v3");
        st.executeUpdate("create index renc_idx_1 on renc_1 (c, d)");
        AlterTableTest.assertStatementError("42Y55", st, " rename column renc_idx_1.d to d_new");
        AlterTableTest.assertStatementError("42Y55", st, "rename column renc_1 to b");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1 rename a to b");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1.a");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1.a b");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1.a to");
        AlterTableTest.assertStatementError("42X01", st, "rename column renc_1.a to b, c");
        AlterTableTest.assertStatementError("42X01", st, " rename column renc_1.a to b and c to d");
        st.executeUpdate("create table renc_2(c1 int not null constraint renc_2_p1 primary key)");
        st.executeUpdate("rename column renc_2.c1 to c2");
        DatabaseMetaData dbmd = this.getConnection().getMetaData();
        rs = dbmd.getColumns(null, null, "RENC_2", "C2");
        AlterTableTest.assertTrue((boolean)rs.next());
        AlterTableTest.assertEquals((String)"C2", (String)rs.getString("COLUMN_NAME"));
        AlterTableTest.assertEquals((String)"INTEGER", (String)rs.getString("TYPE_NAME"));
        AlterTableTest.assertEquals((String)"0", (String)rs.getString("DECIMAL_DIGITS"));
        AlterTableTest.assertEquals((String)"10", (String)rs.getString("NUM_PREC_RADIX"));
        AlterTableTest.assertEquals((String)"10", (String)rs.getString("COLUMN_SIZE"));
        AlterTableTest.assertEquals(null, (String)rs.getString("COLUMN_DEF"));
        AlterTableTest.assertEquals(null, (String)rs.getString("CHAR_OCTET_LENGTH"));
        AlterTableTest.assertEquals((String)"NO", (String)rs.getString("IS_NULLABLE"));
        AlterTableTest.assertFalse((boolean)rs.next());
        if (AlterTableTest.usingEmbedded()) {
            dbmd = this.getConnection().getMetaData();
            rs = dbmd.getIndexInfo(null, null, "RENC_2", false, false);
            AlterTableTest.assertTrue((boolean)rs.next());
            AlterTableTest.assertEquals((String)"RENC_2", (String)rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"C2", (String)rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)rs.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)rs.next());
        }
        rs = st.executeQuery(" select c.constraintname, c.type from sys.sysconstraints c, sys.systables t where t.tableid = c.tableid and t.tablename = 'RENC_2'");
        JDBC.assertFullResultSet(rs, new String[][]{{"RENC_2_P1", "P"}});
        st.executeUpdate(" create table renc_3 (a integer not null, b integer not null, c int, constraint renc_3_pk primary key(a, b))");
        st.executeUpdate("rename column renc_3.b to newbie");
        dbmd = this.getConnection().getMetaData();
        rs = dbmd.getColumns(null, null, "RENC_3", "NEWBIE");
        AlterTableTest.assertTrue((boolean)rs.next());
        AlterTableTest.assertEquals((String)"NEWBIE", (String)rs.getString("COLUMN_NAME"));
        AlterTableTest.assertEquals((String)"INTEGER", (String)rs.getString("TYPE_NAME"));
        AlterTableTest.assertEquals((String)"0", (String)rs.getString("DECIMAL_DIGITS"));
        AlterTableTest.assertEquals((String)"10", (String)rs.getString("NUM_PREC_RADIX"));
        AlterTableTest.assertEquals((String)"10", (String)rs.getString("COLUMN_SIZE"));
        AlterTableTest.assertEquals(null, (String)rs.getString("COLUMN_DEF"));
        AlterTableTest.assertEquals(null, (String)rs.getString("CHAR_OCTET_LENGTH"));
        AlterTableTest.assertEquals((String)"NO", (String)rs.getString("IS_NULLABLE"));
        AlterTableTest.assertFalse((boolean)rs.next());
        if (AlterTableTest.usingEmbedded()) {
            dbmd = this.getConnection().getMetaData();
            rs = dbmd.getIndexInfo(null, null, "RENC_3", false, false);
            AlterTableTest.assertTrue((boolean)rs.next());
            AlterTableTest.assertEquals((String)"RENC_3", (String)rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"A", (String)rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)rs.getString("PAGES"));
            AlterTableTest.assertTrue((boolean)rs.next());
            AlterTableTest.assertEquals((String)"RENC_3", (String)rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"NEWBIE", (String)rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)rs.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)rs.next());
        }
        rs = st.executeQuery(" select c.constraintname, c.type from sys.sysconstraints c, sys.systables t where t.tableid = c.tableid and t.tablename = 'RENC_3'");
        JDBC.assertFullResultSet(rs, new String[][]{{"RENC_3_PK", "P"}});
        st.executeUpdate(" create table renc_4 (c1 int not null unique, c2 double, c3 int, c4 int not null constraint renc_4_c4_PK primary key, c5 int, c6 int, constraint renc_4_t2ck check (c2+c3<100.0))");
        st.executeUpdate(" create table renc_5 (c1 int, c2 int, c3 int, c4 int, c5 int not null, c6 int, constraint renc_5_t3fk foreign key (c2) references renc_4(c4), constraint renc_5_unq unique(c5), constraint renc_5_t3ck check (c2-c3<80))");
        st.executeUpdate("rename column renc_4.c1 to unq_c1");
        if (AlterTableTest.usingEmbedded()) {
            dbmd = this.getConnection().getMetaData();
            rs = dbmd.getIndexInfo(null, null, "RENC_4", false, false);
            AlterTableTest.assertTrue((boolean)rs.next());
            AlterTableTest.assertEquals((String)"RENC_4", (String)rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"UNQ_C1", (String)rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)rs.getString("PAGES"));
            AlterTableTest.assertTrue((boolean)rs.next());
            AlterTableTest.assertEquals((String)"RENC_4", (String)rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"C4", (String)rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)rs.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)rs.next());
        }
        st.executeUpdate("rename column renc_5.c5 to unq_c5");
        if (AlterTableTest.usingEmbedded()) {
            dbmd = this.getConnection().getMetaData();
            rs = dbmd.getIndexInfo(null, null, "RENC_5", false, false);
            AlterTableTest.assertTrue((boolean)rs.next());
            AlterTableTest.assertEquals((String)"RENC_5", (String)rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"UNQ_C5", (String)rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)rs.getString("PAGES"));
            AlterTableTest.assertTrue((boolean)rs.next());
            AlterTableTest.assertEquals((String)"RENC_5", (String)rs.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"C2", (String)rs.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"true", (String)rs.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)rs.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)rs.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)rs.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)rs.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)rs.next());
        }
        AlterTableTest.assertStatementError("42Z97", st, "rename column renc_4.c2 to some_other_name");
        st.executeUpdate("create trigger renc_5_tr1 after update of c2, c3, c6 on renc_4 for each row mode db2sql insert into renc_5 (unq_c5, c6) values (1, 2)");
        AlterTableTest.assertStatementError("X0Y25", st, "rename column renc_4.c6 to some_name");
        AlterTableTest.assertStatementError("X0Y25", st, "rename column renc_5.c6 to new_name");
        st.executeUpdate("insert into renc_4 values(1, 2, 3, 4, 5, 6)");
        st.executeUpdate("update renc_4 set c6 = 92");
        rs = st.executeQuery("select * from renc_5");
        JDBC.assertColumnNames(rs, "C1", "C2", "C3", "C4", "UNQ_C5", "C6");
        JDBC.assertFullResultSet(rs, new String[][]{{null, null, null, null, "1", "2"}});
        st.executeUpdate("create table renc_6 (a int, b int, c int)");
        st.executeUpdate("grant select (a, b) on renc_6 to eranda");
        rs = st.executeQuery(" select p.grantee,p.type, p.columns from sys.syscolperms p, sys.systables t where t.tableid=p.tableid and t.tablename='RENC_6'");
        JDBC.assertFullResultSet(rs, new String[][]{{"ERANDA", "s", "{0, 1}"}});
        st.executeUpdate("rename column renc_6.b to bb_gun");
        rs = st.executeQuery(" select p.grantee,p.type, p.columns from sys.syscolperms p, sys.systables t where t.tableid=p.tableid and t.tablename='RENC_6'");
        JDBC.assertFullResultSet(rs, new String[][]{{"ERANDA", "s", "{0, 1}"}});
        PreparedStatement ps_renc_c1 = this.prepareStatement("select * from renc_6");
        ResultSet renc_c1 = ps_renc_c1.executeQuery();
        if (AlterTableTest.usingEmbedded()) {
            AlterTableTest.assertStatementError("X0X95", st, " rename column renc_6.bb_gun to water_pistol");
        }
        renc_c1.close();
        ps_renc_c1.close();
        this.setAutoCommit(false);
        PreparedStatement pSt = this.prepareStatement("select * from renc_6 where a = ?");
        rs = st.executeQuery("values (30)");
        rs.next();
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i2 = 1; i2 <= rsmd.getColumnCount(); ++i2) {
            pSt.setObject(i2, rs.getObject(i2));
        }
        rs = pSt.executeQuery();
        String[] expColNames = new String[]{"A", "BB_GUN", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate(" rename column renc_6.a to abcdef");
        rs = st.executeQuery("values (30)");
        rs.next();
        rsmd = rs.getMetaData();
        for (int i3 = 1; i3 <= rsmd.getColumnCount(); ++i3) {
            pSt.setObject(i3, rs.getObject(i3));
        }
        AlterTableTest.assertStatementError("42X04", pSt);
        this.setAutoCommit(true);
        st.executeUpdate("create table renc_7 (c1 varchar(50), c2 int)");
        st.executeUpdate("create synonym renc_7_syn for renc_7");
        st.executeUpdate("insert into renc_7 values ('one', 1)");
        AlterTableTest.assertStatementError("42Y55", st, " rename column renc_7_syn.c2 to c2_syn");
        st.executeUpdate("rename column renc_7.c1 to c1_renamed");
        rs = st.executeQuery("select c1_renamed from renc_7_syn");
        expColNames = new String[]{"C1_RENAMED"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"one"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create schema renc_schema_1");
        st.executeUpdate("create schema renc_schema_2");
        st.executeUpdate("set schema renc_schema_2");
        st.executeUpdate("create table renc_8 (a int, b int, c int)");
        st.executeUpdate("set schema renc_schema_1");
        AlterTableTest.assertStatementError("42Y55", st, "rename column renc_8.b to bbb");
        st.executeUpdate("rename column renc_schema_2.renc_8.b to b2");
        this.setAutoCommit(false);
        st.executeUpdate("create table derby_3823_t1 (c11 int, c12 varchar(5))");
        PreparedStatement ps = this.prepareStatement("insert into derby_3823_t1 values(?,'aaaaa')");
        for (i = 0; i < 1000; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        this.commit();
        rs = st.executeQuery("select * from derby_3823_t1");
        for (i = 0; i < 100; ++i) {
            rs.next();
        }
        rsmd = rs.getMetaData();
        AlterTableTest.assertEquals((int)5, (int)rsmd.getColumnDisplaySize(2));
        Statement st1 = this.createStatement();
        AlterTableTest.assertStatementError("22001", st1, "insert into derby_3823_t1 values(99,'12345678')");
        if (AlterTableTest.usingEmbedded()) {
            AlterTableTest.assertStatementError("X0X95", st1, "alter table derby_3823_t1 alter column c12 set data type varchar(8)");
        } else {
            st1.execute("alter table derby_3823_t1 alter column c12 set data type varchar(8)");
            rsmd = rs.getMetaData();
            AlterTableTest.assertEquals((int)5, (int)rsmd.getColumnDisplaySize(2));
            st1.executeUpdate("insert into derby_3823_t1 values(99,'12345678')");
        }
    }

    public void testAlterTableAndSysdepends() throws Exception {
        Statement st = this.createStatement();
        this.createTableAndInsertData(st, "Derby5120_tab", "C11", "C12");
        this.createTableAndInsertData(st, "Derby5120_tab_bkup1", "C111", "C112");
        this.createTableAndInsertData(st, "Derby5120_tab_bkup2", "C211", "C212");
        int sysdependsRowCountBeforeTestStart = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger Derby5120_tr1 after update of c11 on Derby5120_tab referencing  old_table as old for each statement insert into Derby5120_tab_bkup1 select * from old");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)(sysdependsRowCountBeforeTestStart + 7), (int)this.numberOfRowsInSysdepends(st));
        st.executeUpdate(" create trigger Derby5120_tr2 after update of c11 on Derby5120_tab referencing  old as oldrow for each row insert into  Derby5120_tab_bkup2(c211) values (oldrow.c11)");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)(sysdependsRowCountBeforeTestStart + 14), (int)this.numberOfRowsInSysdepends(st));
        st.executeUpdate("update Derby5120_tab set c11=2");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)(sysdependsRowCountBeforeTestStart + 14), (int)this.numberOfRowsInSysdepends(st));
        st.executeUpdate("alter table Derby5120_tab add column c113 int");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)(sysdependsRowCountBeforeTestStart + 14), (int)this.numberOfRowsInSysdepends(st));
        AlterTableTest.assertStatementError("42802", st, " update Derby5120_tab set c11=2");
        st.executeUpdate("drop trigger Derby5120_tr1");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS will be less", (int)(sysdependsRowCountBeforeTestStart + 7), (int)this.numberOfRowsInSysdepends(st));
        st.executeUpdate("update Derby5120_tab set c11=2");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)(sysdependsRowCountBeforeTestStart + 7), (int)this.numberOfRowsInSysdepends(st));
    }

    public void testTriggersAndSynonyms() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table atdcSynonymTab_1 (c11 integer, c12 integer)");
        st.executeUpdate("create table atdcSynonymTab_2 (c21 integer, c22 integer)");
        st.executeUpdate("CREATE SYNONYM synonymTab2 FOR atdcSynonymTab_2");
        st.executeUpdate("create trigger syn_tr1t1 after update of c11 on atdcSynonymTab_1 for each row mode db2sql insert into atdcSynonymTab_2(c21, c22) values(9,9)");
        JDBC.assertEmpty(st.executeQuery(" select * from atdcSynonymTab_1"));
        JDBC.assertEmpty(st.executeQuery(" select * from synonymTab2"));
        st.executeUpdate(" insert into atdcSynonymTab_1 values(11,12)");
        st.executeUpdate(" update atdcSynonymTab_1 set c11=99");
        JDBC.assertFullResultSet(st.executeQuery("select * from synonymTab2"), new String[][]{{"9", "9"}});
        st.executeUpdate(" delete from atdcSynonymTab_1");
        st.executeUpdate(" delete from synonymTab2");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdcSynonymTab_2 drop column c21 restrict");
        JDBC.assertEmpty(st.executeQuery(" select * from atdcSynonymTab_1"));
        JDBC.assertEmpty(st.executeQuery(" select * from synonymTab2"));
        st.executeUpdate(" insert into atdcSynonymTab_1 values(11,12)");
        st.executeUpdate(" update atdcSynonymTab_1 set c11=99");
        JDBC.assertFullResultSet(st.executeQuery("select * from synonymTab2"), new String[][]{{"9", "9"}});
        st.executeUpdate(" delete from atdcSynonymTab_1");
        st.executeUpdate(" delete from synonymTab2");
        st.executeUpdate(" alter table atdcSynonymTab_2 drop column c21");
        JDBC.assertEmpty(st.executeQuery(" select * from atdcSynonymTab_1"));
        JDBC.assertEmpty(st.executeQuery(" select * from synonymTab2"));
        st.executeUpdate(" insert into atdcSynonymTab_1 values(11,12)");
        st.executeUpdate(" update atdcSynonymTab_1 set c11=99");
        JDBC.assertEmpty(st.executeQuery(" select * from synonymTab2"));
    }

    public void testDropColumnTriggerDependency() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create table atdctd_1 (c11 integer, c12 integer)");
        st.executeUpdate("create table atdctd_2 (c21 integer, c22 integer)");
        st.executeUpdate("create table atdctd_3 (c31 integer, c32 integer)");
        st.executeUpdate("create trigger tr1t1 after update of c11 on atdctd_1 for each row mode db2sql insert into atdctd_3(c31, c32) values(9,9)");
        st.executeUpdate("create trigger tr1t2 after insert on atdctd_2 for each row mode db2sql insert into atdctd_3(c31, c32) select c11, c12 from atdctd_1");
        st.executeUpdate("create trigger tr2t2 after insert on atdctd_2 for each row mode db2sql insert into atdctd_3(c31) select c11 from atdctd_1");
        JDBC.assertEmpty(st.executeQuery(" select * from atdctd_3"));
        st.executeUpdate(" insert into atdctd_1 values(11,12)");
        st.executeUpdate(" update atdctd_1 set c11=99");
        JDBC.assertFullResultSet(st.executeQuery("select * from atdctd_3"), new String[][]{{"9", "9"}});
        st.executeUpdate(" insert into atdctd_2 values(21,22)");
        JDBC.assertFullResultSet(st.executeQuery("select * from atdctd_3 order by c32"), new String[][]{{"9", "9"}, {"99", "12"}, {"99", null}});
        st.executeUpdate(" delete from atdctd_3");
        st.executeUpdate(" delete from atdctd_1");
        st.executeUpdate(" delete from atdctd_2");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdctd_1 drop column c11 restrict");
        JDBC.assertEmpty(st.executeQuery(" select * from atdctd_3"));
        st.executeUpdate(" insert into atdctd_1 values(11,12)");
        st.executeUpdate(" update atdctd_1 set c11=99");
        JDBC.assertFullResultSet(st.executeQuery("select * from atdctd_3"), new String[][]{{"9", "9"}});
        st.executeUpdate(" insert into atdctd_2 values(21,22)");
        JDBC.assertFullResultSet(st.executeQuery("select * from atdctd_3 order by c32"), new String[][]{{"9", "9"}, {"99", "12"}, {"99", null}});
        st.executeUpdate(" delete from atdctd_3");
        st.executeUpdate(" delete from atdctd_1");
        st.executeUpdate(" delete from atdctd_2");
        st.executeUpdate(" alter table atdctd_1 drop column c11");
        JDBC.assertEmpty(st.executeQuery(" select * from atdctd_3"));
        st.executeUpdate(" insert into atdctd_1 values(12)");
        st.executeUpdate(" update atdctd_1 set c12=99");
        JDBC.assertEmpty(st.executeQuery(" select * from atdctd_3"));
        st.executeUpdate(" insert into atdctd_2 values(21,22)");
        JDBC.assertEmpty(st.executeQuery(" select * from atdctd_3"));
    }

    public void testDropColumn() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create table atdc_0 (a integer)");
        st.executeUpdate("create table atdc_1 (a integer, b integer)");
        st.executeUpdate("insert into atdc_1 values (1, 1)");
        JDBC.assertFullResultSet(st.executeQuery(" select * from atdc_1"), new String[][]{{"1", "1"}});
        ResultSet rs = st.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(rs, new String[][]{{"A", "1", "INTEGER"}, {"B", "2", "INTEGER"}});
        st.executeUpdate("alter table atdc_1 drop column b");
        rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(rs, "A");
        JDBC.assertSingleValueResultSet(rs, "1");
        rs = st.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(rs, new String[][]{{"A", "1", "INTEGER"}});
        st.executeUpdate("alter table atdc_1 add column b varchar (20)");
        st.executeUpdate("insert into atdc_1 values (1, 'new val')");
        st.executeUpdate("insert into atdc_1 (a, b) values (2, 'two val')");
        rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(rs, "A", "B");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", null}, {"1", "new val"}, {"2", "two val"}});
        rs = st.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(rs, new String[][]{{"A", "1", "INTEGER"}, {"B", "2", "VARCHAR(20)"}});
        st.executeUpdate("alter table atdc_1 add column c integer");
        st.executeUpdate("insert into atdc_1 values (3, null, 3)");
        rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(rs, "A", "B", "C");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", null, null}, {"1", "new val", null}, {"2", "two val", null}, {"3", null, "3"}});
        st.executeUpdate("alter table atdc_1 drop b");
        rs = st.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(rs, "A", "C");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", null}, {"1", null}, {"2", null}, {"3", "3"}});
        rs = st.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(rs, new String[][]{{"A", "1", "INTEGER"}, {"C", "2", "INTEGER"}});
        st.executeUpdate("create table atdc_1_01 (a int, b int, c int not null primary key)");
        st.executeUpdate("alter table atdc_1_01 drop column c cascade");
        if (AlterTableTest.usingEmbedded()) {
            this.checkWarning(st, "01500");
        }
        st.executeUpdate(" create table atdc_1_02 (a int not null primary key, b int)");
        st.executeUpdate(" create table atdc_1_03 (a03 int, constraint a03_fk foreign key (a03) references atdc_1_02(a))");
        st.executeUpdate(" alter table atdc_1_02 drop column a cascade");
        if (AlterTableTest.usingEmbedded()) {
            this.checkWarning(st, "01500");
        }
        st.executeUpdate("alter table atdc_1 add constraint atdc_constraint_1 check (a > 0)");
        rs = st.executeQuery(" select CONSTRAINTNAME,TYPE,STATE,REFERENCECOUNT from sys.sysconstraints where tableid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(rs, new String[][]{{"ATDC_CONSTRAINT_1", "C", "E", "0"}});
        rs = st.executeQuery(" select sc.CHECKDEFINITION,sc.REFERENCEDCOLUMNS from sys.syschecks sc,sys.sysconstraints con,  sys.systables st where sc.constraintid = con.constraintid and con.tableid = st.tableid and st.tablename = 'ATDC_1'");
        JDBC.assertFullResultSet(rs, new String[][]{{"(a > 0)", "(1)"}});
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_1 drop column a restrict");
        st.executeUpdate("alter table atdc_1 drop column a cascade");
        this.checkWarning(st, "01500");
        rs = st.executeQuery(" select * from sys.sysconstraints where tableid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("create table atdc_1_constraints (a int not null primary key, b int not null, c int constraint atdc_1_c_chk check (c is not null), d int not null unique, e int, f int, constraint atdc_1_e_fk foreign key (e) references atdc_1_constraints(a))");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_1_constraints drop column a restrict");
        st.executeUpdate(" alter table atdc_1_constraints drop column b restrict");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_1_constraints drop column c restrict");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_1_constraints drop column d restrict");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_1_constraints drop column e restrict");
        st.executeUpdate("alter table atdc_1_constraints drop column a cascade");
        this.checkWarning(st, "01500");
        st.executeUpdate(" alter table atdc_1_constraints drop column c cascade");
        this.checkWarning(st, "01500");
        st.executeUpdate(" alter table atdc_1_constraints drop column d cascade");
        this.checkWarning(st, "01500");
        st.executeUpdate(" alter table atdc_1_constraints drop column e cascade");
        AlterTableTest.assertStatementError("42Y55", st, "alter table atdc_nosuch drop column a");
        st.executeUpdate("create table atdc_2 (a integer)");
        AlterTableTest.assertStatementError("42X14", st, "alter table atdc_2 drop column b");
        AlterTableTest.assertStatementError("42X14", st, "alter table atdc_2 drop b");
        AlterTableTest.assertStatementError("42X01", st, "alter table atdc_2 drop column 'a'");
        AlterTableTest.assertStatementError("42X01", st, "alter table atdc_2 drop column column");
        AlterTableTest.assertStatementError("42X01", st, "alter table atdc_2 drop column");
        AlterTableTest.assertStatementError("42X01", st, " alter table atdc_2 drop column constraint");
        AlterTableTest.assertStatementError("42X01", st, " alter table atdc_2 drop column primary");
        AlterTableTest.assertStatementError("42X01", st, " alter table atdc_2 drop column foreign");
        AlterTableTest.assertStatementError("42X01", st, " alter table atdc_2 drop column check");
        st.executeUpdate("create table atdc_3 (a integer)");
        st.executeUpdate("create index atdc_3_idx_1 on atdc_3 (a)");
        AlterTableTest.assertStatementError("X0Y25", st, "alter table atdc_3 drop column a restrict");
        st.executeUpdate("drop index atdc_3_idx_1");
        st.executeUpdate("create table atdc_4 (a int, b int, c int, d int, e int)");
        st.executeUpdate("insert into atdc_4 values (1,2,3,4,5)");
        st.executeUpdate("create index atdc_4_idx_1 on atdc_4 (a)");
        st.executeUpdate("create index atdc_4_idx_2 on atdc_4 (b, c, d)");
        st.executeUpdate("create index atdc_4_idx_3 on atdc_4 (c, a)");
        rs = st.executeQuery(" select conglomeratename,isindex from sys.sysconglomerates where tableid in (select tableid from sys.systables where tablename = 'ATDC_4') and isindex='true'");
        JDBC.assertFullResultSet(rs, new String[][]{{"ATDC_4_IDX_1", "true"}, {"ATDC_4_IDX_2", "true"}, {"ATDC_4_IDX_3", "true"}});
        st.executeUpdate("alter table atdc_4 drop column a restrict");
        rs = st.executeQuery(" select conglomeratename,isindex from sys.sysconglomerates where tableid in (select tableid from sys.systables where tablename = 'ATDC_4') and isindex='true'");
        JDBC.assertFullResultSet(rs, new String[][]{{"ATDC_4_IDX_2", "true"}, {"ATDC_4_IDX_3", "true"}});
        st.executeUpdate("alter table atdc_4 drop column c restrict");
        AlterTableTest.assertStatementError("42X04", st, "select * from atdc_4 where c = 3");
        rs = st.executeQuery(" select count(*) from sys.sysconglomerates where conglomeratename='ATDC_4_IDX_2'");
        JDBC.assertSingleValueResultSet(rs, "1");
        rs = st.executeQuery(" select conglomeratename, isindex from sys.sysconglomerates where conglomeratename like 'ATDC_4%'");
        JDBC.assertFullResultSet(rs, new String[][]{{"ATDC_4_IDX_2", "true"}});
        st.executeUpdate("drop index atdc_4_idx_2");
        st.executeUpdate("create table atdc_5 (a int, b int)");
        st.executeUpdate(" create view atdc_vw_1 (vw_b) as select b from atdc_5");
        AlterTableTest.assertStatementError("X0Y23", st, " alter table atdc_5 drop column b restrict");
        rs = st.executeQuery("select * from atdc_vw_1");
        String[] expColNames = new String[]{"VW_B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("alter table atdc_5 drop column b cascade");
        this.checkWarning(st, "01501");
        AlterTableTest.assertStatementError("42X05", st, "select * from atdc_vw_1");
        st.executeUpdate("create table atdc_5a (a int, b int, c int)");
        st.executeUpdate(" create view atdc_vw_5a_1 (vw_5a_b, vw_5a_c) as select b,c from atdc_5a");
        st.executeUpdate(" create view atdc_vw_5a_2 (vw_5a_c_2) as select vw_5a_c from atdc_vw_5a_1");
        st.executeUpdate("alter table atdc_5a drop column b cascade");
        this.checkWarning(st, "01501");
        AlterTableTest.assertStatementError("42X05", st, "select * from atdc_vw_5a_1");
        AlterTableTest.assertStatementError("42X05", st, "select * from atdc_vw_5a_2");
        this.createTableAndInsertData(st, "ATDC_6", "A", "B");
        int sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_6_trigger_1 after update of b on atdc_6 for each row values current_date");
        int sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_6 drop column b restrict");
        this.triggersExist(st, new String[][]{{"ATDC_6_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table atdc_6 drop column b cascade");
        this.checkWarning(st, "01502");
        JDBC.assertEmpty(st.executeQuery(" select triggername from sys.systriggers where triggername='ATDC_6_TRIGGER_1'"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_6");
        this.createTableAndInsertData(st, "ATDC_11", "A", "B");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_11_trigger_1 after update of b on atdc_11 for each row select a,b from atdc_11");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_11 drop column b restrict");
        this.triggersExist(st, new String[][]{{"ATDC_11_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table atdc_11 drop column b cascade");
        this.checkWarning(st, "01502");
        JDBC.assertEmpty(st.executeQuery(" select triggername from sys.systriggers where triggername='ATDC_11_TRIGGER_1'"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_11");
        this.createTableAndInsertData(st, "ATDC_12", "A", "B");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_12_trigger_1 after update of a on atdc_12 for each row select a,b from atdc_12");
        st.executeUpdate(" create trigger atdc_12_trigger_2  after update of a on atdc_12 REFERENCING NEW AS newt OLD AS oldt  for each row select oldt.b from atdc_12");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table atdc_12 drop column b restrict");
        this.triggersExist(st, new String[][]{{"ATDC_12_TRIGGER_1"}, {"ATDC_12_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table atdc_12 drop column b");
        this.checkWarning(st, "01502");
        JDBC.assertEmpty(st.executeQuery(" select triggername from sys.systriggers where triggername in ('ATDC_12_TRIGGER_1', 'ATDC_12_TRIGGER_2')"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_12");
        this.createTableAndInsertData(st, "ATDC_13", "A", "B");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_13_trigger_1 after update on atdc_13 for each row select a,b from atdc_13");
        st.executeUpdate(" create trigger atdc_13_trigger_2 after insert on atdc_13 for each row select a,b from atdc_13");
        st.executeUpdate(" create trigger atdc_13_trigger_3 after delete on atdc_13 for each row select a,b from atdc_13");
        st.executeUpdate(" create trigger atdc_13_trigger_4 after update on atdc_13  REFERENCING NEW AS newt OLD AS oldt  for each row select oldt.b, newt.b from atdc_13");
        st.executeUpdate(" create trigger atdc_13_trigger_5 after insert on atdc_13  REFERENCING NEW AS newt  for each row select newt.b from atdc_13");
        st.executeUpdate(" create trigger atdc_13_trigger_6 after delete on atdc_13  REFERENCING OLD AS oldt  for each row select oldt.b from atdc_13");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table atdc_13 drop column b restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TRIGGER_1"}, {"ATDC_13_TRIGGER_2"}, {"ATDC_13_TRIGGER_3"}, {"ATDC_13_TRIGGER_4"}, {"ATDC_13_TRIGGER_5"}, {"ATDC_13_TRIGGER_6"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table atdc_13 drop column b");
        this.checkWarning(st, "01502");
        JDBC.assertEmpty(st.executeQuery(" select triggername from sys.systriggers where triggername in ('ATDC_13_TRIGGER_1', 'ATDC_13_TRIGGER_2', 'ATDC_13_TRIGGER_3','ATDC_13_TRIGGER_4', 'ATDC_13_TRIGGER_5','ATDC_13_TRIGGER_6')"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_13");
        st.executeUpdate("create table atdc_16_tab1 (a1 integer, b1 integer, c1 integer)");
        st.executeUpdate("create table atdc_16_tab2 (a2 integer, b2 integer, c2 integer)");
        st.executeUpdate("insert into atdc_16_tab1 values(1,11,111)");
        st.executeUpdate("insert into atdc_16_tab2 values(1,11,111)");
        rs = st.executeQuery(" select * from atdc_16_tab1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "11", "111"}});
        rs = st.executeQuery(" select * from atdc_16_tab2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "11", "111"}});
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_16_trigger_1  after update of b1 on atdc_16_tab1 REFERENCING NEW AS newt for each row  update atdc_16_tab2 set c2 = newt.c1");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate("update atdc_16_tab1 set b1=22,c1=222");
        rs = st.executeQuery(" select * from atdc_16_tab1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "22", "222"}});
        rs = st.executeQuery(" select * from atdc_16_tab2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "11", "222"}});
        st.executeUpdate("alter table atdc_16_tab1 drop column a1 restrict");
        st.executeUpdate("update atdc_16_tab1 set b1=33, c1=333");
        rs = st.executeQuery(" select * from atdc_16_tab1");
        JDBC.assertFullResultSet(rs, new String[][]{{"33", "333"}});
        rs = st.executeQuery(" select * from atdc_16_tab2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "11", "333"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("drop table ATDC_16_TAB1");
        st.executeUpdate("drop table ATDC_16_TAB2");
        this.createTableAndInsertData(st, "ATDC_14_TAB1", "A1", "B1");
        this.createTableAndInsertData(st, "ATDC_14_TAB2", "A2", "B2");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_14_trigger_1 after update on atdc_14_tab1 REFERENCING NEW AS newt for each row update atdc_14_tab2 set a2 = newt.a1");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table atdc_14_tab2 drop column a2 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_14_TRIGGER_1"}});
        st.executeUpdate("alter table atdc_14_tab2 drop column a2");
        this.checkWarning(st, "01502");
        JDBC.assertEmpty(st.executeQuery(" select triggername from sys.systriggers where triggername in ('ATDC_14_TRIGGER_1')"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_14_TAB1");
        st.executeUpdate("drop table ATDC_14_TAB2");
        this.createTableAndInsertData(st, "ATDC_13_TAB1", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB1_BACKUP", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB2", "C21", "C22");
        this.createTableAndInsertData(st, "ATDC_13_TAB3", "C31", "C32");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT C31, C32 from ATDC_13_TAB3");
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT * from ATDC_13_TAB3");
        int countAfter2Triggers = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP VALUES(1,1)");
        int countAfter3rdTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_4 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP(C11)  SELECT C21 from ATDC_13_TAB2");
        int countAfter4thTrigger = this.numberOfRowsInSysdepends(st);
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("update ATDC_13_TAB1 set c12=11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        rs = st.executeQuery("select * from ATDC_13_TAB1_BACKUP ORDER BY C11, C12");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "1"}, {"1", "11"}, {"1", "11"}, {"1", "11"}, {"1", null}});
        st.executeUpdate("delete from ATDC_13_TAB1_BACKUP");
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB2 drop column c21 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}, {"ATDC_13_TAB1_TRIGGER_4"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("drop table ATDC_13_TAB1");
        st.executeUpdate("drop table ATDC_13_TAB2");
        st.executeUpdate("drop table ATDC_13_TAB3");
        st.executeUpdate("drop table ATDC_13_TAB1_BACKUP");
        this.createTableAndInsertData(st, "ATDC_13_TAB1", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB1_BACKUP", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB2", "C21", "C22");
        this.createTableAndInsertData(st, "ATDC_13_TAB3", "C31", "C32");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT C31, C32 from ATDC_13_TAB3");
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT * from ATDC_13_TAB3");
        countAfter2Triggers = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP VALUES(1,1)");
        int countAfter3Triggers = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_4 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP(C11)  SELECT C21 from ATDC_13_TAB2");
        int countAfter4Triggers = this.numberOfRowsInSysdepends(st);
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate("update ATDC_13_TAB1 set c12=11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        rs = st.executeQuery("select * from ATDC_13_TAB1_BACKUP ORDER BY C11, C12");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "1"}, {"1", "11"}, {"1", "11"}, {"1", "11"}, {"1", null}});
        st.executeUpdate("delete from ATDC_13_TAB1_BACKUP");
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB2 drop column c21 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}, {"ATDC_13_TAB1_TRIGGER_4"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB2 drop column c21");
        this.checkWarning(st, "01502");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)countAfter3Triggers);
        st.executeUpdate("alter table ATDC_13_TAB2 add column c21 int");
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB1_BACKUP drop column c11 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)countAfter3Triggers);
        st.executeUpdate("alter table ATDC_13_TAB1_BACKUP drop column c11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB1_BACKUP add column c11 int");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row UPDATE ATDC_13_TAB1_BACKUP SET C11=123 WHERE C12>1");
        int countAfter1Trigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row UPDATE ATDC_13_TAB2 SET C21=123");
        countAfter2Triggers = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row UPDATE ATDC_13_TAB3 SET C31=123 WHERE C32 IN (values(1))");
        countAfter3Triggers = this.numberOfRowsInSysdepends(st);
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB3 drop column c31 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB3 drop column c31");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)countAfter2Triggers);
        st.executeUpdate("alter table ATDC_13_TAB3 add column c31 int");
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB2 drop column c21 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)countAfter2Triggers);
        st.executeUpdate("alter table ATDC_13_TAB2 drop column c21");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)countAfter1Trigger);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB1_BACKUP drop column c12 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)countAfter1Trigger);
        st.executeUpdate("alter table ATDC_13_TAB1_BACKUP drop column c12");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB1_BACKUP add column c12 int");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row DELETE FROM ATDC_13_TAB1_BACKUP WHERE C12>1");
        countAfter1Trigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row DELETE FROM ATDC_13_TAB3 WHERE C32 IN (values(1))");
        countAfter2Triggers = this.numberOfRowsInSysdepends(st);
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB3 drop column c32 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB3 drop column c32");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)countAfter1Trigger);
        AlterTableTest.assertStatementError("X0Y25", st, "alter table ATDC_13_TAB1_BACKUP drop column c12 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)countAfter1Trigger);
        st.executeUpdate("alter table ATDC_13_TAB1_BACKUP drop column c12");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountBeforeCreateTrigger);
        st.executeUpdate("drop table ATDC_13_TAB1");
        st.executeUpdate("drop table ATDC_13_TAB1_BACKUP");
        st.executeUpdate("drop table ATDC_13_TAB2");
        st.executeUpdate("drop table ATDC_13_TAB3");
        this.createTableAndInsertData(st, "ATDC_13_TAB1", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB2", "C11", "C12");
        this.createTableAndInsertData(st, "ATDC_13_TAB3", "C11", "C12");
        st.executeUpdate("create view ATDC_13_VIEW1 as select c11 from ATDC_13_TAB2");
        st.executeUpdate("create view ATDC_13_VIEW3 as select * from ATDC_13_TAB2");
        st.executeUpdate("create view ATDC_13_VIEW2 as select c12 from ATDC_13_TAB3 where c12>0");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row SELECT * from ATDC_13_VIEW1 WHERE C11>0");
        countAfter1Trigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row SELECT * from ATDC_13_VIEW3");
        countAfter2Triggers = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row SELECT * from ATDC_13_VIEW2 ");
        countAfter3Triggers = this.numberOfRowsInSysdepends(st);
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        AlterTableTest.assertStatementError("X0Y23", st, "alter table ATDC_13_TAB3 drop column c12 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("alter table ATDC_13_TAB3 drop column c12");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)(countAfter2Triggers - 1));
        AlterTableTest.assertStatementError("X0Y23", st, "alter table ATDC_13_TAB2 drop column c11 restrict");
        this.triggersExist(st, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)(countAfter2Triggers - 1));
        st.executeUpdate("alter table ATDC_13_TAB2 drop column c11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(st), (int)(sysdependsRowCountBeforeCreateTrigger - 3));
        st.executeUpdate("drop table ATDC_13_TAB1");
        st.executeUpdate("drop table ATDC_13_TAB2");
        st.executeUpdate("drop table ATDC_13_TAB3");
        this.createTableAndInsertData(st, "ATDC_15_TAB1", "A1", "B1");
        this.createTableAndInsertData(st, "ATDC_15_TAB2", "A2", "B2");
        sysdependsRowCountBeforeCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate(" create trigger atdc_15_trigger_1 after update on atdc_15_tab1 REFERENCING NEW AS newt for each row update atdc_15_tab2 set b2 = newt.b1");
        sysdependsRowCountAfterCreateTrigger = this.numberOfRowsInSysdepends(st);
        st.executeUpdate("update atdc_15_tab1 set b1=22");
        rs = st.executeQuery(" select * from atdc_15_tab1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "22"}});
        rs = st.executeQuery(" select * from atdc_15_tab2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "22"}});
        st.executeUpdate("alter table atdc_15_tab1 drop column a1 restrict");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(st), (int)sysdependsRowCountAfterCreateTrigger);
        st.executeUpdate("update atdc_15_tab1 set b1=33");
        rs = st.executeQuery(" select * from atdc_15_tab1");
        JDBC.assertFullResultSet(rs, new String[][]{{"33"}});
        rs = st.executeQuery(" select * from atdc_15_tab2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "33"}});
        st.executeUpdate("drop table ATDC_15_TAB1");
        st.executeUpdate("drop table ATDC_15_TAB2");
        st.executeUpdate(" create table atdc_7 (a int, b int, c int, primary key (a))");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_7 drop column a restrict");
        st.executeUpdate(" alter table atdc_7 drop column a cascade");
        this.checkWarning(st, "01500");
        st.executeUpdate(" create table atdc_8 (a int, b int, c int, primary key (b, c))");
        AlterTableTest.assertStatementError("X0Y25", st, " alter table atdc_8 drop column c restrict");
        st.executeUpdate("alter table atdc_8 drop column c cascade");
        this.checkWarning(st, "01500");
        st.executeUpdate("create table atdc_9 (a int not null, b int)");
        st.executeUpdate("alter table atdc_9 drop column a restrict");
        st.executeUpdate("create table atdc_10 (a int, b int, c int)");
        st.executeUpdate("grant select(a, b, c) on atdc_10 to bryan");
        rs = st.executeQuery(" select GRANTEE,GRANTOR,TYPE,COLUMNS from sys.syscolperms");
        JDBC.assertFullResultSet(rs, new String[][]{{"BRYAN", "TEST_DBO", "s", "{0, 1, 2}"}});
        st.executeUpdate("alter table atdc_10 drop column b restrict");
        rs = st.executeQuery(" select GRANTEE,GRANTOR,TYPE,COLUMNS from sys.syscolperms");
        JDBC.assertFullResultSet(rs, new String[][]{{"BRYAN", "TEST_DBO", "s", "{0, 1}"}});
        AlterTableTest.assertStatementError("42X14", st, " alter table atdc_10 drop column b cascade");
        rs = st.executeQuery(" select GRANTEE,GRANTOR,TYPE,COLUMNS from sys.syscolperms");
        JDBC.assertFullResultSet(rs, new String[][]{{"BRYAN", "TEST_DBO", "s", "{0, 1}"}});
        AlterTableTest.assertStatementError("42Y55", st, "drop table d1909");
        st.executeUpdate("create table d1909 (a int, b int, c int)");
        st.executeUpdate("grant select (a) on d1909 to user1");
        st.executeUpdate("grant select (a,b) on d1909 to user2");
        st.executeUpdate("grant update(c) on d1909 to super_user");
        rs = st.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1909'");
        JDBC.assertFullResultSet(rs, new String[][]{{"USER1", "s", "{0}"}, {"USER2", "s", "{0, 1}"}, {"SUPER_USER", "u", "{2}"}});
        st.executeUpdate("alter table d1909 drop column a");
        rs = st.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1909'");
        JDBC.assertFullResultSet(rs, new String[][]{{"USER1", "s", "{}"}, {"USER2", "s", "{0}"}, {"SUPER_USER", "u", "{1}"}});
        st.executeUpdate("grant update(b) on d1909 to user1");
        st.executeUpdate("grant select(c) on d1909 to user1");
        st.executeUpdate("grant select(c) on d1909 to user2");
        rs = st.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1909'");
        JDBC.assertFullResultSet(rs, new String[][]{{"USER1", "s", "{1}"}, {"USER2", "s", "{0, 1}"}, {"SUPER_USER", "u", "{1}"}, {"USER1", "u", "{0}"}});
    }

    private void createTableAndInsertData(Statement s, String tableName, String column1, String column2) throws SQLException {
        s.execute("CREATE TABLE " + tableName + " (" + column1 + " int, " + column2 + " int) ");
        s.execute("INSERT INTO " + tableName + " VALUES (1,11)");
    }

    private int numberOfRowsInSysdepends(Statement st) throws SQLException {
        ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM SYS.SYSDEPENDS");
        rs.next();
        return rs.getInt(1);
    }

    private void triggersExist(Statement st, String[][] expectedTriggers) throws SQLException {
        StringBuffer query = new StringBuffer("select triggername from sys.systriggers where triggername in (");
        for (int i = 0; i < expectedTriggers.length; ++i) {
            query.append("'" + expectedTriggers[i][0] + "'");
            if (i + 1 >= expectedTriggers.length) continue;
            query.append(", ");
        }
        query.append(")");
        ResultSet rs = st.executeQuery(query.toString());
        JDBC.assertFullResultSet(rs, expectedTriggers);
    }

    public void testJira3175() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set schema app");
        st.executeUpdate("create table d3175 (x varchar(12), y varchar(12), id int primary key generated by default as identity)");
        ResultSet rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and t.tablename='D3175'");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"X", "1", "VARCHAR(12)", null, null, null, null, "D3175", "T", "R"}, {"Y", "2", "VARCHAR(12)", null, null, null, null, "D3175", "T", "R"}, {"ID", "3", "INTEGER NOT NULL", "GENERATED_BY_DEFAULT", "1", "1", "1", "D3175", "T", "R"}});
        st.executeUpdate("insert into d3175(x) values 'b'");
        st.executeUpdate("alter table d3175 drop column y");
        st.executeUpdate("insert into d3175(x) values 'a'");
        this.vetSequenceState("D3175", "INTEGER NOT NULL", 3L, 1L, 1L);
    }

    public void testJira3177() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table d3177_SchemaVersion (version INTEGER NOT NULL)");
        st.executeUpdate("insert into d3177_SchemaVersion (version) values (0)");
        st.executeUpdate(" create table d3177_BinaryData ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), CRC32 BIGINT NOT NULL , data BLOB NOT NULL , CONSTRAINT d3177_BinaryData_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" create table d3177_MailServers ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), port INTEGER NOT NULL , username varchar(80) NOT NULL , protocol varchar(80) NOT NULL , SSLProtocol varchar(10), emailAddress varchar(80) NOT NULL , server varchar(80) NOT NULL , password varchar(80) NOT NULL , CONSTRAINT d3177_MailServers_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" create table d3177_Mailboxes ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), port INTEGER NOT NULL , folder varchar(80) NOT NULL , username varchar(80) NOT NULL , SSLProtocol varchar(10), hostname varchar(80) NOT NULL , storeType varchar(80) NOT NULL , password varchar(80) NOT NULL , timeout INTEGER NOT NULL , MailServerID INTEGER NOT NULL , CONSTRAINT d3177_Mailboxes_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" create table d3177_MESSAGES ( Message_From varchar(1000), Message_Cc varchar(1000), Message_Subject varchar(1000), Message_ID varchar(256) NOT NULL , Message_Bcc varchar(1000), Message_Date TIMESTAMP, Content_Type varchar(256), MailboxID INTEGER NOT NULL , Search_Text CLOB NOT NULL , id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), Message_To varchar(1000), Display_Text CLOB NOT NULL , Message_Data_ID INTEGER NOT NULL , CONSTRAINT d3177_MESSAGES_id_pk PRIMARY KEY(id) )");
        ResultSet rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(rs, new String[][]{{"ID", "10", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        st.executeUpdate(" create table D3177_ATTACHMENTS ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), Inline INTEGER, CRC32 BIGINT NOT NULL , Attachment_Name varchar(256) NOT NULL , Attachment_File varchar(512) NOT NULL , Message_ID INTEGER NOT NULL , Content_Type varchar(256) NOT NULL , CONSTRAINT D3177_ATTACHMENTS_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" alter table D3177_ATTACHMENTS ADD CONSTRAINT ATTACHMENTS_Message_ID_MESSAGES_ID FOREIGN KEY ( Message_ID ) REFERENCES D3177_MESSAGES ( ID )");
        st.executeUpdate(" alter table D3177_MESSAGES ADD CONSTRAINT MESSAGES_MailboxID_Mailboxes_ID FOREIGN KEY ( MailboxID ) REFERENCES d3177_Mailboxes ( ID )");
        st.executeUpdate(" alter table D3177_MESSAGES ADD CONSTRAINT MESSAGES_Message_Data_ID_d3177_BinaryData_ID FOREIGN KEY ( Message_Data_ID ) REFERENCES d3177_BinaryData ( ID )");
        st.executeUpdate(" alter table d3177_Mailboxes ADD CONSTRAINT Mailboxes_MailServerID_MailServers_ID FOREIGN KEY ( MailServerID ) REFERENCES d3177_MailServers ( ID )");
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=1");
        st.executeUpdate(" alter table D3177_MESSAGES alter Message_To SET DATA TYPE varchar(10000)");
        st.executeUpdate(" alter table D3177_MESSAGES alter Message_From SET DATA TYPE varchar(10000)");
        st.executeUpdate(" alter table D3177_MESSAGES alter Message_Cc SET DATA TYPE varchar(10000)");
        st.executeUpdate(" alter table D3177_MESSAGES alter Message_Bcc SET DATA TYPE varchar(10000)");
        rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(rs, new String[][]{{"ID", "10", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=2");
        st.executeUpdate(" create table D3177_MailStatistics ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), ProcessedCount INTEGER DEFAULT 0 NOT NULL , HourOfDay INTEGER NOT NULL , LastModified TIMESTAMP NOT NULL , RejectedMailCount INTEGER DEFAULT 0 NOT NULL , DayOfWeek INTEGER NOT NULL , CONSTRAINT D3177_MailStatistics_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" CREATE INDEX D3177_MailStatistics_HourOfDay_idx ON D3177_MailStatistics(HourOfDay)");
        st.executeUpdate(" CREATE INDEX D3177_MailStatistics_DayOfWeek_idx ON D3177_MailStatistics(DayOfWeek)");
        st.executeUpdate(" alter table D3177_MESSAGES alter CONTENT_TYPE SET DATA TYPE varchar(256)");
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=3");
        st.executeUpdate(" alter table D3177_messages alter column Message_ID NULL");
        st.executeUpdate(" CREATE INDEX D3177_MESSAGES_Message_ID_idx ON D3177_MESSAGES(Message_ID)");
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=4");
        st.executeUpdate("alter table D3177_MESSAGES add filename varchar(256)");
        st.executeUpdate("alter table D3177_MESSAGES add CRC32 BIGINT");
        JDBC.assertEmpty(st.executeQuery("select id,crc32,data from d3177_BinaryData"));
        rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(rs, new String[][]{{"ID", "10", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        st.executeUpdate(" alter table D3177_messages alter column filename NOT NULL");
        st.executeUpdate(" alter table D3177_messages alter column crc32 NOT NULL");
        st.executeUpdate(" alter table D3177_messages alter column mailboxid NULL");
        AlterTableTest.assertStatementError("42X86", st, " ALTER TABLE D3177_MESSAGES DROP CONSTRAINT MESSAGES_message_data_id_BinaryData_id");
        st.executeUpdate(" alter table D3177_messages drop column message_data_id");
        this.checkWarning(st, "01500");
        st.executeUpdate("drop table d3177_BinaryData");
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=6");
        st.executeUpdate(" create table D3177_EmailAddresses ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), address varchar(256) NOT NULL , CONSTRAINT D3177_EmailAddresses_id_pk PRIMARY KEY(id), CONSTRAINT D3177_EmailAddresses_address_uq UNIQUE(address) )");
        st.executeUpdate(" CREATE UNIQUE INDEX D3177_EmailAddresses_address_idx ON D3177_EmailAddresses(address)");
        this.checkWarning(st, "01504");
        st.executeUpdate(" create table D3177_EmailAddressesToMessages ( MessageID INTEGER NOT NULL , EmailAddressID INTEGER NOT NULL )");
        st.executeUpdate(" alter table D3177_EmailAddressesToMessages ADD CONSTRAINT EmailAddressesToMessages_MessageID_Messages_ID FOREIGN KEY ( MessageID ) REFERENCES D3177_Messages ( ID )");
        st.executeUpdate(" alter table D3177_EmailAddressesToMessages ADD CONSTRAINT EmailAddressesToMessages_EmailAddressID_EmailAddresses_ID FOREIGN KEY ( EmailAddressID ) REFERENCES D3177_EmailAddresses ( ID )");
        st.executeUpdate(" create table AuthenticationServers ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), port INTEGER NOT NULL , protocol varchar(20) NOT NULL , hostname varchar(40) NOT NULL , CONSTRAINT AuthenticationServers_id_pk PRIMARY KEY(id) )");
        st.executeUpdate(" alter table d3177_Mailboxes add AuthenticationServerID INTEGER");
        JDBC.assertEmpty(st.executeQuery("select id,filename from D3177_messages"));
        st.executeUpdate("alter table D3177_MESSAGES drop column message_to");
        st.executeUpdate("alter table D3177_MESSAGES drop column message_cc");
        st.executeUpdate("alter table D3177_MESSAGES drop column message_from");
        rs = st.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(rs, new String[][]{{"ID", "8", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        AlterTableTest.assertUpdateCount(st, 1, "update d3177_SchemaVersion set version=7");
    }

    public void testJira2371() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table t2371 ( a varchar(10))");
        st.executeUpdate("alter table t2371 alter column a default 'my val'");
        st.executeUpdate("insert into t2371 (a) values ('hi')");
        st.executeUpdate("insert into t2371 (a) values (default)");
        st.executeUpdate("alter table t2371 alter column a default 'another'");
        st.executeUpdate("insert into t2371 (a) values (default)");
        JDBC.assertFullResultSet(st.executeQuery("select A from t2371"), new String[][]{{"hi"}, {"my val"}, {"another"}});
    }

    public void testJira3355() throws Exception {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        st.executeUpdate("create table d3355 ( c1 varchar(10), \"c2\" varchar(10), c3 varchar(10))");
        st.executeUpdate(" create table \"d3355_a\" ( c1 varchar(10), \"c2\" varchar(10), c3 varchar(10))");
        st.executeUpdate(" create table d3355_qt_col (\"\"\"c\"\"4\" int, \"\"\"\"\"C5\" int, \"c 6\" int)");
        st.executeUpdate(" create table \"d3355_qt_\"\"tab\" ( c4 int, c5 int, c6 int)");
        st.executeUpdate("insert into d3355 values ('a', 'b', 'c')");
        st.executeUpdate("insert into \"d3355_a\" values ('d', 'e', 'f')");
        st.executeUpdate("insert into d3355_qt_col values (4, 5, 6)");
        st.executeUpdate("insert into \"d3355_qt_\"\"tab\" values (4, 5, 6)");
        st.executeUpdate("alter table d3355 alter column c1 not null");
        st.executeUpdate("alter table d3355 alter column \"c2\" not null");
        st.executeUpdate("alter table d3355 alter column \"C3\" not null");
        st.executeUpdate("alter table \"d3355_a\" alter column c1 not null");
        st.executeUpdate("alter table \"d3355_a\" alter column \"c2\" not null");
        st.executeUpdate("alter table \"d3355_a\" alter column \"C3\" not null");
        st.executeUpdate(" alter table d3355_qt_col alter column \"\"\"\"\"C5\" not null");
        st.executeUpdate(" alter table d3355_qt_col alter column \"c 6\" not null");
        st.executeUpdate(" alter table \"d3355_qt_\"\"tab\" alter column c5 not null");
        AlterTableTest.assertStatementError("42X14", st, "alter table d3355 alter column \"c1\" not null");
        AlterTableTest.assertStatementError("42X14", st, " alter table d3355 alter column c2 not null");
        AlterTableTest.assertStatementError("42Y55", st, " alter table d3355_a alter column c1 not null");
        AlterTableTest.assertStatementError("42X14", st, " alter table \"d3355_a\" alter column \"c1\" not null");
    }

    public void testJira4256() throws SQLException {
        Statement st = this.createStatement();
        this.createTestObjects(st);
        int val = 1;
        int size = 15360;
        st.executeUpdate("create table clob_tab(c1 int,clob_col clob(10K))");
        this.commit();
        PreparedStatement pSt = this.prepareStatement("INSERT INTO clob_tab values (?,?)");
        TestInputStream stream = new TestInputStream(size, val);
        pSt.setInt(1, val);
        pSt.setAsciiStream(2, (InputStream)stream, size);
        AlterTableTest.assertStatementError("XJ001", pSt);
        pSt.close();
        this.rollback();
        st.executeUpdate("ALTER TABLE clob_tab ALTER COLUMN clob_col SET DATA TYPE clob(20K)");
        pSt = this.prepareStatement("INSERT INTO clob_tab values (?,?)");
        stream = new TestInputStream(size, val);
        pSt.setInt(1, val);
        pSt.setAsciiStream(2, (InputStream)stream, size);
        pSt.executeUpdate();
        pSt.close();
        st.executeUpdate("CREATE TABLE blob_tab ( C1 INTEGER,blob_col BLOB(10K) NOT NULL)");
        this.commit();
        pSt = this.prepareStatement("INSERT INTO blob_tab values (?,?)");
        stream = new TestInputStream(size, val);
        pSt.setInt(1, val);
        pSt.setBinaryStream(2, (InputStream)stream, size);
        AlterTableTest.assertStatementError("22001", pSt);
        pSt.close();
        this.rollback();
        st.executeUpdate("ALTER TABLE blob_tab ALTER COLUMN blob_col SET DATA TYPE blob(20K)");
        pSt = this.prepareStatement("INSERT INTO blob_tab values (?,?)");
        stream = new TestInputStream(size, val);
        pSt.setInt(1, val);
        pSt.setBinaryStream(2, (InputStream)stream, size);
        pSt.executeUpdate();
        pSt.close();
        this.rollback();
    }

    public void testDerby5157_addColumnWithDefaultValue() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create schema \"\"\"\"");
        s.execute("create table \"\"\"\".\"\"\"\" (x int)");
        s.execute("alter table \"\"\"\".\"\"\"\" add column \"\"\"\" int default 42");
    }

    public void testDerby5157_changeIncrement() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create schema \"\"\"\"");
        s.execute("create table \"\"\"\".\"\"\"\"(\"\"\"\" int generated always as identity)");
        s.execute("alter table \"\"\"\".\"\"\"\" alter column \"\"\"\" set increment by 2");
    }

    public void test_5679() throws Exception {
        Statement s = this.createStatement();
        String[][] rowBefore = new String[][]{{"before", null, "before"}};
        String[][] rowAfter = new String[][]{{"after", "after", "after"}};
        s.execute("create table t_5679(name1 varchar(10))");
        s.execute("insert into t_5679(name1) values('before')");
        s.execute("alter table t_5679 add column str1 varchar(10)");
        s.execute("alter table t_5679 add column str2 varchar(10)");
        s.execute("update t_5679 set str2 = 'before'");
        ResultSet rs = s.executeQuery("select * from t_5679");
        JDBC.assertFullResultSet(rs, rowBefore);
        this.setAutoCommit(false);
        s.execute("update t_5679 set name1='after', str1='after', str2='after'");
        rs = s.executeQuery("select * from t_5679");
        JDBC.assertFullResultSet(rs, rowAfter);
        this.rollback();
        this.setAutoCommit(true);
        rs = s.executeQuery("select * from t_5679");
        JDBC.assertFullResultSet(rs, rowBefore);
        s.execute("drop table t_5679");
    }

    public void test_5679_manyColumns() throws Exception {
        Statement s = this.createStatement();
        s.execute("create table t_5679_1( keyCol int )");
        s.execute("insert into t_5679_1( keyCol ) values( 1 )");
        for (int i = 1; i < 100; ++i) {
            s.execute("alter table t_5679_1 add column a_" + i + " int");
        }
        s.execute("update t_5679_1 set a_50 = 50");
        String[] rawBeforeRow = new String[100];
        rawBeforeRow[0] = "1";
        rawBeforeRow[50] = "50";
        String[][] beforeRow = new String[][]{rawBeforeRow};
        String[] rawAfterRow = new String[100];
        rawAfterRow[0] = "1";
        rawAfterRow[49] = "490";
        rawAfterRow[50] = "500";
        rawAfterRow[51] = "510";
        String[][] afterRow = new String[][]{rawAfterRow};
        ResultSet rs = s.executeQuery("select * from t_5679_1");
        JDBC.assertFullResultSet(rs, beforeRow);
        this.setAutoCommit(false);
        s.execute("update t_5679_1 set a_49 = 490, a_50 = 500, a_51 = 510");
        rs = s.executeQuery("select * from t_5679_1");
        JDBC.assertFullResultSet(rs, afterRow);
        this.rollback();
        this.setAutoCommit(true);
        rs = s.executeQuery("select * from t_5679_1");
        JDBC.assertFullResultSet(rs, beforeRow);
        s.execute("drop table t_5679_1");
    }

    public void test_5679_longRows() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = conn.prepareStatement("values syscs_util.syscs_get_database_property( 'derby.storage.pageSize' )");
        ResultSet rs = ps.executeQuery();
        rs.next();
        AlterTableTest.assertNull((Object)rs.getString(1));
        rs.close();
        ps.close();
        int LONG = 1050;
        int SHORT = 500;
        int PAGE_SIZE = 4096;
        byte[] a_0 = this.makeBytes(0, 1050);
        byte[] a_1 = this.makeBytes(1, 1050);
        byte[] a_2 = this.makeBytes(2, 1050);
        byte[] a_4 = this.makeBytes(4, 1050);
        conn.prepareStatement("create table t_5679_2( a_0 varchar( 1050 ) for bit data, a_1 varchar( 1050 ) for bit data, a_2 varchar( 1050 ) for bit data)").execute();
        ps = conn.prepareStatement("insert into t_5679_2( a_0, a_1, a_2 ) values ( ?, ?, ? )");
        ps.setBytes(1, a_0);
        ps.setBytes(2, a_1);
        ps.setBytes(3, a_2);
        ps.executeUpdate();
        ps.close();
        conn.prepareStatement("alter table t_5679_2 add column a_3 varchar( 500 ) for bit data").execute();
        conn.prepareStatement("alter table t_5679_2 add column a_4 varchar( 1050 ) for bit data").execute();
        AlterTableTest.assertTrue((boolean)true);
        AlterTableTest.assertTrue((boolean)true);
        ps = conn.prepareStatement("update t_5679_2 set a_4 = ?");
        ps.setBytes(1, a_4);
        ps.executeUpdate();
        ps.close();
        byte[] after_0 = this.makeBytes(100, 1050);
        byte[] after_1 = this.makeBytes(101, 1050);
        byte[] after_2 = this.makeBytes(102, 1050);
        byte[] after_3 = this.makeBytes(103, 500);
        byte[] after_4 = this.makeBytes(104, 1050);
        byte[][] beforeRow = new byte[][]{a_0, a_1, a_2, null, a_4};
        byte[][] afterRow = new byte[][]{after_0, after_1, after_2, after_3, after_4};
        this.vetBytes_5679(conn, beforeRow);
        conn.setAutoCommit(false);
        ps = conn.prepareStatement("update t_5679_2 set a_0 = ?, a_1 = ?, a_2 = ?, a_3 = ?, a_4 = ?");
        ps.setBytes(1, after_0);
        ps.setBytes(2, after_1);
        ps.setBytes(3, after_2);
        ps.setBytes(4, after_3);
        ps.setBytes(5, after_4);
        ps.executeUpdate();
        this.vetBytes_5679(conn, afterRow);
        this.rollback();
        conn.setAutoCommit(true);
        this.vetBytes_5679(conn, beforeRow);
        conn.prepareStatement("drop table t_5679_2").execute();
    }

    private byte[] makeBytes(int seed, int length) {
        byte[] result = new byte[length];
        Arrays.fill(result, (byte)seed);
        return result;
    }

    private void vetBytes_5679(Connection conn, byte[][] expected) throws Exception {
        PreparedStatement ps = conn.prepareStatement("select * from t_5679_2");
        ResultSet rs = ps.executeQuery();
        rs.next();
        for (int i = 0; i < expected.length; ++i) {
            this.assertBytes(expected[i], rs.getBytes(i + 1));
        }
        rs.close();
        ps.close();
    }

    private void assertBytes(byte[] expected, byte[] actual) throws Exception {
        if (expected == null) {
            AlterTableTest.assertNull((Object)actual);
            return;
        }
        AlterTableTest.assertNotNull((Object)actual);
        AlterTableTest.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            AlterTableTest.assertEquals((byte)expected[i], (byte)actual[i]);
        }
    }

    public void test_6882() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_6882\n(\n  a int generated always as identity,\n  b int\n)\n");
        this.goodStatement(conn, "create table s_6882\n(\n  a int generated by default as identity,\n  b int\n)\n");
        this.goodStatement(conn, "create table u_6882\n(\n  a int,\n  b int\n)\n");
        this.assertCompileError(CANNOT_ALTER_NON_IDENTITY_COLUMN, "alter table u_6882 alter column a set generated by default");
        this.assertCompileError(CANNOT_ALTER_NON_IDENTITY_COLUMN, "alter table u_6882 alter column a set generated always");
        this.goodStatement(conn, "insert into t_6882(b) values (100)");
        this.goodStatement(conn, "insert into s_6882(b) values (100)");
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t_6882(a, b) values (-1, -100)");
        this.goodStatement(conn, "insert into s_6882(a, b) values (-1, -100)");
        this.assertResults(conn, "select * from t_6882 order by a", new String[][]{{"1", "100"}}, false);
        this.assertResults(conn, "select * from s_6882 order by a", new String[][]{{"-1", "-100"}, {"1", "100"}}, false);
        this.goodStatement(conn, "alter table t_6882 alter column a set generated by default");
        this.goodStatement(conn, "alter table s_6882 alter column a set generated always");
        this.goodStatement(conn, "insert into t_6882(a, b) values (-2, -200)");
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into s_6882(a, b) values (-2, -200)");
        this.goodStatement(conn, "insert into t_6882(b) values (200)");
        this.goodStatement(conn, "insert into s_6882(b) values (200)");
        this.assertResults(conn, "select * from t_6882 order by a", new String[][]{{"-2", "-200"}, {"1", "100"}, {"2", "200"}}, false);
        this.assertResults(conn, "select * from s_6882 order by a", new String[][]{{"-1", "-100"}, {"1", "100"}, {"2", "200"}}, false);
        this.goodStatement(conn, "alter table t_6882 alter column a set generated always");
        this.goodStatement(conn, "alter table s_6882 alter column a set generated by default");
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t_6882(a, b) values (-3, -300)");
        this.goodStatement(conn, "insert into s_6882(a, b) values (-3, -300)");
        this.goodStatement(conn, "insert into t_6882(b) values (300)");
        this.goodStatement(conn, "insert into s_6882(b) values (300)");
        this.assertResults(conn, "select * from t_6882 order by a", new String[][]{{"-2", "-200"}, {"1", "100"}, {"2", "200"}, {"3", "300"}}, false);
        this.assertResults(conn, "select * from s_6882 order by a", new String[][]{{"-3", "-300"}, {"-1", "-100"}, {"1", "100"}, {"2", "200"}, {"3", "300"}}, false);
        this.goodStatement(conn, "drop table u_6882");
        this.goodStatement(conn, "drop table s_6882");
        this.goodStatement(conn, "drop table t_6882");
    }

    public void test_6882_import() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table source_6882\n(\n  a int generated always as identity primary key,\n  b int\n)\n");
        this.goodStatement(conn, "create table target_6882\n(\n  a int generated always as identity primary key,\n  b int\n)\n");
        this.goodStatement(conn, "insert into source_6882(b) values (100), (200), (300)");
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into target_6882 select * from source_6882");
        this.goodStatement(conn, "alter table target_6882 alter column a set generated by default");
        this.goodStatement(conn, "insert into target_6882 select * from source_6882");
        this.goodStatement(conn, "alter table target_6882 alter column a set generated always");
        try (PreparedStatement ps = conn.prepareStatement("insert into target_6882(b) values (400)");){
            AlterTableTest.assertPreparedStatementError(DUPLICATE_KEY, ps);
        }
        this.goodStatement(conn, "alter table target_6882 alter column a restart with 4");
        this.goodStatement(conn, "insert into target_6882(b) values (400)");
        this.assertResults(conn, "select * from target_6882 order by a", new String[][]{{"1", "100"}, {"2", "200"}, {"3", "300"}, {"4", "400"}}, false);
        this.goodStatement(conn, "drop table target_6882");
        this.goodStatement(conn, "drop table source_6882");
    }

    public void test_6961_setCycle() throws Exception {
        Connection conn = this.getConnection();
        this.vet_6961_cycling(conn, "t_nc_smallint_asc", "(\n  a smallint generated always as identity (start with 32766 no cycle),\n  b int\n)\n", new String[][]{{"32766", "1"}, {"32767", "2"}, {"-32768", "3"}});
        this.vet_6961_cycling(conn, "t_nc_smallint_desc", "(\n  a smallint generated always as identity (start with -32767 increment by -1 no cycle),\n  b int\n)\n", new String[][]{{"-32767", "1"}, {"-32768", "2"}, {"32767", "3"}});
        this.vet_6961_cycling(conn, "t_nc_int_asc", "(\n  a int generated always as identity (start with 2147483646 no cycle),\n  b int\n)\n", new String[][]{{"2147483646", "1"}, {"2147483647", "2"}, {"-2147483648", "3"}});
        this.vet_6961_cycling(conn, "t_nc_int_desc", "(\n  a int generated always as identity (start with -2147483647 increment by -1 no cycle),\n  b int\n)\n", new String[][]{{"-2147483647", "1"}, {"-2147483648", "2"}, {"2147483647", "3"}});
        this.vet_6961_cycling(conn, "t_nc_bigint_asc", "(\n  a bigint generated always as identity (start with 9223372036854775806 no cycle),\n  b int\n)\n", new String[][]{{"9223372036854775806", "1"}, {"9223372036854775807", "2"}, {"-9223372036854775808", "3"}});
        this.vet_6961_cycling(conn, "t_nc_bigint_desc", "(\n  a bigint generated always as identity (start with -9223372036854775807 increment by -1 no cycle),\n  b int\n)\n", new String[][]{{"-9223372036854775807", "1"}, {"-9223372036854775808", "2"}, {"9223372036854775807", "3"}});
    }

    private void vet_6961_cycling(Connection conn, String tableName, String tableDefinition, String[][] expectedFinalResults) throws Exception {
        this.goodStatement(conn, "create table " + tableName + " " + tableDefinition);
        this.goodStatement(conn, "insert into " + tableName + "(b) values (1)");
        this.goodStatement(conn, "insert into " + tableName + "(b) values (2)");
        String nextInsert = "insert into " + tableName + "(b) values (3)";
        try (PreparedStatement ps = conn.prepareStatement(nextInsert);){
            AlterTableTest.assertPreparedStatementError(EXHAUSTED_IDENTITY_COLUMN, ps);
        }
        this.goodStatement(conn, "alter table " + tableName + " alter column a set cycle");
        this.goodStatement(conn, nextInsert);
        this.assertResults(conn, "select * from " + tableName + " order by b", expectedFinalResults, false);
    }

    public void test_6961_setNoCycle() throws Exception {
        Connection conn = this.getConnection();
        this.vet_6961_noCycling(conn, "t_c_smallint_asc", "(\n  a smallint generated always as identity (start with 32766 cycle),\n  b int\n)\n", new String[][]{{"32766", "1"}, {"32767", "2"}});
        this.vet_6961_noCycling(conn, "t_c_smallint_desc", "(\n  a smallint generated always as identity (start with -32767 increment by -1 cycle),\n  b int\n)\n", new String[][]{{"-32767", "1"}, {"-32768", "2"}});
        this.vet_6961_noCycling(conn, "t_c_int_asc", "(\n  a int generated always as identity (start with 2147483646 cycle),\n  b int\n)\n", new String[][]{{"2147483646", "1"}, {"2147483647", "2"}});
        this.vet_6961_noCycling(conn, "t_c_int_desc", "(\n  a int generated always as identity (start with -2147483647 increment by -1 cycle),\n  b int\n)\n", new String[][]{{"-2147483647", "1"}, {"-2147483648", "2"}});
        this.vet_6961_noCycling(conn, "t_c_bigint_asc", "(\n  a bigint generated always as identity (start with 9223372036854775806 cycle),\n  b int\n)\n", new String[][]{{"9223372036854775806", "1"}, {"9223372036854775807", "2"}});
        this.vet_6961_noCycling(conn, "t_c_bigint_desc", "(\n  a bigint generated always as identity (start with -9223372036854775807 increment by -1 cycle),\n  b int\n)\n", new String[][]{{"-9223372036854775807", "1"}, {"-9223372036854775808", "2"}});
    }

    private void vet_6961_noCycling(Connection conn, String tableName, String tableDefinition, String[][] expectedFinalResults) throws Exception {
        this.goodStatement(conn, "create table " + tableName + " " + tableDefinition);
        this.goodStatement(conn, "insert into " + tableName + "(b) values (1)");
        this.goodStatement(conn, "insert into " + tableName + "(b) values (2)");
        this.goodStatement(conn, "alter table " + tableName + " alter column a set no cycle");
        String nextInsert = "insert into " + tableName + "(b) values (3)";
        try (PreparedStatement ps = conn.prepareStatement(nextInsert);){
            AlterTableTest.assertPreparedStatementError(EXHAUSTED_IDENTITY_COLUMN, ps);
        }
        this.assertResults(conn, "select * from " + tableName + " order by b", expectedFinalResults, false);
    }

    public void test_6961_rollback() throws Exception {
        Connection conn = this.getConnection();
        boolean originalAutocommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        this.goodStatement(conn, "create table t_c_6961_rollback\n(a int generated always as identity (start with 2147483646 cycle), b int)");
        conn.commit();
        this.goodStatement(conn, "insert into t_c_6961_rollback(b) values (1)");
        this.goodStatement(conn, "insert into t_c_6961_rollback(b) values (2)");
        conn.commit();
        this.goodStatement(conn, "alter table t_c_6961_rollback alter column a set no cycle");
        conn.rollback();
        this.goodStatement(conn, "insert into t_c_6961_rollback(b) values (3)");
        this.assertResults(conn, "select * from t_c_6961_rollback order by b", new String[][]{{"2147483646", "1"}, {"2147483647", "2"}, {"-2147483648", "3"}}, false);
        conn.commit();
        conn.setAutoCommit(originalAutocommit);
    }
}

