/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.derby.io.StorageFile;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derby.optional.lucene.DerbyLuceneDir;
import org.apache.derby.optional.lucene.LuceneSupport;
import org.apache.derby.optional.utils.ToolUtilities;
import org.apache.derby.vti.StringColumnVTI;
import org.apache.derby.vti.VTIContext;
import org.apache.derby.vti.VTITemplate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

class LuceneQueryVTI
extends StringColumnVTI {
    private Connection _connection;
    private String _queryText;
    private int _windowSize;
    private Float _scoreCeiling;
    private String _schema;
    private String _table;
    private String _column;
    private ScoreDoc[] _hits;
    private IndexReader _indexReader;
    private IndexSearcher _searcher;
    private int _hitIndex = -1;
    private int _minKeyID;
    private int _maxKeyID;
    private int _docIDColumnID;
    private int _scoreColumnID;
    private boolean _wasNull;

    LuceneQueryVTI(String queryText, int windowSize, Float scoreCeiling) throws SQLException {
        super(null);
        LuceneSupport.checkNotNull("QUERY", queryText);
        this._connection = LuceneSupport.getDefaultConnection();
        this._queryText = queryText;
        this._windowSize = windowSize;
        this._scoreCeiling = scoreCeiling;
    }

    public String getRawColumn(int columnid) throws SQLException {
        this._wasNull = false;
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int docID = scoreDoc.doc;
            if (this.isKeyID(columnid)) {
                return this._searcher.doc(docID).get(this.getColumnName(columnid));
            }
            throw this.invalidColumnPosition(columnid);
        }
        catch (IOException e) {
            throw ToolUtilities.wrap(e);
        }
    }

    public boolean getBoolean(int columnid) throws SQLException {
        String stringValue = this.getRawColumn(columnid);
        if (stringValue == null) {
            this._wasNull = true;
            return false;
        }
        return Boolean.valueOf(stringValue);
    }

    public float getFloat(int columnid) throws SQLException {
        try {
            if (columnid == this._scoreColumnID) {
                return this.getScoreDoc().score;
            }
            if (this.isKeyID(columnid)) {
                Number number = this.getNumberValue(columnid);
                if (number == null) {
                    return 0.0f;
                }
                return number.floatValue();
            }
            throw this.invalidColumnPosition(columnid);
        }
        catch (IOException e) {
            throw ToolUtilities.wrap(e);
        }
    }

    public double getDouble(int columnid) throws SQLException {
        try {
            if (this.isKeyID(columnid)) {
                Number number = this.getNumberValue(columnid);
                if (number == null) {
                    return 0.0;
                }
                return number.doubleValue();
            }
            throw this.invalidColumnPosition(columnid);
        }
        catch (IOException e) {
            throw ToolUtilities.wrap(e);
        }
    }

    public byte getByte(int columnid) throws SQLException {
        return (byte)this.getInt(columnid);
    }

    public short getShort(int columnid) throws SQLException {
        return (short)this.getInt(columnid);
    }

    public long getLong(int columnid) throws SQLException {
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int docID = scoreDoc.doc;
            if (this.isKeyID(columnid)) {
                Number number = this.getNumberValue(columnid);
                if (number == null) {
                    return 0L;
                }
                return number.longValue();
            }
            throw this.invalidColumnPosition(columnid);
        }
        catch (IOException e) {
            throw ToolUtilities.wrap(e);
        }
    }

    public Date getDate(int columnid) throws SQLException {
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int docID = scoreDoc.doc;
            if (this.isKeyID(columnid)) {
                Number number = this.getNumberValue(columnid);
                if (number == null) {
                    return null;
                }
                return new Date(number.longValue());
            }
            throw this.invalidColumnPosition(columnid);
        }
        catch (IOException e) {
            throw ToolUtilities.wrap(e);
        }
    }

    public Time getTime(int columnid) throws SQLException {
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int docID = scoreDoc.doc;
            if (this.isKeyID(columnid)) {
                Number number = this.getNumberValue(columnid);
                if (number == null) {
                    return null;
                }
                return new Time(number.longValue());
            }
            throw this.invalidColumnPosition(columnid);
        }
        catch (IOException e) {
            throw ToolUtilities.wrap(e);
        }
    }

    public Timestamp getTimestamp(int columnid) throws SQLException {
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int docID = scoreDoc.doc;
            if (this.isKeyID(columnid)) {
                Number number = this.getNumberValue(columnid);
                if (number == null) {
                    return null;
                }
                return new Timestamp(number.longValue());
            }
            throw this.invalidColumnPosition(columnid);
        }
        catch (IOException e) {
            throw ToolUtilities.wrap(e);
        }
    }

    public int getInt(int columnid) throws SQLException {
        this._wasNull = false;
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int docID = scoreDoc.doc;
            if (columnid == this._docIDColumnID) {
                return docID;
            }
            if (this.isKeyID(columnid)) {
                Number number = this.getNumberValue(columnid);
                if (number == null) {
                    return 0;
                }
                return number.intValue();
            }
            throw this.invalidColumnPosition(columnid);
        }
        catch (IOException e) {
            throw ToolUtilities.wrap(e);
        }
    }

    private Number getNumberValue(int columnid) throws IOException {
        IndexableField field = this._searcher.doc(this.getScoreDoc().doc).getField(this.getColumnName(columnid));
        if (field == null) {
            this._wasNull = true;
            return null;
        }
        this._wasNull = false;
        Number number = field.numericValue();
        return number;
    }

    public byte[] getBytes(int columnid) throws SQLException {
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int docID = scoreDoc.doc;
            if (this.isKeyID(columnid)) {
                BytesRef ref;
                Document doc = this._searcher.doc(docID);
                String columnName = this.getColumnName(columnid);
                if (columnName != null && (ref = doc.getBinaryValue(columnName)) != null) {
                    return ref.bytes;
                }
                this._wasNull = true;
                return null;
            }
            throw this.invalidColumnPosition(columnid);
        }
        catch (IOException e) {
            throw ToolUtilities.wrap(e);
        }
    }

    private SQLException invalidColumnPosition(int columnid) {
        return ToolUtilities.newSQLException("XCL14.S", columnid, this.getColumnCount());
    }

    private ScoreDoc getScoreDoc() throws IOException {
        return this._hits[this._hitIndex];
    }

    public boolean next() throws SQLException {
        this._wasNull = false;
        if (this._schema == null) {
            this.initScan();
        }
        ++this._hitIndex;
        if (this._hitIndex < this._hits.length) {
            return true;
        }
        this.closeReader();
        return false;
    }

    public void close() throws SQLException {
        this._hits = null;
        this._hitIndex = 0;
        this.closeReader();
    }

    public boolean wasNull() throws SQLException {
        return this._wasNull;
    }

    protected void finalize() {
        try {
            if (this._indexReader != null) {
                this._indexReader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void closeReader() throws SQLException {
        if (this._indexReader == null) {
            return;
        }
        try {
            this._indexReader.close();
        }
        catch (IOException e) {
            throw ToolUtilities.wrap(e);
        }
        finally {
            this._indexReader = null;
        }
    }

    private void initScan() throws SQLException {
        try {
            VTIContext context = this.getContext();
            this._schema = context.vtiSchema();
            String[] nameParts = LuceneSupport.decodeFunctionName(context.vtiTable());
            this._table = nameParts[0];
            this._column = nameParts[1];
            VTITemplate.ColumnDescriptor[] returnColumns = this.getReturnTableSignature(this._connection);
            String[] columnNames = new String[returnColumns.length];
            for (int i = 0; i < returnColumns.length; ++i) {
                columnNames[i] = returnColumns[i].columnName;
            }
            this.setColumnNames(columnNames);
            this._scoreColumnID = this.getColumnCount();
            this._docIDColumnID = this._scoreColumnID - 1;
            this._maxKeyID = this._docIDColumnID - 1;
            this._minKeyID = 1;
            this.vetPrivileges();
            String delimitedColumnName = LuceneSupport.delimitID(this._column);
            DerbyLuceneDir derbyLuceneDir = LuceneSupport.getDerbyLuceneDir(this._connection, this._schema, this._table, delimitedColumnName);
            StorageFile propertiesFile = LuceneSupport.getIndexPropertiesFile(derbyLuceneDir);
            Properties indexProperties = LuceneQueryVTI.readIndexProperties(propertiesFile);
            String indexDescriptorMaker = indexProperties.getProperty("derby.lucene.index.descriptor.maker");
            LuceneIndexDescriptor indexDescriptor = LuceneQueryVTI.getIndexDescriptor(indexDescriptorMaker);
            Analyzer analyzer = indexDescriptor.getAnalyzer();
            QueryParser qp = indexDescriptor.getQueryParser();
            this.vetLuceneVersion(indexProperties.getProperty("derby.lucene.version"));
            this._indexReader = LuceneQueryVTI.getIndexReader(derbyLuceneDir);
            this._searcher = new IndexSearcher(this._indexReader);
            Query luceneQuery = qp.parse(this._queryText);
            TopScoreDocCollector tsdc = TopScoreDocCollector.create((int)this._windowSize, (boolean)true);
            if (this._scoreCeiling != null) {
                tsdc = TopScoreDocCollector.create((int)this._windowSize, (ScoreDoc)new ScoreDoc(0, this._scoreCeiling.floatValue()), (boolean)true);
            }
            this.searchAndScore(luceneQuery, tsdc);
        }
        catch (IOException ioe) {
            throw ToolUtilities.wrap(ioe);
        }
        catch (ParseException pe) {
            throw ToolUtilities.wrap(pe);
        }
        catch (PrivilegedActionException pae) {
            throw ToolUtilities.wrap(pae);
        }
    }

    private void vetLuceneVersion(String indexVersionString) throws SQLException {
        Version currentVersion = LuceneUtils.currentVersion();
        Version indexVersion = null;
        try {
            indexVersion = Version.parseLeniently((String)indexVersionString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (indexVersion == null || !currentVersion.onOrAfter(indexVersion)) {
            throw ToolUtilities.newSQLException("42XBK", currentVersion.toString(), indexVersionString);
        }
    }

    private void vetPrivileges() throws SQLException {
        StringBuilder buffer = new StringBuilder();
        int _maxKeyID = this.getColumnCount() - 2;
        buffer.append("select ");
        for (int i = 0; i < _maxKeyID; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(LuceneSupport.delimitID(this.getColumnName(i + 1)));
        }
        buffer.append(", " + LuceneSupport.delimitID(this._column));
        buffer.append(" from " + LuceneSupport.makeTableName(this._schema, this._table));
        buffer.append(" where 1=2");
        this._connection.prepareStatement(buffer.toString()).executeQuery().close();
    }

    private boolean isKeyID(int columnid) {
        return columnid > 0 && columnid <= this._maxKeyID;
    }

    private static IndexReader getIndexReader(final DerbyLuceneDir dir) throws IOException, PrivilegedActionException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<IndexReader>(){

                @Override
                public IndexReader run() throws IOException {
                    return DirectoryReader.open((Directory)dir);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    private static Properties readIndexProperties(final StorageFile file) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return LuceneSupport.readIndexPropertiesNoPrivs(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    private static LuceneIndexDescriptor getIndexDescriptor(final String indexDescriptorMaker) throws PrivilegedActionException, SQLException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<LuceneIndexDescriptor>(){

            @Override
            public LuceneIndexDescriptor run() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException {
                return LuceneSupport.getIndexDescriptorNoPrivs(indexDescriptorMaker);
            }
        });
    }

    private void searchAndScore(final Query luceneQuery, final TopScoreDocCollector tsdc) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    LuceneQueryVTI.this._searcher.search(luceneQuery, (Collector)tsdc);
                    TopDocs topdocs = tsdc.topDocs();
                    LuceneQueryVTI.access$102(LuceneQueryVTI.this, topdocs.scoreDocs);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    static /* synthetic */ ScoreDoc[] access$102(LuceneQueryVTI x0, ScoreDoc[] x1) {
        x0._hits = x1;
        return x1;
    }
}

