/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.AsciiStream;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClobLocatorOutputStream;
import org.apache.derby.client.am.ClobLocatorWriter;
import org.apache.derby.client.am.ClobOutputStream;
import org.apache.derby.client.am.ClobWriter;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UpdateSensitiveClobLocatorInputStream;
import org.apache.derby.client.am.UpdateSensitiveClobLocatorReader;
import org.apache.derby.client.net.EncodedInputStream;

public class ClientClob
extends Lob
implements Clob {
    protected String string_ = null;
    private InputStream asciiStream_ = null;
    private InputStream unicodeStream_ = null;
    private Reader characterStream_ = null;
    private byte[] utf8String_;

    public ClientClob(Agent agent, String string) {
        this(agent, false);
        this.string_ = string;
        this.setSqlLength(this.string_.length());
        this.dataType_ |= 2;
    }

    public ClientClob(Agent agent, byte[] unconvertedBytes, Charset charset, int dataOffset) throws SqlException {
        this(agent, false);
        if (charset == null) {
            throw new SqlException(agent.logWriter_, new ClientMessageId("22005.S.2"), new Object[0]);
        }
        this.string_ = new String(unconvertedBytes, dataOffset, unconvertedBytes.length - dataOffset, charset);
        this.setSqlLength(this.string_.length());
        this.dataType_ |= 2;
    }

    public ClientClob(Agent agent, InputStream inputStream, Charset encoding, int length) {
        this(agent, false);
        this.setSqlLength(length);
        if (encoding.equals(Cursor.ISO_8859_1)) {
            this.asciiStream_ = inputStream;
            this.dataType_ |= 4;
        } else if (encoding.equals(Cursor.UTF_8)) {
            this.unicodeStream_ = inputStream;
            this.dataType_ |= 8;
        } else if (encoding.equals(Cursor.UTF_16BE)) {
            this.characterStream_ = new InputStreamReader(inputStream, Cursor.UTF_16BE);
            this.dataType_ |= 0x10;
            this.setSqlLength(length / 2);
        }
    }

    ClientClob(Agent agent, InputStream inputStream, Charset encoding) throws SqlException {
        this(agent, ClientClob.isLayerBStreamingPossible(agent));
        if (encoding.equals(Cursor.ISO_8859_1)) {
            this.asciiStream_ = inputStream;
            this.dataType_ |= 4;
        } else {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), encoding + " InputStream", "String/Clob");
        }
    }

    ClientClob(Agent agent, Reader reader, int length) {
        this(agent, false);
        this.setSqlLength(length);
        this.characterStream_ = reader;
        this.dataType_ |= 0x10;
    }

    public ClientClob(Agent agent, int locator) {
        super(agent, false);
        this.locator_ = locator;
        this.dataType_ |= 0x80;
    }

    ClientClob(Agent agent, Reader reader) {
        this(agent, ClientClob.isLayerBStreamingPossible(agent));
        this.unicodeStream_ = EncodedInputStream.createUTF8Stream(reader);
        this.dataType_ |= 8;
    }

    private ClientClob(Agent agent, boolean willBeLayerBStreamed) {
        super(agent, willBeLayerBStreamed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "length", new Object[0]);
                }
                long length = super.sqlLength();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "length", length);
                }
                return length;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                String retVal = null;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getSubString", (int)pos, length);
                }
                if (pos <= 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), pos);
                }
                if (length < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), length);
                }
                if (pos > this.sqlLength() + 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), pos);
                }
                retVal = this.getSubStringX(pos, length);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getSubString", retVal);
                }
                return retVal;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private String getSubStringX(long pos, int length) throws SqlException {
        this.checkForClosedConnection();
        long actualLength = Math.min(this.sqlLength() - pos + 1L, (long)length);
        if (this.isLocator()) {
            return this.agent_.connection_.locatorProcedureCall().clobGetSubString(this.locator_, pos, (int)actualLength);
        }
        return this.string_.substring((int)pos - 1, (int)(pos - 1L + actualLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCharacterStream", new Object[0]);
                }
                Reader retVal = this.getCharacterStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", retVal);
                }
                return retVal;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    Reader getCharacterStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isLocator()) {
            return new UpdateSensitiveClobLocatorReader(this.agent_.connection_, this);
        }
        if (this.isCharacterStream()) {
            return this.characterStream_;
        }
        return new StringReader(this.string_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getAsciiStream", new Object[0]);
                }
                InputStream retVal = this.getAsciiStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getAsciiStream", retVal);
                }
                return retVal;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    InputStream getAsciiStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isAsciiStream()) {
            return this.asciiStream_;
        }
        if (this.isLocator()) {
            return new UpdateSensitiveClobLocatorInputStream(this.agent_.connection_, this);
        }
        return new AsciiStream(this.string_, new StringReader(this.string_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(String searchstr, long start) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "position(String, long)", searchstr, start);
                }
                if (searchstr == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"), new Object[0]);
                }
                if (start < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), start);
                }
                long pos = this.positionX(searchstr, start);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(String, long)", pos);
                }
                return pos;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private long positionX(String searchstr, long start) throws SqlException {
        this.checkForClosedConnection();
        long index = -1L;
        if (start <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), start, "start", "Clob.position()");
        }
        if (this.isLocator()) {
            index = this.agent_.connection_.locatorProcedureCall().clobGetPositionFromString(this.locator_, searchstr, start);
        } else {
            index = this.string_.indexOf(searchstr, (int)start - 1);
            if (index != -1L) {
                ++index;
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "position(Clob, long)", searchstr, start);
                }
                if (start < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), start);
                }
                if (searchstr == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"), new Object[0]);
                }
                long pos = this.positionX(searchstr, start);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(Clob, long)", pos);
                }
                return pos;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private long positionX(Clob searchstr, long start) throws SqlException {
        long index;
        this.checkForClosedConnection();
        if (start <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), start, "start", "Clob.position()");
        }
        try {
            if (searchstr.length() > this.sqlLength()) {
                return -1L;
            }
            if (this.isLocator()) {
                index = this.agent_.connection_.locatorProcedureCall().clobGetPositionFromLocator(this.locator_, ((ClientClob)searchstr).getLocator(), start);
            } else {
                index = this.string_.indexOf(searchstr.getSubString(1L, (int)searchstr.length()), (int)start - 1);
                if (index != -1L) {
                    ++index;
                }
            }
        }
        catch (SQLException e) {
            throw new SqlException(e);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long pos, String str) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setString", (int)pos, str);
                }
                int length = this.setStringX(pos, str, 0, str.length());
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setString", length);
                }
                return length;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setString", (int)pos, str, offset, len);
                }
                int length = this.setStringX(pos, str, offset, len);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setString", length);
                }
                return length;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    int setStringX(long pos, String str, int offset, int len) throws SqlException {
        if ((int)pos <= 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), pos);
        }
        if (pos - 1L > this.sqlLength()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), pos);
        }
        if (str == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"), new Object[0]);
        }
        if (str.length() == 0) {
            return 0;
        }
        if (offset < 0 || offset >= str.length()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ078.S"), offset);
        }
        if (len < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), len);
        }
        if (offset + len > str.length()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22011.S.1"), offset, len, str);
        }
        if (len == 0) {
            return 0;
        }
        int length = 0;
        length = Math.min(str.length() - offset, len);
        if (this.isLocator()) {
            this.agent_.connection_.locatorProcedureCall().clobSetString(this.locator_, pos, length, str.substring(offset, offset + length));
            if (pos + (long)length - 1L > this.sqlLength()) {
                this.setSqlLength(pos + (long)length - 1L);
            }
            this.incrementUpdateCount();
        } else {
            this.reInitForNonLocator(this.string_.substring(0, (int)pos - 1).concat(str.substring(offset, offset + length)));
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setAsciiStream", (int)pos);
                }
                OutputStream outStream = null;
                outStream = this.isLocator() ? new ClobLocatorOutputStream(this, pos) : new ClobOutputStream(this, pos);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setAsciiStream", outStream);
                }
                return outStream;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setCharacterStream", (int)pos);
                }
                Writer writer = null;
                writer = this.isLocator() ? new ClobLocatorWriter(this.agent_.connection_, this, pos) : new ClobWriter(this, pos);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setCharacterStream", writer);
                }
                return writer;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long len) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, " truncate", (int)len);
                }
                if (len < 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), len);
                }
                if (len > this.sqlLength()) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ079.S"), len);
                }
                if (len == this.sqlLength()) {
                    return;
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().clobTruncate(this.locator_, len);
                    this.incrementUpdateCount();
                    this.setSqlLength(len);
                } else {
                    this.reInitForNonLocator(this.string_.substring(0, (int)len));
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        if (!this.isValid_) {
            return;
        }
        this.isValid_ = false;
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "free", new Object[0]);
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().clobReleaseLocator(this.locator_);
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (this.isString()) {
            this.string_ = null;
            this.utf8String_ = null;
        }
        if (this.isAsciiStream()) {
            try {
                this.asciiStream_.close();
            }
            catch (IOException ioe) {
                throw new SqlException(null, new ClientMessageId("XJ214.S"), new Object[0]).getSQLException();
            }
        }
        if (this.isUnicodeStream()) {
            try {
                this.unicodeStream_.close();
            }
            catch (IOException ioe) {
                throw new SqlException(null, new ClientMessageId("XJ214.S"), new Object[0]).getSQLException();
            }
        }
        if (this.isCharacterStream()) {
            try {
                this.characterStream_.close();
            }
            catch (IOException ioe) {
                throw new SqlException(null, new ClientMessageId("XJ214.S"), new Object[0]).getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkValidity();
        ClientConnection clientConnection = this.agent_.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCharacterStream", (int)pos, length);
            }
            this.checkPosAndLength(pos, length);
            Reader retVal = null;
            if (this.isLocator()) {
                try {
                    retVal = new UpdateSensitiveClobLocatorReader(this.agent_.connection_, this, pos, length);
                }
                catch (SqlException sqle) {
                    throw sqle.getSQLException();
                }
            }
            String retVal_str = null;
            try {
                retVal_str = this.getSubStringX(pos, (int)length);
            }
            catch (SqlException sqle) {
                throw sqle.getSQLException();
            }
            retVal = new StringReader(retVal_str);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", retVal);
            }
            return retVal;
        }
    }

    public boolean isString() {
        return (this.dataType_ & 2) == 2;
    }

    public boolean isAsciiStream() {
        return (this.dataType_ & 4) == 4;
    }

    public boolean isCharacterStream() {
        return (this.dataType_ & 0x10) == 16;
    }

    public boolean isUnicodeStream() {
        return (this.dataType_ & 8) == 8;
    }

    public InputStream getUnicodeStream() {
        return this.unicodeStream_;
    }

    public String getString() {
        return this.string_;
    }

    public byte[] getUtf8String() {
        return this.utf8String_;
    }

    public int getUTF8Length() {
        if (this.utf8String_ != null) {
            return this.utf8String_.length;
        }
        this.utf8String_ = this.string_.getBytes(Cursor.UTF_8);
        return this.utf8String_.length;
    }

    void reInitForNonLocator(String newString) {
        this.string_ = newString;
        this.asciiStream_ = new StringBufferInputStream(this.string_);
        this.unicodeStream_ = new StringBufferInputStream(this.string_);
        this.characterStream_ = new StringReader(this.string_);
        this.setSqlLength(this.string_.length());
    }

    @Override
    protected void materializeStream() throws SqlException {
        this.unicodeStream_ = super.materializeStream(this.isAsciiStream() ? this.asciiStream_ : this.unicodeStream_, "java.sql.Clob");
        this.dataType_ = 8;
    }

    @Override
    long getLocatorLength() throws SqlException {
        return this.agent_.connection_.locatorProcedureCall().clobGetLength(this.locator_);
    }
}

