/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.DummyAwareVTI;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AwareVTITest
extends GeneratedColumnsHelper {
    private static final String CANNOT_CHANGE_COLUMNS = "X0Y92";

    public AwareVTITest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(AwareVTITest.class);
        CleanDatabaseTestSetup result = new CleanDatabaseTestSetup((Test)suite);
        return result;
    }

    public void test_01_basic() throws Exception {
        Connection conn = this.getConnection();
        this.vetBasic(conn, "s1", "f1");
        this.vetBasic(conn, "s2", "f2");
    }

    private void vetBasic(Connection conn, String schema, String function) throws Exception {
        this.goodStatement(conn, "create schema " + schema);
        this.goodStatement(conn, "create function " + schema + "." + function + "() returns table\n(\n    schema_name varchar( 20 ),\n    vti_name varchar( 20 ),\n    statement_text varchar( 100 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.AwareVTITest.dummyAwareVTI'\n");
        String query = "select * from table( " + schema + "." + function + "() ) s";
        this.assertResults(conn, query, new String[][]{{schema.toUpperCase(), function.toUpperCase(), query}}, false);
    }

    public void test_02_StringColumnVTI() throws Exception {
        Connection conn = this.getConnection();
        String[][] rows = new String[][]{{"foo", "bar"}, {"wibble", "baz"}};
        UnnamedColumnsVTI ucv = new UnnamedColumnsVTI(rows);
        ucv.setColumnNames(new String[]{"A", "B"});
        try {
            ucv.setColumnNames(new String[]{"C", "D"});
            AwareVTITest.fail((String)"Attempt to reset column names should have failed.");
        }
        catch (SQLException se) {
            AwareVTITest.assertEquals((String)CANNOT_CHANGE_COLUMNS, (String)se.getSQLState());
        }
        this.assertResults((ResultSet)((Object)ucv), rows, false);
    }

    public void test_03_ArchiveVTI() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t1\n(\n    keyCol int,\n    aCol int,\n    bCol int\n)\n");
        this.goodStatement(conn, "create table t1_archive_001 as select * from t1 with no data");
        this.goodStatement(conn, "create table t1_archive_002 as select * from t1 with no data");
        this.goodStatement(conn, "insert into t1_archive_002 values ( 1, 100, 1000 ), ( 2, 200, 2000 ), ( 3, 300, 3000 )");
        this.goodStatement(conn, "insert into t1_archive_001 values ( 4, 400, 4000 ), ( 5, 500, 5000 ), ( 6, 600, 6000 )");
        this.goodStatement(conn, "insert into t1 values ( 7, 700, 7000 ), ( 8, 800, 8000 ), ( 9, 900, 9000 )");
        this.goodStatement(conn, "create function t1( archiveSuffix varchar( 32672 ) ) returns table\n(\n    keyCol int,\n    aCol int,\n    bCol int\n)\nlanguage java parameter style derby_jdbc_result_set reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ArchiveVTI.archiveVTI'\n");
        this.assertResults(conn, "select keyCol, bCol from table( t1( '_ARCHIVE_' ) ) s\nwhere keyCol between 3 and 7\norder by keyCol\n", new String[][]{{"3", "3000"}, {"4", "4000"}, {"5", "5000"}, {"6", "6000"}, {"7", "7000"}}, false);
    }

    public static DummyAwareVTI dummyAwareVTI() {
        return new DummyAwareVTI();
    }

    public static class UnnamedColumnsVTI
    extends StringArrayVTI {
        public UnnamedColumnsVTI(String[][] rows) {
            super(null, rows);
        }
    }
}

