/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

class SpecialFunctionNode
extends ValueNode {
    String sqlName;
    static final int K_IDENTITY_VAL = 0;
    static final int K_CURRENT_ISOLATION = 1;
    static final int K_CURRENT_SCHEMA = 2;
    static final int K_USER = 3;
    static final int K_CURRENT_USER = 4;
    static final int K_SESSION_USER = 5;
    static final int K_SYSTEM_USER = 6;
    static final int K_CURRENT_ROLE = 7;
    final int kind;
    private String methodName;
    private String methodType;

    SpecialFunctionNode(int kind, ContextManager cm) {
        super(cm);
        this.kind = kind;
        if (kind == 6) {
            SanityManager.THROWASSERT("SYSTEM_USER not expected");
        }
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        DataTypeDescriptor dtd;
        switch (this.kind) {
            case 3: 
            case 4: 
            case 6: {
                switch (this.kind) {
                    case 3: {
                        this.sqlName = "USER";
                        break;
                    }
                    case 4: {
                        this.sqlName = "CURRENT_USER";
                        break;
                    }
                    case 6: {
                        this.sqlName = "SYSTEM_USER";
                    }
                }
                this.methodName = "getCurrentUserId";
                this.methodType = "java.lang.String";
                dtd = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 5: {
                this.methodName = "getSessionUserId";
                this.methodType = "java.lang.String";
                this.sqlName = "SESSION_USER";
                dtd = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 2: {
                this.sqlName = "CURRENT SCHEMA";
                this.methodName = "getCurrentSchemaName";
                this.methodType = "java.lang.String";
                dtd = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 7: {
                this.sqlName = "CURRENT_ROLE";
                this.methodName = "getCurrentRoleIdDelimited";
                this.methodType = "java.lang.String";
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, 258);
                break;
            }
            case 0: {
                this.sqlName = "IDENTITY_VAL_LOCAL";
                this.methodName = "getIdentityValue";
                this.methodType = "java.lang.Long";
                dtd = DataTypeDescriptor.getSQLDataTypeDescriptor("java.math.BigDecimal", 31, 0, true, 31);
                break;
            }
            case 1: {
                this.sqlName = "CURRENT ISOLATION";
                this.methodName = "getCurrentIsolationLevelStr";
                this.methodType = "java.lang.String";
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 2);
                break;
            }
            default: {
                SanityManager.THROWASSERT("Invalid type for SpecialFunctionNode " + this.kind);
                dtd = null;
            }
        }
        this.checkReliability(this.sqlName, 64);
        this.setType(dtd);
        return this;
    }

    @Override
    protected int getOrderableVariantType() {
        return 2;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.pushThis();
        mb.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        int argCount = 0;
        if (this.methodName.equals("getCurrentRoleIdDelimited") || this.methodName.equals("getCurrentSchemaName") || this.methodName.equals("getCurrentUserId")) {
            acb.pushThisAsActivation(mb);
            ++argCount;
        }
        mb.callMethod((short)185, null, this.methodName, this.methodType, argCount);
        String fieldType = this.getTypeCompiler().interfaceName();
        LocalField field = acb.newFieldDeclaration(2, fieldType);
        acb.generateDataValue(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType(), field);
    }

    @Override
    public String toString() {
        return "sqlName: " + this.sqlName + "\n" + super.toString();
    }

    @Override
    boolean isSameNodeKind(ValueNode o) {
        return super.isSameNodeKind(o) && ((SpecialFunctionNode)o).kind == this.kind;
    }

    @Override
    boolean isEquivalent(ValueNode o) {
        if (this.isSameNodeKind(o)) {
            SpecialFunctionNode other = (SpecialFunctionNode)o;
            return this.methodName.equals(other.methodName);
        }
        return false;
    }
}

