/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BaseTestSuite
extends TestSuite {
    private static final Comparator<TestCase> TEST_ORDERER = new Comparator<TestCase>(){

        @Override
        public int compare(TestCase t1, TestCase t2) {
            return t1.getName().compareTo(t2.getName());
        }
    };

    public BaseTestSuite() {
    }

    public BaseTestSuite(String name) {
        super(name);
    }

    public BaseTestSuite(Class cls, String name) {
        super(name);
        this.orderedSuite(cls);
    }

    public BaseTestSuite(Class cls) {
        super(TestConfiguration.suiteName(cls));
        this.orderedSuite(cls);
    }

    public void addTestSuite(Class cls) {
        this.orderedSuite(cls);
    }

    private void orderedSuite(Class<?> cls) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        Enumeration e = new TestSuite(cls).tests();
        while (e.hasMoreElements()) {
            tests.add((TestCase)e.nextElement());
        }
        Collections.sort(tests, TEST_ORDERER);
        for (TestCase t : tests) {
            this.addTest((Test)t);
        }
    }
}

