/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesQuickSelectSketchTest {
    @Test(expectedExceptions={SketchesArgumentException.class})
    public void invalidSamplingProbability() {
        new ArrayOfDoublesUpdatableSketchBuilder().setSamplingProbability(2.0f);
    }

    @Test
    public void heapToDirectExactTwoDoubles() {
        double[] valuesArr = new double[]{1.0, 2.0};
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        sketch1.update("a", valuesArr);
        sketch1.update("b", valuesArr);
        sketch1.update("c", valuesArr);
        sketch1.update("d", valuesArr);
        sketch1.update("a", valuesArr);
        ArrayOfDoublesQuickSelectSketchTest.noopUpdates(sketch1, valuesArr);
        ArrayOfDoublesUpdatableSketch sketch2 = ArrayOfDoublesUpdatableSketch.wrap((WritableMemory)WritableMemory.writableWrap((byte[])sketch1.toByteArray()));
        sketch2.update("b", valuesArr);
        sketch2.update("c", valuesArr);
        sketch2.update("d", valuesArr);
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertFalse((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)4.0);
        Assert.assertEquals((double)sketch2.getUpperBound(1), (double)4.0);
        Assert.assertEquals((double)sketch2.getLowerBound(1), (double)4.0);
        Assert.assertEquals((long)sketch2.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch2.getTheta(), (double)1.0);
        double[][] values = sketch2.getValues();
        Assert.assertEquals((int)values.length, (int)4);
        for (double[] array : values) {
            Assert.assertEquals((int)array.length, (int)2);
            Assert.assertEquals((double)array[0], (double)2.0);
            Assert.assertEquals((double)array[1], (double)4.0);
        }
    }

    @Test
    public void heapToDirectWithSeed() {
        long seed = 1L;
        double[] values = new double[]{1.0};
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(seed).build();
        sketch1.update("a", values);
        sketch1.update("b", values);
        sketch1.update("c", values);
        ArrayOfDoublesUpdatableSketch sketch2 = ArrayOfDoublesUpdatableSketch.wrap((WritableMemory)WritableMemory.writableWrap((byte[])sketch1.toByteArray()), (long)seed);
        sketch2.update("b", values);
        sketch2.update("c", values);
        sketch2.update("d", values);
        Assert.assertEquals((double)sketch2.getEstimate(), (double)4.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInsertExceptions() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        sketch1.update("a", new double[]{1.0});
    }

    @Test
    public void directToHeapExactTwoDoubles() {
        double[] valuesArr = new double[]{1.0, 2.0};
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build(WritableMemory.writableWrap((byte[])new byte[1000000]));
        sketch1.update("a", valuesArr);
        sketch1.update("b", valuesArr);
        sketch1.update("c", valuesArr);
        sketch1.update("d", valuesArr);
        sketch1.update("a", valuesArr);
        ArrayOfDoublesQuickSelectSketchTest.noopUpdates(sketch1, valuesArr);
        ArrayOfDoublesUpdatableSketch sketch2 = ArrayOfDoublesUpdatableSketch.heapify((Memory)Memory.wrap((byte[])sketch1.toByteArray()));
        sketch2.update("b", valuesArr);
        sketch2.update("c", valuesArr);
        sketch2.update("d", valuesArr);
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertFalse((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)4.0);
        Assert.assertEquals((double)sketch2.getUpperBound(1), (double)4.0);
        Assert.assertEquals((double)sketch2.getLowerBound(1), (double)4.0);
        Assert.assertEquals((long)sketch2.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch2.getTheta(), (double)1.0);
        double[][] values = sketch2.getValues();
        Assert.assertEquals((int)values.length, (int)4);
        for (double[] array : values) {
            Assert.assertEquals((int)array.length, (int)2);
            Assert.assertEquals((double)array[0], (double)2.0);
            Assert.assertEquals((double)array[1], (double)4.0);
        }
    }

    @Test
    public void directToHeapWithSeed() {
        long seed = 1L;
        double[] values = new double[]{1.0};
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(seed).build(WritableMemory.writableWrap((byte[])new byte[1000000]));
        sketch1.update("a", values);
        sketch1.update("b", values);
        sketch1.update("c", values);
        ArrayOfDoublesUpdatableSketch sketch2 = ArrayOfDoublesUpdatableSketch.heapify((Memory)Memory.wrap((byte[])sketch1.toByteArray()), (long)seed);
        sketch2.update("b", values);
        sketch2.update("c", values);
        sketch2.update("d", values);
        Assert.assertEquals((double)sketch2.getEstimate(), (double)4.0);
    }

    @Test
    public void maxBytes() {
        Assert.assertEquals((int)ArrayOfDoublesQuickSelectSketch.getMaxBytes((int)1024, (int)2), (int)49184);
    }

    private static void noopUpdates(ArrayOfDoublesUpdatableSketch sketch, double[] valuesArr) {
        byte[] byteArr = null;
        sketch.update(byteArr, valuesArr);
        byteArr = new byte[]{};
        sketch.update(byteArr, valuesArr);
        int[] intArr = null;
        sketch.update(intArr, valuesArr);
        intArr = new int[]{};
        sketch.update(intArr, valuesArr);
        long[] longArr = null;
        sketch.update(longArr, valuesArr);
        longArr = new long[]{};
        sketch.update(longArr, valuesArr);
    }
}

