/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import org.apache.datasketches.cpc.RuntimeAsserts;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RuntimeAssertsTest {
    @Test
    public void checkPositives() {
        RuntimeAsserts.rtAssertFalse((boolean)false);
        short[] shortArr1 = new short[]{1, 2, 3};
        short[] shortArr2 = (short[])shortArr1.clone();
        RuntimeAsserts.rtAssertEquals((short[])shortArr1, (short[])shortArr2);
        shortArr1 = null;
        shortArr2 = null;
        RuntimeAsserts.rtAssertEquals((short[])shortArr1, (short[])shortArr2);
        float[] floatArr1 = new float[]{1.0f, 2.0f, 3.0f};
        float[] floatArr2 = (float[])floatArr1.clone();
        RuntimeAsserts.rtAssertEquals((float[])floatArr1, (float[])floatArr2, (float)0.0f);
        floatArr1 = null;
        floatArr2 = null;
        RuntimeAsserts.rtAssertEquals((float[])floatArr1, (float[])floatArr2, (float)0.0f);
        double[] doubleArr1 = new double[]{1.0, 2.0, 3.0};
        double[] doubleArr2 = (double[])doubleArr1.clone();
        RuntimeAsserts.rtAssertEquals((double[])doubleArr1, (double[])doubleArr2, (double)0.0);
        doubleArr1 = null;
        doubleArr2 = null;
        RuntimeAsserts.rtAssertEquals((double[])doubleArr1, (double[])doubleArr2, (double)0.0);
    }

    @Test
    public void checkSimpleExceptions() {
        try {
            RuntimeAsserts.rtAssert((boolean)false);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            RuntimeAsserts.rtAssertFalse((boolean)true);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            RuntimeAsserts.rtAssertEquals((long)1L, (long)2L);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            RuntimeAsserts.rtAssertEquals((double)1.0, (double)2.0, (double)0.0);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        try {
            RuntimeAsserts.rtAssertEquals((boolean)true, (boolean)false);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void checkByteArr() {
        byte[] arr1 = new byte[]{1, 2};
        byte[] arr2 = new byte[]{1};
        try {
            RuntimeAsserts.rtAssertEquals((byte[])arr1, (byte[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = new byte[]{1, 3};
        try {
            RuntimeAsserts.rtAssertEquals((byte[])arr1, (byte[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        try {
            RuntimeAsserts.rtAssertEquals((byte[])arr1, (byte[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = arr1;
        arr1 = null;
        try {
            RuntimeAsserts.rtAssertEquals((byte[])arr1, (byte[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        RuntimeAsserts.rtAssertEquals((byte[])arr1, (byte[])arr2);
    }

    @Test
    public void checkShortArr() {
        short[] arr1 = new short[]{1, 2};
        short[] arr2 = new short[]{1};
        try {
            RuntimeAsserts.rtAssertEquals((short[])arr1, (short[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = new short[]{1, 3};
        try {
            RuntimeAsserts.rtAssertEquals((short[])arr1, (short[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        try {
            RuntimeAsserts.rtAssertEquals((short[])arr1, (short[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = arr1;
        arr1 = null;
        try {
            RuntimeAsserts.rtAssertEquals((short[])arr1, (short[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        RuntimeAsserts.rtAssertEquals((short[])arr1, (short[])arr2);
    }

    @Test
    public void checkIntArr() {
        int[] arr1 = new int[]{1, 2};
        int[] arr2 = new int[]{1};
        try {
            RuntimeAsserts.rtAssertEquals((int[])arr1, (int[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = new int[]{1, 3};
        try {
            RuntimeAsserts.rtAssertEquals((int[])arr1, (int[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        try {
            RuntimeAsserts.rtAssertEquals((int[])arr1, (int[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = arr1;
        arr1 = null;
        try {
            RuntimeAsserts.rtAssertEquals((int[])arr1, (int[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        RuntimeAsserts.rtAssertEquals((int[])arr1, (int[])arr2);
    }

    @Test
    public void checkLongArr() {
        long[] arr1 = new long[]{1L, 2L};
        long[] arr2 = new long[]{1L};
        try {
            RuntimeAsserts.rtAssertEquals((long[])arr1, (long[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = new long[]{1L, 3L};
        try {
            RuntimeAsserts.rtAssertEquals((long[])arr1, (long[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        try {
            RuntimeAsserts.rtAssertEquals((long[])arr1, (long[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = arr1;
        arr1 = null;
        try {
            RuntimeAsserts.rtAssertEquals((long[])arr1, (long[])arr2);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        RuntimeAsserts.rtAssertEquals((long[])arr1, (long[])arr2);
    }

    @Test
    public void checkFloatArr() {
        float[] arr1 = new float[]{1.0f, 2.0f};
        float[] arr2 = new float[]{1.0f};
        try {
            RuntimeAsserts.rtAssertEquals((float[])arr1, (float[])arr2, (float)0.0f);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = new float[]{1.0f, 3.0f};
        try {
            RuntimeAsserts.rtAssertEquals((float[])arr1, (float[])arr2, (float)0.0f);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        try {
            RuntimeAsserts.rtAssertEquals((float[])arr1, (float[])arr2, (float)0.0f);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = arr1;
        arr1 = null;
        try {
            RuntimeAsserts.rtAssertEquals((float[])arr1, (float[])arr2, (float)0.0f);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        RuntimeAsserts.rtAssertEquals((float[])arr1, (float[])arr2, (float)0.0f);
    }

    @Test
    public void checkDoubleArr() {
        double[] arr1 = new double[]{1.0, 2.0};
        double[] arr2 = new double[]{1.0};
        try {
            RuntimeAsserts.rtAssertEquals((double[])arr1, (double[])arr2, (double)0.0);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = new double[]{1.0, 3.0};
        try {
            RuntimeAsserts.rtAssertEquals((double[])arr1, (double[])arr2, (double)0.0);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        try {
            RuntimeAsserts.rtAssertEquals((double[])arr1, (double[])arr2, (double)0.0);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = arr1;
        arr1 = null;
        try {
            RuntimeAsserts.rtAssertEquals((double[])arr1, (double[])arr2, (double)0.0);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        arr2 = null;
        RuntimeAsserts.rtAssertEquals((double[])arr1, (double[])arr2, (double)0.0);
    }
}

