/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="unionSketch", value="_FUNC_(firstSketch, secondSketch[, lgK[, seed]]) - Compute the union of the given sketches with the given size and seed", extended="The return value is a binary blob that can be operated on by other sketch related functions. The lgK parameter controls the sketch size and relative error expected from the sketch. It is optional an must be from 4 to 26. The default is 11, which is expected to yield errors of roughly +-1.5% in the estimation of uniques with 95% confidence. The seed parameter is optional")
public class UnionSketchUDF
extends UDF {
    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch, int lgK, long seed) {
        CpcUnion union = new CpcUnion(lgK, seed);
        if (firstSketch != null) {
            union.update(CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(firstSketch), (long)seed));
        }
        if (secondSketch != null) {
            union.update(CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(secondSketch), (long)seed));
        }
        return new BytesWritable(union.getResult().toByteArray());
    }

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch, int lgK) {
        return this.evaluate(firstSketch, secondSketch, lgK, 9001L);
    }

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch) {
        return this.evaluate(firstSketch, secondSketch, 11, 9001L);
    }
}

