/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import java.util.List;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.quantiles.GetPmfFromStringsSketchUDF;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetPmfFromStringsSketchUDFTest {
    static final Comparator<String> comparator = Comparator.naturalOrder();
    static final ArrayOfItemsSerDe<String> serDe = new ArrayOfStringsSerDe();

    @Test
    public void nullSketch() {
        List result = new GetPmfFromStringsSketchUDF().evaluate(null, new String[]{""});
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyListOfSplitPoints() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, comparator);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        sketch.update((Object)"c");
        List result = new GetPmfFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), new String[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertEquals((double)((Double)result.get(0)), (double)1.0);
    }

    @Test
    public void emptySketch() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, comparator);
        List result = new GetPmfFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), new String[]{"a"});
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, comparator);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        sketch.update((Object)"c");
        sketch.update((Object)"d");
        List result = new GetPmfFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), new String[]{"a", "c", "e"});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)4);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.25);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.5);
        Assert.assertEquals((double)((Double)result.get(2)), (double)0.25);
        Assert.assertEquals((double)((Double)result.get(3)), (double)0.0);
        result = new GetPmfFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), Boolean.valueOf(false), new String[]{"a", "c", "e"});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)4);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.5);
        Assert.assertEquals((double)((Double)result.get(2)), (double)0.5);
        Assert.assertEquals((double)((Double)result.get(3)), (double)0.0);
    }
}

