/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.List;
import org.apache.datasketches.hive.quantiles.GetCdfFromDoublesSketchUDF;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetCdfFromDoublesSketchUDFTest {
    @Test
    public void nullSketch() {
        List result = new GetCdfFromDoublesSketchUDF().evaluate(null, new Double[]{0.0});
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyListOfSplitPoints() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        sketch.update(1.0);
        sketch.update(2.0);
        sketch.update(3.0);
        List result = new GetCdfFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), new Double[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertEquals((double)((Double)result.get(0)), (double)1.0);
    }

    @Test
    public void emptySketch() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        List result = new GetCdfFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), new Double[]{0.0});
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        sketch.update(1.0);
        sketch.update(2.0);
        sketch.update(3.0);
        sketch.update(4.0);
        List result = new GetCdfFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), new Double[]{1.0, 3.0, 4.0});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)4);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.25);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.75);
        Assert.assertEquals((double)((Double)result.get(2)), (double)1.0);
        Assert.assertEquals((double)((Double)result.get(3)), (double)1.0);
        result = new GetCdfFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), Boolean.valueOf(false), new Double[]{1.0, 3.0, 4.0});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)4);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.5);
        Assert.assertEquals((double)((Double)result.get(2)), (double)0.75);
        Assert.assertEquals((double)((Double)result.get(3)), (double)1.0);
    }
}

