/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.frequencies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.hive.frequencies.GetFrequentItemsFromStringsSketchUDTF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.Collector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetFrequentItemsFromStringsSketchUDTFTest {
    static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    static final ObjectInspector stringInspector = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    static final ArrayOfItemsSerDe<String> serDe = new ArrayOfStringsSerDe();
    static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("a"), Arrays.asList(stringInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initializeTooFewInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        GetFrequentItemsFromStringsSketchUDTF func = new GetFrequentItemsFromStringsSketchUDTF();
        func.initialize(inspectors);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initializeTooManyInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, stringInspector, stringInspector};
        GetFrequentItemsFromStringsSketchUDTF func = new GetFrequentItemsFromStringsSketchUDTF();
        func.initialize(inspectors);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initializeWrongCategoryArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        GetFrequentItemsFromStringsSketchUDTF func = new GetFrequentItemsFromStringsSketchUDTF();
        func.initialize(inspectors);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initializeWrongCategoryArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, structInspector};
        GetFrequentItemsFromStringsSketchUDTF func = new GetFrequentItemsFromStringsSketchUDTF();
        func.initialize(inspectors);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initializeWrongTypeArg1() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{stringInspector, stringInspector};
        GetFrequentItemsFromStringsSketchUDTF func = new GetFrequentItemsFromStringsSketchUDTF();
        func.initialize(inspectors);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initializeWrongTypeArg2() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, binaryInspector};
        GetFrequentItemsFromStringsSketchUDTF func = new GetFrequentItemsFromStringsSketchUDTF();
        func.initialize(inspectors);
    }

    @Test
    public void normalCase() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, stringInspector};
        GetFrequentItemsFromStringsSketchUDTF func = new GetFrequentItemsFromStringsSketchUDTF();
        StructObjectInspector resultInspector = func.initialize(inspectors);
        GetFrequentItemsFromStringsSketchUDTFTest.checkResultInspector((ObjectInspector)resultInspector);
        ItemsSketch sketch = new ItemsSketch(8);
        sketch.update((Object)"1", 10L);
        sketch.update((Object)"2");
        sketch.update((Object)"3");
        sketch.update((Object)"4");
        sketch.update((Object)"5");
        sketch.update((Object)"6");
        sketch.update((Object)"7", 15L);
        sketch.update((Object)"8");
        sketch.update((Object)"9");
        sketch.update((Object)"10");
        sketch.update((Object)"11");
        sketch.update((Object)"12");
        MockCollector collector = new MockCollector();
        func.setCollector((Collector)collector);
        func.process(new Object[]{new BytesWritable(sketch.toByteArray(serDe))});
        Assert.assertEquals((int)collector.list.size(), (int)2);
        collector = new MockCollector();
        func.setCollector((Collector)collector);
        func.process(new Object[]{new BytesWritable(sketch.toByteArray(serDe)), "NO_FALSE_NEGATIVES"});
        Assert.assertTrue((collector.list.size() >= 2 ? 1 : 0) != 0);
    }

    private static void checkResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.STRUCT);
        List fields = ((StructObjectInspector)resultInspector).getAllStructFieldRefs();
        Assert.assertEquals((int)fields.size(), (int)4);
        Assert.assertEquals((Object)((StructField)fields.get(0)).getFieldObjectInspector().getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector()).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.STRING);
        Assert.assertEquals((Object)((StructField)fields.get(1)).getFieldObjectInspector().getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)((StructField)fields.get(1)).getFieldObjectInspector()).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.LONG);
        Assert.assertEquals((Object)((StructField)fields.get(2)).getFieldObjectInspector().getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)((StructField)fields.get(2)).getFieldObjectInspector()).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.LONG);
        Assert.assertEquals((Object)((StructField)fields.get(3)).getFieldObjectInspector().getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)((StructField)fields.get(3)).getFieldObjectInspector()).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.LONG);
    }

    private static class MockCollector
    implements Collector {
        List<Object> list = new ArrayList<Object>();

        private MockCollector() {
        }

        public void collect(Object object) throws HiveException {
            this.list.add(object);
        }
    }
}

