/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import java.time.Duration;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SftpFileSystemConfigBuilderTest {
    private static final Duration ONE_MINUTE = Duration.ofMinutes(1L);

    @Test
    public void testConnectTimeout() {
        FileSystemOptions options = new FileSystemOptions();
        SftpFileSystemConfigBuilder builder = SftpFileSystemConfigBuilder.getInstance();
        builder.setConnectTimeout(options, ONE_MINUTE);
        Assertions.assertEquals((Object)ONE_MINUTE, (Object)builder.getConnectTimeout(options));
        Assertions.assertEquals((long)ONE_MINUTE.toMillis(), (long)builder.getConnectTimeoutMillis(options).intValue());
        builder.setConnectTimeoutMillis(options, Integer.valueOf((int)ONE_MINUTE.toMillis()));
        Assertions.assertEquals((Object)ONE_MINUTE, (Object)builder.getConnectTimeout(options));
        Assertions.assertEquals((long)ONE_MINUTE.toMillis(), (long)builder.getConnectTimeoutMillis(options).intValue());
    }

    @Test
    public void testSessionTimeout() {
        FileSystemOptions options = new FileSystemOptions();
        SftpFileSystemConfigBuilder builder = SftpFileSystemConfigBuilder.getInstance();
        builder.setSessionTimeout(options, ONE_MINUTE);
        Assertions.assertEquals((Object)ONE_MINUTE, (Object)builder.getSessionTimeout(options));
        Assertions.assertEquals((long)ONE_MINUTE.toMillis(), (long)builder.getSessionTimeoutMillis(options).intValue());
        builder.setSessionTimeoutMillis(options, Integer.valueOf((int)ONE_MINUTE.toMillis()));
        Assertions.assertEquals((Object)ONE_MINUTE, (Object)builder.getSessionTimeout(options));
        Assertions.assertEquals((long)ONE_MINUTE.toMillis(), (long)builder.getSessionTimeoutMillis(options).intValue());
    }
}

