/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Expm1;
import org.apache.commons.math3.analysis.function.Sin;
import org.apache.commons.math3.analysis.interpolation.NevilleInterpolator;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public final class NevilleInterpolatorTest {
    @Test
    public void testSinFunction() {
        Sin f = new Sin();
        NevilleInterpolator interpolator = new NevilleInterpolator();
        int n = 6;
        double min = 0.0;
        double max = Math.PI * 2;
        double[] x = new double[n];
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = min + (double)i * (max - min) / (double)n;
            y[i] = f.value(x[i]);
        }
        double derivativebound = 1.0;
        UnivariateFunction p = interpolator.interpolate(x, y);
        double z = 0.7853981633974483;
        double expected = f.value(z);
        double result = p.value(z);
        double tolerance = FastMath.abs((double)(derivativebound * this.partialerror(x, z)));
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = 4.71238898038469;
        expected = f.value(z);
        result = p.value(z);
        tolerance = FastMath.abs((double)(derivativebound * this.partialerror(x, z)));
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testExpm1Function() {
        Expm1 f = new Expm1();
        NevilleInterpolator interpolator = new NevilleInterpolator();
        int n = 5;
        double min = -1.0;
        double max = 1.0;
        double[] x = new double[n];
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = min + (double)i * (max - min) / (double)n;
            y[i] = f.value(x[i]);
        }
        double derivativebound = Math.E;
        UnivariateFunction p = interpolator.interpolate(x, y);
        double z = 0.0;
        double expected = f.value(z);
        double result = p.value(z);
        double tolerance = FastMath.abs((double)(derivativebound * this.partialerror(x, z)));
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = 0.5;
        expected = f.value(z);
        result = p.value(z);
        tolerance = FastMath.abs((double)(derivativebound * this.partialerror(x, z)));
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = -0.5;
        expected = f.value(z);
        result = p.value(z);
        tolerance = FastMath.abs((double)(derivativebound * this.partialerror(x, z)));
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testParameters() {
        NevilleInterpolator interpolator = new NevilleInterpolator();
        try {
            double[] x = new double[]{1.0, 2.0, 2.0, 4.0};
            double[] y = new double[]{0.0, 4.0, 4.0, 2.5};
            UnivariateFunction p = interpolator.interpolate(x, y);
            p.value(0.0);
            Assert.fail((String)"Expecting NonMonotonicSequenceException - bad abscissas array");
        }
        catch (NonMonotonicSequenceException nonMonotonicSequenceException) {
            // empty catch block
        }
    }

    protected double partialerror(double[] x, double z) throws IllegalArgumentException {
        if (x.length < 1) {
            throw new IllegalArgumentException("Interpolation array cannot be empty.");
        }
        double out = 1.0;
        for (int i = 0; i < x.length; ++i) {
            out *= (z - x[i]) / (double)(i + 1);
        }
        return out;
    }
}

