/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.junit.Asserter;
import org.apache.commons.lang3.SystemProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class ArithmeticTest
extends JexlTestCase {
    private static final double EPSILON = 1.0E-6;
    private final Asserter asserter;
    private final JexlArithmetic jexla;
    private final JexlArithmetic jexlb;
    private final Date date = new Date();

    private static void assertArithmeticException(Supplier<Object> fun) {
        Assertions.assertThrows(ArithmeticException.class, fun::get);
    }

    private static void assertNullOperand(Supplier<Object> fun) {
        try {
            Assertions.assertNull((Object)fun.get());
        }
        catch (JexlArithmetic.NullOperand xany) {
            Assertions.assertNotNull((Object)((Object)xany));
        }
    }

    private static Document getDocument(String xml) throws Exception {
        DocumentBuilder xmlBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream stringInputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        return xmlBuilder.parse(stringInputStream);
    }

    private static int getJavaVersion() {
        int sep;
        String version = SystemProperties.getJavaVersion();
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        if ((sep = version.indexOf(".")) < 0) {
            sep = version.indexOf("-");
        }
        if (sep > 0) {
            version = version.substring(0, sep);
        }
        return Integer.parseInt(version);
    }

    public ArithmeticTest() {
        super("ArithmeticTest");
        this.asserter = new Asserter(this.JEXL);
        this.jexla = this.JEXL.getArithmetic();
        JexlOptions options = new JexlOptions();
        options.setStrictArithmetic(false);
        this.jexlb = this.jexla.options(options);
    }

    void checkEmpty(Object x, boolean expect) {
        JexlScript s0 = this.JEXL.createScript("empty(x)", new String[]{"x"});
        boolean empty = (Boolean)s0.execute(null, new Object[]{x});
        Assertions.assertEquals((Object)expect, (Object)empty);
        JexlScript s1 = this.JEXL.createScript("empty x", new String[]{"x"});
        empty = (Boolean)s1.execute(null, new Object[]{x});
        Assertions.assertEquals((Object)expect, (Object)empty);
        JexlScript s2 = this.JEXL.createScript("x.empty()", new String[]{"x"});
        empty = (Boolean)s2.execute(null, new Object[]{x});
        Assertions.assertEquals((Object)expect, (Object)empty);
    }

    private void runInstanceof(JexlEngine jexl, JexlContext ctxt) {
        Object r = jexl.createExpression("3.0 instanceof 'Double'").evaluate(ctxt);
        Assertions.assertTrue((boolean)((Boolean)r));
        r = jexl.createExpression("'3.0' !instanceof 'Double'").evaluate(ctxt);
        Assertions.assertTrue((boolean)((Boolean)r));
        JexlScript script = jexl.createScript("x instanceof y", new String[]{"x", "y"});
        r = script.execute(ctxt, new Object[]{"foo", String.class});
        Assertions.assertTrue((boolean)((Boolean)r));
        r = script.execute(ctxt, new Object[]{42.0, Double.class});
        Assertions.assertTrue((boolean)((Boolean)r));
        script = jexl.createScript("x !instanceof y", new String[]{"x", "y"});
        r = script.execute(ctxt, new Object[]{"foo", Double.class});
        Assertions.assertTrue((boolean)((Boolean)r));
        r = script.execute(ctxt, new Object[]{42.0, String.class});
        Assertions.assertTrue((boolean)((Boolean)r));
    }

    protected void runOverload(JexlEngine jexl, JexlContext jc) {
        JexlScript script = jexl.createScript("(x, y)->{ x < y }");
        Object result = script.execute(jc, new Object[]{42, 43});
        Assertions.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assertions.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assertions.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{43, 42});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(43), new Var(42)});
        Assertions.assertEquals((Object)false, (Object)result);
        script = jexl.createScript("(x, y)->{ x <= y }");
        result = script.execute(jc, new Object[]{42, 43});
        Assertions.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assertions.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(41), new Var(44)});
        Assertions.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{43, 42});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(45), new Var(40)});
        Assertions.assertEquals((Object)false, (Object)result);
        script = jexl.createScript("(x, y)->{ x > y }");
        result = script.execute(jc, new Object[]{42, 43});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{43, 42});
        Assertions.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(43), new Var(42)});
        Assertions.assertEquals((Object)true, (Object)result);
        script = jexl.createScript("(x, y)->{ x >= y }");
        result = script.execute(jc, new Object[]{42, 43});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(41), new Var(44)});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{43, 42});
        Assertions.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(45), new Var(40)});
        Assertions.assertEquals((Object)true, (Object)result);
        script = jexl.createScript("(x, y)->{ x == y }");
        result = script.execute(jc, new Object[]{42, 43});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(41), new Var(44)});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{43, 42});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(45), new Var(40)});
        Assertions.assertEquals((Object)false, (Object)result);
        script = jexl.createScript("(x, y)->{ x != y }");
        result = script.execute(jc, new Object[]{42, 43});
        Assertions.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assertions.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(44), new Var(44)});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{44, 44});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(45), new Var(40)});
        Assertions.assertEquals((Object)true, (Object)result);
        script = jexl.createScript("(x, y)->{ x % y }");
        result = script.execute(jc, new Object[]{4242, 100});
        Assertions.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{new Var(4242), new Var(100)});
        Assertions.assertEquals((int)42, (int)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x * y }");
        result = script.execute(jc, new Object[]{6, 7});
        Assertions.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{new Var(6), new Var(7)});
        Assertions.assertEquals((int)42, (int)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x + y }");
        result = script.execute(jc, new Object[]{35, 7});
        Assertions.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{new Var(35), new Var(7)});
        Assertions.assertEquals((int)42, (int)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x - y }");
        result = script.execute(jc, new Object[]{49, 7});
        Assertions.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{"foobarquux", "bar"});
        Assertions.assertEquals((Object)"fooquux", (Object)result);
        result = script.execute(jc, new Object[]{50, 8});
        Assertions.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{new Var(50), new Var(8)});
        Assertions.assertEquals((int)42, (int)((Var)result).value);
        script = jexl.createScript("(x)->{ -x }");
        result = script.execute(jc, new Object[]{-42});
        Assertions.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{new Var(-42)});
        Assertions.assertEquals((int)42, (int)((Var)result).value);
        result = script.execute(jc, new Object[]{"pizza"});
        Assertions.assertEquals((Object)"azzip", (Object)result);
        result = script.execute(jc, new Object[]{-142});
        Assertions.assertEquals((Object)142, (Object)result);
        script = jexl.createScript("(x)->{ ~x }");
        result = script.execute(jc, new Object[]{-1});
        Assertions.assertEquals((Object)0L, (Object)result);
        result = script.execute(jc, new Object[]{new Var(-1)});
        Assertions.assertEquals((long)0L, (long)((Var)result).value);
        result = script.execute(jc, new Object[]{new Var(-42)});
        Assertions.assertEquals((int)41, (int)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x ^ y }");
        result = script.execute(jc, new Object[]{35, 7});
        Assertions.assertEquals((Object)36L, (Object)result);
        result = script.execute(jc, new Object[]{new Var(35), new Var(7)});
        Assertions.assertEquals((long)36L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->bitwiseXor(x,y)");
        result = script.execute(jc, new Object[]{35, 7});
        Assertions.assertEquals((Object)36L, (Object)result);
        script = jexl.createScript("(x, y)->{ x | y }");
        result = script.execute(jc, new Object[]{35, 7});
        Assertions.assertEquals((Object)39L, (Object)result);
        result = script.execute(jc, new Object[]{new Var(35), new Var(7)});
        Assertions.assertEquals((long)39L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->bitwiseOr(x,y)");
        result = script.execute(jc, new Object[]{35, 7});
        Assertions.assertEquals((Object)39L, (Object)result);
        script = jexl.createScript("(x, y)->{ x << y }");
        result = script.execute(jc, new Object[]{35, 1});
        Assertions.assertEquals((Object)70L, (Object)result);
        result = script.execute(jc, new Object[]{new Var(35), new Var(1)});
        Assertions.assertEquals((long)70L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x >> y }");
        result = script.execute(jc, new Object[]{42, 1});
        Assertions.assertEquals((Object)21L, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(1)});
        Assertions.assertEquals((int)21, (int)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x >>> y }");
        result = script.execute(jc, new Object[]{84, 2});
        Assertions.assertEquals((Object)21L, (Object)result);
        result = script.execute(jc, new Object[]{new Var(84), new Var(2)});
        Assertions.assertEquals((int)21, (int)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x & y }");
        result = script.execute(jc, new Object[]{35, 7});
        Assertions.assertEquals((Object)3L, (Object)result);
        result = script.execute(jc, new Object[]{new Var(35), new Var(7)});
        Assertions.assertEquals((long)3L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->bitwiseAnd(x,y)");
        result = script.execute(jc, new Object[]{35, 7});
        Assertions.assertEquals((Object)3L, (Object)result);
        script = jexl.createScript("(x, y)->{ x =^ y }");
        result = script.execute(jc, new Object[]{3115, 31});
        Assertions.assertFalse((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3115), new Var(31)});
        Assertions.assertTrue((boolean)((Boolean)result));
        script = jexl.createScript("(x, y)->{ x !^ y }");
        result = script.execute(jc, new Object[]{3115, 31});
        Assertions.assertTrue((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3115), new Var(31)});
        Assertions.assertFalse((boolean)((Boolean)result));
        script = jexl.createScript("(x, y)->{ x =$ y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assertions.assertFalse((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3115), new Var(15)});
        Assertions.assertTrue((boolean)((Boolean)result));
        script = jexl.createScript("(x, y)->{ x !$ y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assertions.assertTrue((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3115), new Var(15)});
        Assertions.assertFalse((boolean)((Boolean)result));
        script = jexl.createScript("(x, y)->{ x =~ y }");
        result = script.execute(jc, new Object[]{3155, 15});
        Assertions.assertFalse((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3155), new Var(15)});
        Assertions.assertFalse((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(15), new Var(3155)});
        Assertions.assertTrue((boolean)((Boolean)result));
        script = jexl.createScript("(x, y)->{ x !~ y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assertions.assertTrue((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3155), new Var(15)});
        Assertions.assertTrue((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(15), new Var(3155)});
        Assertions.assertFalse((boolean)((Boolean)result));
        JexlScript script1 = jexl.createScript("(x)->{ !x }");
        Assertions.assertThrows(JexlException.Operator.class, () -> script1.execute(jc, new Object[]{new Var(-42)}));
    }

    @Override
    @BeforeEach
    public void setUp() {
    }

    @Test
    void test2DoubleLiterals() {
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrictArithmetic(true);
        String stmt = "{a = 42.0e1D; b = 42.0E+2D; c = 42.0e-1d; d = 42.0E-2d; e=10e10; f= +1.e1; g=1e1; }";
        JexlScript expr = this.JEXL.createScript("{a = 42.0e1D; b = 42.0E+2D; c = 42.0e-1d; d = 42.0E-2d; e=10e10; f= +1.e1; g=1e1; }");
        expr.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)Double.valueOf("42.0e+1"), (Object)ctxt.get("a"));
        Assertions.assertEquals((Object)Double.valueOf("42.0e+2"), (Object)ctxt.get("b"));
        Assertions.assertEquals((Object)Double.valueOf("42.0e-1"), (Object)ctxt.get("c"));
        Assertions.assertEquals((Object)Double.valueOf("42.0e-2"), (Object)ctxt.get("d"));
        Assertions.assertEquals((Object)Double.valueOf("10e10"), (Object)ctxt.get("e"));
        Assertions.assertEquals((Object)Double.valueOf("10"), (Object)ctxt.get("f"));
        Assertions.assertEquals((Object)Double.valueOf("10"), (Object)ctxt.get("g"));
    }

    @Test
    void testAddWithStringsLenient() {
        JexlEngine jexl = new JexlBuilder().arithmetic(new JexlArithmetic(false)).create();
        JexlScript script = jexl.createScript("'a' + 0");
        Object result = script.execute(null);
        Assertions.assertEquals((Object)"a0", (Object)result);
        script = jexl.createScript("0 + 'a' ");
        result = script.execute(null);
        Assertions.assertEquals((Object)"0a", (Object)result);
        script = jexl.createScript("0 + '1.2' ");
        result = script.execute(null);
        Assertions.assertEquals((double)1.2, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("'1.2' + 1.2 ");
        result = script.execute(null);
        Assertions.assertEquals((double)2.4, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("1.2 + 1.2 ");
        result = script.execute(null);
        Assertions.assertEquals((double)2.4, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("1.2 + '1.2' ");
        result = script.execute(null);
        Assertions.assertEquals((double)2.4, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("'1.2' + 0 ");
        result = script.execute(null);
        Assertions.assertEquals((double)1.2, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("'1.2' + '1.2' ");
        result = script.execute(null);
        Assertions.assertEquals((Object)"1.21.2", (Object)result);
    }

    @Test
    void testAddWithStringsStrict() {
        JexlEngine jexl = new JexlBuilder().arithmetic(new JexlArithmetic(true)).create();
        JexlScript script = jexl.createScript("'a' + 0");
        Object result = script.execute(null);
        Assertions.assertEquals((Object)"a0", (Object)result);
        script = jexl.createScript("0 + 'a' ");
        result = script.execute(null);
        Assertions.assertEquals((Object)"0a", (Object)result);
        script = jexl.createScript("0 + '1.2' ");
        result = script.execute(null);
        Assertions.assertEquals((Object)"01.2", (Object)result);
        script = jexl.createScript("'1.2' + 1.2 ");
        result = script.execute(null);
        Assertions.assertEquals((Object)"1.21.2", (Object)result);
        script = jexl.createScript("1.2 + 1.2 ");
        result = script.execute(null);
        Assertions.assertEquals((double)2.4, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("1.2 + '1.2' ");
        result = script.execute(null);
        Assertions.assertEquals((Object)"1.21.2", (Object)result);
        script = jexl.createScript("'1.2' + 0 ");
        result = script.execute(null);
        Assertions.assertEquals((Object)"1.20", (Object)result);
        script = jexl.createScript("'1.2' + '1.2' ");
        result = script.execute(null);
        Assertions.assertEquals((Object)"1.21.2", (Object)result);
    }

    @Test
    void testArithmeticPlus() {
        JexlEngine jexl = new JexlBuilder().cache(64).arithmetic((JexlArithmetic)new ArithmeticPlus(false)).create();
        EmptyTestContext jc = new EmptyTestContext();
        this.runOverload(jexl, (JexlContext)jc);
        this.runOverload(jexl, (JexlContext)jc);
    }

    @Test
    void testArithmeticPlusNoCache() {
        JexlEngine jexl = new JexlBuilder().cache(0).arithmetic((JexlArithmetic)new ArithmeticPlus(false)).create();
        EmptyTestContext jc = new EmptyTestContext();
        this.runOverload(jexl, (JexlContext)jc);
    }

    @Test
    void testAtomicBoolean() {
        JexlScript e = this.JEXL.createScript("if (x) 1 else 2;", new String[]{"x"});
        JexlArithmetic jexla = this.JEXL.getArithmetic();
        MapContext jc = new MapContext();
        AtomicBoolean ab = new AtomicBoolean();
        Object o = e.execute((JexlContext)jc, new Object[]{ab});
        Assertions.assertEquals((Object)2, (Object)o);
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab});
        Assertions.assertEquals((Object)1, (Object)o);
        e = this.JEXL.createScript("x && y", new String[]{"x", "y"});
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab, Boolean.FALSE});
        Assertions.assertFalse((boolean)jexla.toBoolean(o));
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab, Boolean.TRUE});
        Assertions.assertTrue((boolean)jexla.toBoolean(o));
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab, Boolean.FALSE});
        Assertions.assertFalse((boolean)jexla.toBoolean(o));
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab, Boolean.FALSE});
        Assertions.assertFalse((boolean)jexla.toBoolean(o));
        e = this.JEXL.createScript("x + y", new String[]{"x", "y"});
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab, 10});
        Assertions.assertEquals((Object)11, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{10, ab});
        Assertions.assertEquals((Object)11, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{ab, 10.0});
        Assertions.assertEquals((double)11.0, (double)((Double)o), (double)1.0E-6);
        o = e.execute((JexlContext)jc, new Object[]{10.0, ab});
        Assertions.assertEquals((double)11.0, (double)((Double)o), (double)1.0E-6);
        BigInteger bi10 = BigInteger.TEN;
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab, bi10});
        Assertions.assertEquals((Object)bi10, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{bi10, ab});
        Assertions.assertEquals((Object)bi10, (Object)o);
        BigDecimal bd10 = BigDecimal.TEN;
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab, bd10});
        Assertions.assertEquals((Object)bd10, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{bd10, ab});
        Assertions.assertEquals((Object)bd10, (Object)o);
        e = this.JEXL.createScript("!x", new String[]{"x"});
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab});
        Assertions.assertFalse((boolean)((Boolean)o));
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab});
        Assertions.assertTrue((boolean)((Boolean)o));
        e = this.JEXL.createScript("-x", new String[]{"x"});
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab});
        Assertions.assertFalse((boolean)((Boolean)o));
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab});
        Assertions.assertTrue((boolean)((Boolean)o));
    }

    @Test
    void testBigDecimal() throws Exception {
        this.asserter.setVariable("left", new BigDecimal(2));
        this.asserter.setVariable("right", new BigDecimal(6));
        this.asserter.assertExpression("left + right", new BigDecimal(8), new Object[0]);
        this.asserter.assertExpression("right - left", new BigDecimal(4), new Object[0]);
        this.asserter.assertExpression("right * left", new BigDecimal(12), new Object[0]);
        this.asserter.assertExpression("right / left", new BigDecimal(3), new Object[0]);
        this.asserter.assertExpression("right % left", new BigDecimal(0), new Object[0]);
    }

    @Test
    void testBigdOp() {
        BigDecimal sevendot475 = new BigDecimal("7.475");
        BigDecimal SO = new BigDecimal("325");
        MapContext jc = new MapContext();
        jc.set("SO", (Object)SO);
        String expr = "2.3*SO/100";
        Object evaluate = this.JEXL.createExpression("2.3*SO/100").evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)sevendot475, (Object)evaluate);
    }

    @Test
    void testBigExponentLiterals() {
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrictArithmetic(true);
        String stmt = "{a = 42.0e1B; b = 42.0E+2B; c = 42.0e-1B; d = 42.0E-2b; e=4242.4242e1b}";
        JexlScript expr = this.JEXL.createScript("{a = 42.0e1B; b = 42.0E+2B; c = 42.0e-1B; d = 42.0E-2b; e=4242.4242e1b}");
        expr.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)new BigDecimal("42.0e+1"), (Object)ctxt.get("a"));
        Assertions.assertEquals((Object)new BigDecimal("42.0e+2"), (Object)ctxt.get("b"));
        Assertions.assertEquals((Object)new BigDecimal("42.0e-1"), (Object)ctxt.get("c"));
        Assertions.assertEquals((Object)new BigDecimal("42.0e-2"), (Object)ctxt.get("d"));
        Assertions.assertEquals((Object)new BigDecimal("4242.4242e1"), (Object)ctxt.get("e"));
    }

    @Test
    void testBigInteger() throws Exception {
        this.asserter.setVariable("left", new BigInteger("2"));
        this.asserter.setVariable("right", new BigInteger("6"));
        this.asserter.assertExpression("left + right", new BigInteger("8"), new Object[0]);
        this.asserter.assertExpression("right - left", new BigInteger("4"), new Object[0]);
        this.asserter.assertExpression("right * left", new BigInteger("12"), new Object[0]);
        this.asserter.assertExpression("right / left", new BigInteger("3"), new Object[0]);
        this.asserter.assertExpression("right % left", new BigInteger("0"), new Object[0]);
    }

    @Test
    void testBigLiterals() {
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrictArithmetic(true);
        String stmt = "{a = 10H; b = 10h; c = 42.0B; d = 42.0b;}";
        JexlScript expr = this.JEXL.createScript("{a = 10H; b = 10h; c = 42.0B; d = 42.0b;}");
        expr.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)new BigInteger("10"), (Object)ctxt.get("a"));
        Assertions.assertEquals((Object)new BigInteger("10"), (Object)ctxt.get("b"));
        Assertions.assertEquals((Object)new BigDecimal("42.0"), (Object)ctxt.get("c"));
        Assertions.assertEquals((Object)new BigDecimal("42.0"), (Object)ctxt.get("d"));
    }

    @Test
    void testBigLiteralValue() {
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrictArithmetic(true);
        JexlExpression e = this.JEXL.createExpression("9223372036854775806.5B");
        String res = String.valueOf(e.evaluate((JexlContext)ctxt));
        Assertions.assertEquals((Object)"9223372036854775806.5", (Object)res);
    }

    @Test
    void testCalculations() throws Exception {
        this.asserter.setStrict(true, false);
        this.asserter.setVariable("imanull", null);
        this.asserter.assertExpression("imanull + 2", 2, new Object[0]);
        this.asserter.assertExpression("imanull + imanull", 0, new Object[0]);
        this.asserter.setVariable("foo", 2);
        this.asserter.assertExpression("foo + 2", 4, new Object[0]);
        this.asserter.assertExpression("3 + 3", 6, new Object[0]);
        this.asserter.assertExpression("3 + 3 + foo", 8, new Object[0]);
        this.asserter.assertExpression("3 * 3", 9, new Object[0]);
        this.asserter.assertExpression("3 * 3 + foo", 11, new Object[0]);
        this.asserter.assertExpression("3 * 3 - foo", 7, new Object[0]);
        this.asserter.assertExpression("(4 + 3) * 6", 42, new Object[0]);
        this.asserter.assertExpression("(8 - 2) * 7", 42, new Object[0]);
        this.asserter.assertExpression("3 * \"3.0\"", 9.0, new Object[0]);
        this.asserter.assertExpression("3 * 3.0", 9.0, new Object[0]);
        this.asserter.setStrict(false, false);
        this.asserter.assertExpression("6 / 3", 2, new Object[0]);
        this.asserter.assertExpression("6.4 / 3", 2.1333333333333333, new Object[0]);
        this.asserter.assertExpression("0 / 3", 0, new Object[0]);
        this.asserter.assertExpression("3 / 0", 0.0, new Object[0]);
        this.asserter.assertExpression("4 % 3", 1, new Object[0]);
        this.asserter.assertExpression("4.8 % 3", 1.7999999999999998, new Object[0]);
    }

    @Test
    void testCoerceBigDecimal() {
        JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrictArithmetic(true);
        String stmt = "{a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H; }";
        JexlScript expr = this.JEXL.createScript("{a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H; }");
        expr.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)BigDecimal.valueOf(34L), (Object)ja.toBigDecimal(ctxt.get("a")));
        Assertions.assertEquals((Object)BigDecimal.valueOf(45.0), (Object)ja.toBigDecimal(ctxt.get("b")));
        Assertions.assertEquals((Object)BigDecimal.valueOf(56.0), (Object)ja.toBigDecimal(ctxt.get("c")));
        Assertions.assertEquals((Object)BigDecimal.valueOf(67L), (Object)ja.toBigDecimal(ctxt.get("d")));
        Assertions.assertEquals((Object)BigDecimal.valueOf(78L), (Object)ja.toBigDecimal(ctxt.get("e")));
        Assertions.assertEquals((Object)BigDecimal.valueOf(10L), (Object)ja.toBigDecimal((Object)"10"));
        Assertions.assertEquals((Object)BigDecimal.valueOf(1.0), (Object)ja.toBigDecimal((Object)true));
        Assertions.assertEquals((Object)BigDecimal.valueOf(0.0), (Object)ja.toBigDecimal((Object)false));
        BigDecimal a42 = BigDecimal.valueOf(42L);
        BigDecimal a49 = BigDecimal.valueOf(49L);
        JexlScript bde = this.JEXL.createScript("a * 6 / 7", new String[]{"a"});
        Assertions.assertEquals((Object)a42, (Object)bde.execute(null, new Object[]{a49}));
        bde = this.JEXL.createScript("(a - 12) / 12", new String[]{"a"});
        MathContext mc = ja.getMathContext();
        BigDecimal b56 = BigDecimal.valueOf(56L);
        BigDecimal b12 = BigDecimal.valueOf(12L);
        BigDecimal b3dot666 = b56.subtract(b12, mc).divide(b12, mc);
        Assertions.assertEquals((Object)b3dot666, (Object)bde.execute(null, new Object[]{b56}));
    }

    @Test
    void testCoerceBigInteger() {
        JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrictArithmetic(true);
        String stmt = "{a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H; }";
        JexlScript expr = this.JEXL.createScript("{a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H; }");
        expr.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)BigInteger.valueOf(34L), (Object)ja.toBigInteger(ctxt.get("a")));
        Assertions.assertEquals((Object)BigInteger.valueOf(45L), (Object)ja.toBigInteger(ctxt.get("b")));
        Assertions.assertEquals((Object)BigInteger.valueOf(56L), (Object)ja.toBigInteger(ctxt.get("c")));
        Assertions.assertEquals((Object)BigInteger.valueOf(67L), (Object)ja.toBigInteger(ctxt.get("d")));
        Assertions.assertEquals((Object)BigInteger.valueOf(78L), (Object)ja.toBigInteger(ctxt.get("e")));
        Assertions.assertEquals((Object)BigInteger.valueOf(10L), (Object)ja.toBigInteger((Object)"10"));
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)ja.toBigInteger((Object)true));
        Assertions.assertEquals((Object)BigInteger.valueOf(0L), (Object)ja.toBigInteger((Object)false));
    }

    @Test
    void testCoerceDouble() {
        JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrictArithmetic(true);
        String stmt = "{a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H; }";
        JexlScript expr = this.JEXL.createScript("{a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H; }");
        expr.execute((JexlContext)ctxt);
        Assertions.assertEquals((double)34.0, (double)ja.toDouble(ctxt.get("a")), (double)1.0E-6);
        Assertions.assertEquals((double)45.0, (double)ja.toDouble(ctxt.get("b")), (double)1.0E-6);
        Assertions.assertEquals((double)56.0, (double)ja.toDouble(ctxt.get("c")), (double)1.0E-6);
        Assertions.assertEquals((double)67.0, (double)ja.toDouble(ctxt.get("d")), (double)1.0E-6);
        Assertions.assertEquals((double)78.0, (double)ja.toDouble(ctxt.get("e")), (double)1.0E-6);
        Assertions.assertEquals((double)10.0, (double)ja.toDouble((Object)"10"), (double)1.0E-6);
        Assertions.assertEquals((double)1.0, (double)ja.toDouble((Object)true), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)ja.toDouble((Object)false), (double)1.0E-6);
    }

    @Test
    void testCoerceInteger() {
        JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrictArithmetic(true);
        String stmt = "a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H;";
        JexlScript expr = this.JEXL.createScript("a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H;");
        expr.execute((JexlContext)ctxt);
        Assertions.assertEquals((int)34, (int)ja.toInteger(ctxt.get("a")));
        Assertions.assertEquals((int)45, (int)ja.toInteger(ctxt.get("b")));
        Assertions.assertEquals((int)56, (int)ja.toInteger(ctxt.get("c")));
        Assertions.assertEquals((int)67, (int)ja.toInteger(ctxt.get("d")));
        Assertions.assertEquals((int)78, (int)ja.toInteger(ctxt.get("e")));
        Assertions.assertEquals((int)10, (int)ja.toInteger((Object)"10"));
        Assertions.assertEquals((int)1, (int)ja.toInteger((Object)true));
        Assertions.assertEquals((int)0, (int)ja.toInteger((Object)false));
    }

    @Test
    void testCoerceLong() {
        JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrictArithmetic(true);
        String stmt = "a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H;";
        JexlScript expr = this.JEXL.createScript("a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H;");
        expr.execute((JexlContext)ctxt);
        Assertions.assertEquals((long)34L, (long)ja.toLong(ctxt.get("a")));
        Assertions.assertEquals((long)45L, (long)ja.toLong(ctxt.get("b")));
        Assertions.assertEquals((long)56L, (long)ja.toLong(ctxt.get("c")));
        Assertions.assertEquals((long)67L, (long)ja.toLong(ctxt.get("d")));
        Assertions.assertEquals((long)78L, (long)ja.toLong(ctxt.get("e")));
        Assertions.assertEquals((long)10L, (long)ja.toLong((Object)"10"));
        Assertions.assertEquals((long)1L, (long)ja.toLong((Object)true));
        Assertions.assertEquals((long)0L, (long)ja.toLong((Object)false));
    }

    @Test
    void testCoercions() throws Exception {
        this.asserter.assertExpression("1", 1, new Object[0]);
        this.asserter.assertExpression("5L", 5L, new Object[0]);
        this.asserter.setVariable("I2", 2);
        this.asserter.setVariable("L2", 2L);
        this.asserter.setVariable("L3", 3L);
        this.asserter.setVariable("B10", BigInteger.TEN);
        this.asserter.assertExpression("I2 + 2", 4, new Object[0]);
        this.asserter.assertExpression("I2 * 2", 4, new Object[0]);
        this.asserter.assertExpression("I2 - 2", 0, new Object[0]);
        this.asserter.assertExpression("I2 / 2", 1, new Object[0]);
        this.asserter.assertExpression("I2 * L2", 4L, new Object[0]);
        this.asserter.assertExpression("I2 / L2", 1L, new Object[0]);
        this.asserter.assertExpression("L2 + 3", 5L, new Object[0]);
        this.asserter.assertExpression("L2 + L3", 5L, new Object[0]);
        this.asserter.assertExpression("L2 / L2", 1L, new Object[0]);
        this.asserter.assertExpression("L2 / 2", 1L, new Object[0]);
        this.asserter.assertExpression("B10 / 10", BigInteger.ONE, new Object[0]);
        this.asserter.assertExpression("B10 / I2", new BigInteger("5"), new Object[0]);
        this.asserter.assertExpression("B10 / L2", new BigInteger("5"), new Object[0]);
    }

    @Test
    void testCompare() {
        Object[] EXPRESSIONS = new Object[]{"1 == 1", true, "1 === 1", true, "1.d === 1", false, "1 != 1", false, "1 != 2", true, "1 > 2", false, "1 >= 2", false, "1 < 2", true, "1 <= 2", true, "1.0 == 1", true, "1 == 1.0", true, "1.1 != 1", true, "1.1 < 2", true, "1.0b == 1h", true, "1.0b !== 1h", true, "1h == 1.0b", true, "1.1b != 1h", true, "1.1b < 2h", true, "1l == 1.0", true, "1l !== 1.0", true, "1.0d == 1.0f", true, "1l == 1.0b", true, "1l == 1h", true, "1.0d == 1.0b", true, "1.0f == 1.0b", true, "1.0d == 1h", true, "1.0f == 1h", true, "'1' == 1", true, "'1' == 1l", true, "'1' == 1h", true, "'' == 0", true, "'1.0' == 1", true, "'1.0' == 1.0f", true, "'1.0' == 1.0d", true, "'1.0' == 1.0b", true, "'1.01' == 1.01", true, "'1.01' == 1", false, "'1.01' == 1b", false, "'1.01' == 1h", false, "'1.00001' == 1b", false, "'1.00001' == 1h", false, "'1.00000001' == 1", false, "'1.00000001' == 1b", false, "'1.00000001' == 1h", false, "1.0 >= '1'", true, "1.0 > '1'", false, "1.0 == 'a'", false, "10 == 'a'", false, "10 > 'a'", ArithmeticException.class, "10.0 > 'a'", ArithmeticException.class, "'a' <= 10b", ArithmeticException.class, "'a' >= 1h", ArithmeticException.class};
        JexlEngine jexl = new JexlBuilder().create();
        EmptyTestContext jc = new EmptyTestContext();
        for (int e = 0; e < EXPRESSIONS.length; e += 2) {
            String stext = (String)EXPRESSIONS[e];
            Object expected = EXPRESSIONS[e + 1];
            JexlExpression expression = jexl.createExpression(stext);
            try {
                Object result = expression.evaluate((JexlContext)jc);
                Assertions.assertEquals((Object)expected, (Object)result, () -> "failed on " + stext);
                continue;
            }
            catch (JexlException jexlException) {
                Throwable cause = jexlException.getCause();
                if (cause != null && cause.getClass().equals(expected)) continue;
                Assertions.fail((String)stext);
            }
        }
    }

    @Test
    void testDivClass() {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object ra = jexl.createExpression("463.0d / 0.1").evaluate((JexlContext)jc);
        Assertions.assertEquals(Double.class, ra.getClass());
        Object r0 = jexl.createExpression("463.0B / 0.1").evaluate((JexlContext)jc);
        Assertions.assertEquals(BigDecimal.class, r0.getClass());
        Object r1 = jexl.createExpression("463.0B / 0.1B").evaluate((JexlContext)jc);
        Assertions.assertEquals(BigDecimal.class, r1.getClass());
    }

    @Test
    void testDivideByZero() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        JexlEvalContext context = new JexlEvalContext(vars);
        JexlOptions options = context.getEngineOptions();
        options.setStrictArithmetic(true);
        vars.put("aByte", (byte)1);
        vars.put("aShort", (short)2);
        vars.put("aInteger", 3);
        vars.put("aLong", 4L);
        vars.put("aFloat", Float.valueOf(5.5f));
        vars.put("aDouble", 6.6);
        vars.put("aBigInteger", new BigInteger("7"));
        vars.put("aBigDecimal", new BigDecimal("8.8"));
        vars.put("zByte", (byte)0);
        vars.put("zShort", (short)0);
        vars.put("zInteger", 0);
        vars.put("zLong", 0L);
        vars.put("zFloat", Float.valueOf(0.0f));
        vars.put("zDouble", 0.0);
        vars.put("zBigInteger", new BigInteger("0"));
        vars.put("zBigDecimal", new BigDecimal("0"));
        String[] tnames = new String[]{"Byte", "Short", "Integer", "Long", "Float", "Double", "BigInteger", "BigDecimal"};
        int PERMS = tnames.length * tnames.length;
        JexlEngine jexl = this.JEXL;
        for (int s = 0; s < 2; ++s) {
            boolean strict = s != 0;
            options.setStrict(true);
            options.setStrictArithmetic(strict);
            int zthrow = 0;
            int zeval = 0;
            for (String vname : tnames) {
                for (String zname : tnames) {
                    String expr = "a" + vname + " / z" + zname;
                    try {
                        double zero;
                        JexlExpression zexpr = jexl.createExpression(expr);
                        Object nan = zexpr.evaluate((JexlContext)context);
                        if (!(nan instanceof Number) || (zero = ((Number)nan).doubleValue()) != 0.0) continue;
                        ++zeval;
                    }
                    catch (Exception any) {
                        ++zthrow;
                    }
                }
            }
            if (strict) {
                Assertions.assertEquals((int)zthrow, (int)PERMS, (String)("All expressions should have thrown " + zthrow + "/" + PERMS));
                continue;
            }
            Assertions.assertEquals((int)zeval, (int)PERMS, (String)("All expressions should have zeroed " + zeval + "/" + PERMS));
        }
        ArithmeticTest.debuggerCheck(jexl);
    }

    @Test
    void testDivideEdges() {
        ArithmeticTest.assertNullOperand(() -> this.jexla.divide(null, null));
        Assertions.assertEquals((Object)0, (Object)this.jexlb.divide(null, null));
        ArithmeticTest.assertNullOperand(() -> this.jexla.divide(null, null));
        Assertions.assertEquals((Object)0, (Object)this.jexlb.mod(null, null));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.divide((Object)1, (Object)0));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.divide((Object)1L, (Object)0L));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.divide((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f)));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.divide((Object)1.0, (Object)0.0));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.divide((Object)BigInteger.ONE, (Object)BigInteger.ZERO));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.divide((Object)BigInteger.ONE, (Object)BigDecimal.ZERO));
    }

    @Test
    void testEmpty() throws Exception {
        Object[] SCRIPTS = new Object[]{"var x = null; log('x = %s', x);", 0, "var x = 'abc'; log('x = %s', x);", 1, "var x = 333; log('x = %s', x);", 1, "var x = [1, 2]; log('x = %s', x);", 2, "var x = ['a', 'b']; log('x = %s', x);", 2, "var x = {1:'A', 2:'B'}; log('x = %s', x);", 1, "var x = null; return empty(x);", true, "var x = ''; return empty(x);", true, "var x = 'abc'; return empty(x);", false, "var x = 0; return empty(x);", true, "var x = 333; return empty(x);", false, "var x = []; return empty(x);", true, "var x = [1, 2]; return empty(x);", false, "var x = ['a', 'b']; return empty(x);", false, "var x = [...]; return empty(x);", true, "var x = [1, 2,...]; return empty(x);", false, "var x = {:}; return empty(x);", true, "var x = {1:'A', 2:'B'}; return empty(x);", false, "var x = {}; return empty(x);", true, "var x = {'A','B'}; return empty(x);", false};
        JexlEngine jexl = new JexlBuilder().create();
        EmptyTestContext jc = new EmptyTestContext();
        for (int e = 0; e < SCRIPTS.length; e += 2) {
            String stext = (String)SCRIPTS[e];
            Object expected = SCRIPTS[e + 1];
            JexlScript script = jexl.createScript(stext);
            Object result = script.execute((JexlContext)jc);
            Assertions.assertEquals((Object)expected, (Object)result, () -> "failed on " + stext);
        }
    }

    @Test
    void testEmptyDouble() {
        Object x = this.JEXL.createScript("4294967296.d").execute(null);
        Assertions.assertEquals((double)4.294967296E9, (double)((Double)x), (double)1.0E-6);
        this.checkEmpty(x, false);
        x = this.JEXL.createScript("4294967296.0d").execute(null);
        Assertions.assertEquals((double)4.294967296E9, (double)((Double)x), (double)1.0E-6);
        this.checkEmpty(x, false);
        x = this.JEXL.createScript("0.0d").execute(null);
        Assertions.assertEquals((double)0.0, (double)((Double)x), (double)1.0E-6);
        this.checkEmpty(x, true);
        x = Double.NaN;
        this.checkEmpty(x, true);
    }

    @Test
    void testEmptyFloat() {
        Object x = this.JEXL.createScript("4294967296.f").execute(null);
        Assertions.assertEquals((double)4.294967296E9, (double)((Float)x).floatValue(), (double)1.0E-6);
        this.checkEmpty(x, false);
        x = this.JEXL.createScript("4294967296.0f").execute(null);
        Assertions.assertEquals((double)4.294967296E9, (double)((Float)x).floatValue(), (double)1.0E-6);
        this.checkEmpty(x, false);
        x = this.JEXL.createScript("0.0f").execute(null);
        Assertions.assertEquals((double)0.0, (double)((Float)x).floatValue(), (double)1.0E-6);
        this.checkEmpty(x, true);
        x = Float.valueOf(Float.NaN);
        this.checkEmpty(x, true);
    }

    @Test
    void testEmptyLong() {
        Object x = this.JEXL.createScript("new('java.lang.Long', 4294967296)").execute(null);
        Assertions.assertEquals((long)0x100000000L, (long)((Long)x));
        x = this.JEXL.createScript("new Long(4294967296)").execute(null);
        Assertions.assertEquals((long)0x100000000L, (long)((Long)x));
        x = this.JEXL.createScript("new('java.lang.Long', '4294967296')").execute(null);
        Assertions.assertEquals((long)0x100000000L, (long)((Long)x));
        x = this.JEXL.createScript("4294967296l").execute(null);
        Assertions.assertEquals((long)0x100000000L, (long)((Long)x));
        x = this.JEXL.createScript("4294967296L").execute(null);
        Assertions.assertEquals((long)0x100000000L, (long)((Long)x));
        this.checkEmpty(x, false);
        x = this.JEXL.createScript("0L").execute(null);
        Assertions.assertEquals((long)0L, (long)((Long)x));
        this.checkEmpty(x, true);
    }

    @Test
    void testFailAllOperators() {
        String[] scripts = new String[]{"(x, y)->{ x < y }", "(x, y)->{ x <= y }", "(x, y)->{ x > y }", "(x, y)->{ x >= y }", "(x, y)->{ x == y }", "(x, y)->{ x != y }", "(x, y)->{ x === y }", "(x, y)->{ x !== y }", "(x, y)->{ x % y }", "(x, y)->{ x * y }", "(x, y)->{ x + y }", "(x, y)->{ x - y }", "(x, y)->{ x ^ y }", "(x, y)->bitwiseXor(x,y)", "(x, y)->{ x || y }", "(x, y)->{ x | y }", "(x, y)->bitwiseOr(x,y)", "(x, y)->{ x << y }", "(x, y)->{ x >> y }", "(x, y)->{ x >>> y }", "(x, y)->{ x & y }", "(x, y)->{ x && y }", "(x, y)->bitwiseAnd(x,y)", "(x, y)->{ x =^ y }", "(x, y)->{ x !^ y }", "(x, y)->{ x =$ y }", "(x, y)->{ x !$ y }", "(x, y)->{ x =~ y }", "(x, y)->{ x !~ y }", "(x, ignore)->{ -x }", "(x, ignore)->{ +x }", "(x, ignore)->{ --x }", "(x, ignore)->{ ++x }", "(x, ignore)->{ x-- }", "(x, ignore)->{ x++ }"};
        JexlEngine jexl = new JexlBuilder().cache(64).arithmetic((JexlArithmetic)new ArithmeticFail(true)).create();
        EmptyTestContext jc = new EmptyTestContext();
        for (String src : scripts) {
            JexlScript script = jexl.createScript(src);
            Assertions.assertThrows(JexlException.class, () -> ArithmeticTest.lambda$testFailAllOperators$0(script, (JexlContext)jc));
        }
    }

    @Test
    void testInfiniteArithmetic() {
        HashMap<String, Class<Math>> ns = new HashMap<String, Class<Math>>();
        ns.put("math", Math.class);
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new Arithmetic132()).namespaces(ns).create();
        Object evaluate = jexl.createExpression("1/0").evaluate(null);
        Assertions.assertTrue((boolean)Double.isInfinite((Double)evaluate));
        evaluate = jexl.createExpression("-1/0").evaluate(null);
        Assertions.assertTrue((boolean)Double.isInfinite((Double)evaluate));
        evaluate = jexl.createExpression("1.0/0.0").evaluate(null);
        Assertions.assertTrue((boolean)Double.isInfinite((Double)evaluate));
        evaluate = jexl.createExpression("-1.0/0.0").evaluate(null);
        Assertions.assertTrue((boolean)Double.isInfinite((Double)evaluate));
        evaluate = jexl.createExpression("math:abs(-42)").evaluate(null);
        Assertions.assertEquals((Object)42, (Object)evaluate);
        evaluate = jexl.createExpression("42B / 7").evaluate(null);
        Assertions.assertEquals((Object)6, (Object)evaluate);
        evaluate = jexl.createExpression("42.7B / 7").evaluate(null);
        Assertions.assertEquals((Object)BigDecimal.valueOf(6.1), (Object)evaluate);
    }

    @Test
    void testInstanceOf0() {
        JexlEngine jexl = new JexlBuilder().strict(true).safe(false).create();
        InstanceofContext ctxt = new InstanceofContext();
        this.runInstanceof(jexl, (JexlContext)ctxt);
    }

    @Test
    void testInstanceOf1() {
        JexlEngine jexl = new JexlBuilder().strict(true).safe(false).imports(new String[]{"java.lang"}).create();
        this.runInstanceof(jexl, null);
    }

    @Test
    void testIntegerCoercionEdges() {
        ArithmeticTest.assertNullOperand(() -> this.jexla.toBoolean(null));
        Assertions.assertTrue((boolean)this.jexla.toBoolean((Object)this.date));
        ArithmeticTest.assertNullOperand(() -> this.jexla.toInteger(null));
        Assertions.assertEquals((int)0, (int)this.jexlb.toInteger(null));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.toInteger((Object)this.date));
        Assertions.assertEquals((int)0, (int)this.jexla.toInteger((Object)Double.NaN));
        Assertions.assertEquals((int)0, (int)this.jexla.toInteger((Object)""));
        Assertions.assertEquals((int)98, (int)this.jexla.toInteger((Object)Character.valueOf('b')));
        Assertions.assertEquals((int)1, (int)this.jexla.toInteger((Object)new AtomicBoolean(true)));
        Assertions.assertEquals((int)0, (int)this.jexla.toInteger((Object)new AtomicBoolean()));
        ArithmeticTest.assertNullOperand(() -> this.jexla.toLong(null));
        Assertions.assertEquals((long)0L, (long)this.jexlb.toLong(null));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.toLong((Object)this.date));
        Assertions.assertEquals((long)0L, (long)this.jexla.toLong((Object)Double.NaN));
        Assertions.assertEquals((long)0L, (long)this.jexla.toLong((Object)""));
        Assertions.assertEquals((long)98L, (long)this.jexla.toLong((Object)Character.valueOf('b')));
        Assertions.assertEquals((long)1L, (long)this.jexla.toLong((Object)new AtomicBoolean(true)));
        Assertions.assertEquals((long)0L, (long)this.jexla.toLong((Object)new AtomicBoolean()));
    }

    @Test
    void testIsFloatingPointPattern() {
        JexlArithmetic ja = new JexlArithmetic(true);
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"floating point"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"a1."));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"b1.2"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"-10.2a-34"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"+10.2a+34"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"0"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"1"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"12A"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"2F3"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"23"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"+3"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"+34"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"+3-4"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"+3.-4"));
        Assertions.assertFalse((boolean)ja.isFloatingPointNumber((Object)"3ee4"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"0."));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"1."));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"1.2"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"1.2e3"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"2e3"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+2e-3"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+23E-34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+23.E-34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"-23.4E+45"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"1.2e34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"10.2e34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+10.2e34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"-10.2e34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"10.2e-34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"10.2e+34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"-10.2e-34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+10.2e+34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"-10.2E-34"));
        Assertions.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+10.2E+34"));
    }

    @Test
    void testJexl173() {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Callable173 c173 = new Callable173();
        JexlScript e = jexl.createScript("c173(9, 6)", new String[]{"c173"});
        Object result = e.execute((JexlContext)jc, new Object[]{c173});
        Assertions.assertEquals((Object)54, (Object)result);
        e = jexl.createScript("c173('fourty', 'two')", new String[]{"c173"});
        result = e.execute((JexlContext)jc, new Object[]{c173});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void testLeftNullOperand() throws Exception {
        this.asserter.setVariable("left", null);
        this.asserter.setVariable("right", 8);
        this.asserter.setStrict(true);
        this.asserter.failExpression("left + right", ".*null.*");
        this.asserter.failExpression("left - right", ".*null.*");
        this.asserter.failExpression("left * right", ".*null.*");
        this.asserter.failExpression("left / right", ".*null.*");
        this.asserter.failExpression("left % right", ".*null.*");
        this.asserter.failExpression("left & right", ".*null.*");
        this.asserter.failExpression("left | right", ".*null.*");
        this.asserter.failExpression("left ^ right", ".*null.*");
        this.asserter.failExpression("left < right", ".*null.*");
        this.asserter.failExpression("left <= right", ".*null.*");
        this.asserter.failExpression("left > right", ".*null.*");
        this.asserter.failExpression("left >= right", ".*null.*");
    }

    @Test
    void testLeftNullOperand2() throws Exception {
        this.asserter.setVariable("x.left", null);
        this.asserter.setVariable("right", 8);
        this.asserter.setStrict(true);
        this.asserter.failExpression("x.left + right", ".*null.*");
        this.asserter.failExpression("x.left - right", ".*null.*");
        this.asserter.failExpression("x.left * right", ".*null.*");
        this.asserter.failExpression("x.left / right", ".*null.*");
        this.asserter.failExpression("x.left % right", ".*null.*");
        this.asserter.failExpression("x.left & right", ".*null.*");
        this.asserter.failExpression("x.left | right", ".*null.*");
        this.asserter.failExpression("x.left ^ right", ".*null.*");
        this.asserter.failExpression("x.left < right", ".*null.*");
        this.asserter.failExpression("x.left <= right", ".*null.*");
        this.asserter.failExpression("x.left > right", ".*null.*");
        this.asserter.failExpression("x.left >= right", ".*null.*");
    }

    @Test
    void testLongLiterals() {
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrictArithmetic(true);
        String stmt = "{a = 10L; b = 10l; c = 42.0D; d = 42.0d; e=56.3F; f=56.3f; g=63.5; h=0x10; i=010; j=0x10L; k=010l}";
        JexlScript expr = this.JEXL.createScript("{a = 10L; b = 10l; c = 42.0D; d = 42.0d; e=56.3F; f=56.3f; g=63.5; h=0x10; i=010; j=0x10L; k=010l}");
        expr.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)10L, (Object)ctxt.get("a"));
        Assertions.assertEquals((Object)10L, (Object)ctxt.get("b"));
        Assertions.assertEquals((Object)42.0, (Object)ctxt.get("c"));
        Assertions.assertEquals((Object)42.0, (Object)ctxt.get("d"));
        Assertions.assertEquals((Object)Float.valueOf(56.3f), (Object)ctxt.get("e"));
        Assertions.assertEquals((Object)Float.valueOf(56.3f), (Object)ctxt.get("f"));
        Assertions.assertEquals((Object)63.5, (Object)ctxt.get("g"));
        Assertions.assertEquals((Object)16, (Object)ctxt.get("h"));
        Assertions.assertEquals((Object)8, (Object)ctxt.get("i"));
        Assertions.assertEquals((Object)16L, (Object)ctxt.get("j"));
        Assertions.assertEquals((Object)8L, (Object)ctxt.get("k"));
    }

    @Test
    void testMinusClass() {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object ra = jexl.createExpression("463.0d - 0.1").evaluate((JexlContext)jc);
        Assertions.assertEquals(Double.class, ra.getClass());
        Object r0 = jexl.createExpression("463.0B - 0.1").evaluate((JexlContext)jc);
        Assertions.assertEquals(BigDecimal.class, r0.getClass());
        Object r1 = jexl.createExpression("463.0B - 0.1B").evaluate((JexlContext)jc);
        Assertions.assertEquals(BigDecimal.class, r1.getClass());
    }

    @Test
    void testMinusMinusPostfix() throws Exception {
        this.asserter.setVariable("aByte", (byte)2);
        this.asserter.setVariable("aShort", (short)3);
        this.asserter.setVariable("anInteger", 4);
        this.asserter.setVariable("aLong", 5L);
        this.asserter.setVariable("aFloat", Float.valueOf(6.6f));
        this.asserter.setVariable("aDouble", 7.7);
        this.asserter.setVariable("aBigInteger", new BigInteger("8"));
        this.asserter.setVariable("aBigDecimal", new BigDecimal("9.9"));
        this.asserter.setVariable("aString", "forty-two");
        this.asserter.assertExpression("aByte--", (byte)2, new Object[0]);
        this.asserter.assertExpression("aShort--", (short)3, new Object[0]);
        this.asserter.assertExpression("anInteger--", 4, new Object[0]);
        this.asserter.assertExpression("aLong--", 5L, new Object[0]);
        this.asserter.assertExpression("aFloat--", Float.valueOf(6.6f), new Object[0]);
        this.asserter.assertExpression("aDouble--", 7.7, new Object[0]);
        this.asserter.assertExpression("aBigInteger--", new BigInteger("8"), new Object[0]);
        this.asserter.assertExpression("aBigDecimal--", new BigDecimal("9.9"), new Object[0]);
        this.asserter.assertExpression("aByte", (byte)1, new Object[0]);
        this.asserter.assertExpression("aShort", (short)2, new Object[0]);
        this.asserter.assertExpression("anInteger", 3, new Object[0]);
        this.asserter.assertExpression("aLong", 4L, new Object[0]);
        this.asserter.assertExpression("aFloat", Float.valueOf(5.6f), new Object[0]);
        this.asserter.assertExpression("aDouble", 6.7, new Object[0]);
        this.asserter.assertExpression("aBigInteger", new BigInteger("7"), new Object[0]);
        this.asserter.assertExpression("aBigDecimal", new BigDecimal("8.9"), new Object[0]);
        this.asserter.failExpression("aString--", "--", String::contains);
    }

    @Test
    void testMinusMinusPrefix() throws Exception {
        this.asserter.setVariable("aByte", (byte)2);
        this.asserter.setVariable("aShort", (short)3);
        this.asserter.setVariable("anInteger", 4);
        this.asserter.setVariable("aLong", 5L);
        this.asserter.setVariable("aFloat", Float.valueOf(6.6f));
        this.asserter.setVariable("aDouble", 7.7);
        this.asserter.setVariable("aBigInteger", new BigInteger("8"));
        this.asserter.setVariable("aBigDecimal", new BigDecimal("9.9"));
        this.asserter.setVariable("aString", "forty-two");
        this.asserter.assertExpression("--aByte", (byte)1, new Object[0]);
        this.asserter.assertExpression("--aShort", (short)2, new Object[0]);
        this.asserter.assertExpression("--anInteger", 3, new Object[0]);
        this.asserter.assertExpression("--aLong", 4L, new Object[0]);
        this.asserter.assertExpression("--aFloat", Float.valueOf(5.6f), new Object[0]);
        this.asserter.assertExpression("--aDouble", 6.7, new Object[0]);
        this.asserter.assertExpression("--aBigInteger", new BigInteger("7"), new Object[0]);
        this.asserter.assertExpression("--aBigDecimal", new BigDecimal("8.9"), new Object[0]);
        this.asserter.failExpression("aString--", "--", String::contains);
    }

    @Test
    void testModEdge() {
        ArithmeticTest.assertNullOperand(() -> this.jexla.mod(null, null));
        Assertions.assertEquals((Object)0, (Object)this.jexlb.mod(null, null));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.mod((Object)1, (Object)0));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.mod((Object)1L, (Object)0L));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.mod((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f)));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.mod((Object)1.0, (Object)0.0));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.mod((Object)BigInteger.ONE, (Object)BigInteger.ZERO));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.mod((Object)BigInteger.ONE, (Object)BigDecimal.ZERO));
        ArithmeticTest.assertNullOperand(() -> this.jexla.divide(null, null));
    }

    @Test
    void testMultClass() {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object ra = jexl.createExpression("463.0d * 0.1").evaluate((JexlContext)jc);
        Assertions.assertEquals(Double.class, ra.getClass());
        Object r0 = jexl.createExpression("463.0B * 0.1").evaluate((JexlContext)jc);
        Assertions.assertEquals(BigDecimal.class, r0.getClass());
        Object r1 = jexl.createExpression("463.0B * 0.1B").evaluate((JexlContext)jc);
        Assertions.assertEquals(BigDecimal.class, r1.getClass());
    }

    @Test
    void testNaN() {
        HashMap<String, Class<Double>> ns = new HashMap<String, Class<Double>>();
        ns.put("double", Double.class);
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        JexlScript script = jexl.createScript("#NaN");
        Object result = script.execute(null);
        Assertions.assertTrue((boolean)Double.isNaN((Double)result));
        script = jexl.createScript("NaN");
        result = script.execute(null);
        Assertions.assertTrue((boolean)Double.isNaN((Double)result));
        script = jexl.createScript("double:isNaN(#NaN)");
        result = script.execute(null);
        Assertions.assertTrue((boolean)((Boolean)result));
        script = jexl.createScript("double:isNaN(NaN)");
        result = script.execute(null);
        Assertions.assertTrue((boolean)((Boolean)result));
    }

    @Test
    void testNarrowBigDecimal() throws Exception {
        List<String> ls = Arrays.asList("zero", "one", "two");
        this.asserter.setVariable("list", ls);
        this.asserter.assertExpression("a -> list.get(a)", "zero", BigDecimal.ZERO);
        this.asserter.assertExpression("a -> list.get(a)", "one", BigDecimal.ONE);
        this.asserter.assertExpression("a -> list.get(2B)", "two", new Object[0]);
        BigDecimal bd42 = BigDecimal.valueOf(42L);
        this.asserter.setVariable("bd10", BigDecimal.valueOf(10.0));
        this.asserter.setVariable("bd420", BigDecimal.valueOf(420.0));
        this.asserter.assertExpression("420 / bd10", bd42, new Object[0]);
        this.asserter.assertExpression("420l / bd10", bd42, new Object[0]);
        this.asserter.assertExpression("420H / bd10", bd42, new Object[0]);
        this.asserter.assertExpression("bd420 / 10", bd42, new Object[0]);
        this.asserter.assertExpression("bd420 / 10H", bd42, new Object[0]);
        this.asserter.assertExpression("bd420 / 10B", bd42, new Object[0]);
    }

    @Test
    void testNarrowBigInteger() throws Exception {
        List<String> ls = Arrays.asList("zero", "one", "two");
        this.asserter.setVariable("list", ls);
        this.asserter.assertExpression("a -> list.get(a)", "zero", BigInteger.ZERO);
        this.asserter.assertExpression("a -> list.get(a)", "one", BigInteger.ONE);
        this.asserter.assertExpression("a -> list.get(2H)", "two", new Object[0]);
        BigInteger b42 = BigInteger.valueOf(42L);
        this.asserter.setVariable("bi10", BigInteger.valueOf(10L));
        this.asserter.setVariable("bi420", BigInteger.valueOf(420L));
        this.asserter.assertExpression("420 / bi10", b42, new Object[0]);
        this.asserter.assertExpression("420l / bi10", b42, new Object[0]);
        this.asserter.assertExpression("bi420 / 420", BigInteger.ONE, new Object[0]);
        this.asserter.assertExpression("bi420 / 420l", BigInteger.ONE, new Object[0]);
        this.asserter.assertExpression("bi420 / 420H", BigInteger.ONE, new Object[0]);
    }

    @Test
    void testNullArgs() {
        JexlEngine jexl = new JexlBuilder().arithmetic(new JexlArithmetic(true){

            public boolean isStrict(JexlOperator op) {
                return JexlOperator.ADD != op && super.isStrict(op);
            }
        }).create();
        JexlScript script = jexl.createScript("'1.2' + x ", new String[]{"x"});
        Object result = script.execute(null);
        Assertions.assertEquals((Object)"1.2", (Object)result);
    }

    @Test
    void testNullOperand() throws Exception {
        this.asserter.setVariable("right", null);
        this.asserter.failExpression("~right", ".*null.*");
    }

    @Test
    void testNullOperands() throws Exception {
        this.asserter.setVariable("left", null);
        this.asserter.setVariable("right", null);
        this.asserter.failExpression("left + right", ".*null.*");
        this.asserter.failExpression("left - right", ".*null.*");
        this.asserter.failExpression("left * right", ".*null.*");
        this.asserter.failExpression("left / right", ".*null.*");
        this.asserter.failExpression("left % right", ".*null.*");
        this.asserter.failExpression("left & right", ".*null.*");
        this.asserter.failExpression("left | right", ".*null.*");
        this.asserter.failExpression("left ^ right", ".*null.*");
    }

    @Test
    void testOperatorsEdges() {
        ArithmeticTest.assertNullOperand(() -> this.jexla.multiply(null, null));
        Assertions.assertEquals((Object)0, (Object)this.jexlb.multiply(null, null));
        ArithmeticTest.assertNullOperand(() -> this.jexla.add(null, null));
        Assertions.assertEquals((Object)0, (Object)this.jexlb.add(null, null));
        ArithmeticTest.assertNullOperand(() -> this.jexla.subtract(null, null));
        Assertions.assertEquals((Object)0, (Object)this.jexlb.subtract(null, null));
        Assertions.assertTrue((boolean)this.jexla.contains(null, null));
        Assertions.assertFalse((boolean)this.jexla.contains((Object)true, null));
        Assertions.assertFalse((boolean)this.jexla.contains(null, (Object)true));
        Assertions.assertTrue((boolean)this.jexla.endsWith(null, null));
        Assertions.assertFalse((boolean)this.jexla.endsWith((Object)true, null));
        Assertions.assertFalse((boolean)this.jexla.endsWith(null, (Object)true));
        Assertions.assertTrue((boolean)this.jexla.startsWith(null, null));
        Assertions.assertFalse((boolean)this.jexla.startsWith((Object)true, null));
        Assertions.assertFalse((boolean)this.jexla.startsWith(null, (Object)true));
        Assertions.assertTrue((boolean)this.jexla.isEmpty(null));
    }

    @Test
    void testOption() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        JexlEvalContext context = new JexlEvalContext(vars);
        JexlOptions options = context.getEngineOptions();
        options.setStrictArithmetic(true);
        JexlScript script = this.JEXL.createScript("0 + '1.2' ");
        options.setStrictArithmetic(true);
        Object result = script.execute((JexlContext)context);
        Assertions.assertEquals((Object)"01.2", (Object)result);
        options.setStrictArithmetic(false);
        result = script.execute((JexlContext)context);
        Assertions.assertEquals((double)1.2, (double)((Double)result), (double)1.0E-6);
    }

    @Test
    void testOverflows() throws Exception {
        this.asserter.assertExpression("1 + 2147483647", Long.valueOf("2147483648"), new Object[0]);
        this.asserter.assertExpression("3 + 9223372036854775805", BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE), new Object[0]);
        this.asserter.assertExpression("-2147483648 - 1", Long.valueOf("-2147483649"), new Object[0]);
        this.asserter.assertExpression("-3 + -9223372036854775806", BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE), new Object[0]);
        this.asserter.assertExpression("1 + 9223372036854775807", new BigInteger("9223372036854775808"), new Object[0]);
        this.asserter.assertExpression("-1 + (-9223372036854775808)", new BigInteger("-9223372036854775809"), new Object[0]);
        this.asserter.assertExpression("-9223372036854775808 - 1", new BigInteger("-9223372036854775809"), new Object[0]);
        BigInteger maxl = BigInteger.valueOf(Long.MAX_VALUE);
        this.asserter.assertExpression(maxl + " * " + maxl, maxl.multiply(maxl), new Object[0]);
    }

    @Test
    void testPlusClass() {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object ra = jexl.createExpression("463.0d + 0.1").evaluate((JexlContext)jc);
        Assertions.assertEquals(Double.class, ra.getClass());
        Object r0 = jexl.createExpression("463.0B + 0.1").evaluate((JexlContext)jc);
        Assertions.assertEquals(BigDecimal.class, r0.getClass());
        Object r1 = jexl.createExpression("463.0B + 0.1B").evaluate((JexlContext)jc);
        Assertions.assertEquals(BigDecimal.class, r1.getClass());
    }

    @Test
    void testPlusPlusPostfix() throws Exception {
        this.asserter.setVariable("aByte", (byte)0);
        this.asserter.setVariable("aShort", (short)1);
        this.asserter.setVariable("anInteger", 2);
        this.asserter.setVariable("aLong", 3L);
        this.asserter.setVariable("aFloat", Float.valueOf(4.4f));
        this.asserter.setVariable("aDouble", 5.5);
        this.asserter.setVariable("aBigInteger", new BigInteger("6"));
        this.asserter.setVariable("aBigDecimal", new BigDecimal("7.7"));
        this.asserter.setVariable("aString", "forty-two");
        this.asserter.assertExpression("aByte++", (byte)0, new Object[0]);
        this.asserter.assertExpression("aShort++", (short)1, new Object[0]);
        this.asserter.assertExpression("anInteger++", 2, new Object[0]);
        this.asserter.assertExpression("aLong++", 3L, new Object[0]);
        this.asserter.assertExpression("aFloat++", Float.valueOf(4.4f), new Object[0]);
        this.asserter.assertExpression("aDouble++", 5.5, new Object[0]);
        this.asserter.assertExpression("aBigInteger++", new BigInteger("6"), new Object[0]);
        this.asserter.assertExpression("aBigDecimal++", new BigDecimal("7.7"), new Object[0]);
        this.asserter.assertExpression("aByte", (byte)1, new Object[0]);
        this.asserter.assertExpression("aShort", (short)2, new Object[0]);
        this.asserter.assertExpression("anInteger", 3, new Object[0]);
        this.asserter.assertExpression("aLong", 4L, new Object[0]);
        this.asserter.assertExpression("aFloat", Float.valueOf(5.4f), new Object[0]);
        this.asserter.assertExpression("aDouble", 6.5, new Object[0]);
        this.asserter.assertExpression("aBigInteger", new BigInteger("7"), new Object[0]);
        this.asserter.assertExpression("aBigDecimal", new BigDecimal("8.7"), new Object[0]);
        this.asserter.failExpression("aString++", "++", String::contains);
    }

    @Test
    void testPlusPlusPrefix() throws Exception {
        this.asserter.setVariable("aByte", (byte)0);
        this.asserter.setVariable("aShort", (short)1);
        this.asserter.setVariable("anInteger", 2);
        this.asserter.setVariable("aLong", 3L);
        this.asserter.setVariable("aFloat", Float.valueOf(4.4f));
        this.asserter.setVariable("aDouble", 5.5);
        this.asserter.setVariable("aBigInteger", new BigInteger("6"));
        this.asserter.setVariable("aBigDecimal", new BigDecimal("7.7"));
        this.asserter.setVariable("aString", "forty-two");
        this.asserter.assertExpression("++aByte", (byte)1, new Object[0]);
        this.asserter.assertExpression("++aShort", (short)2, new Object[0]);
        this.asserter.assertExpression("++anInteger", 3, new Object[0]);
        this.asserter.assertExpression("++aLong", 4L, new Object[0]);
        this.asserter.assertExpression("++aFloat", Float.valueOf(5.4f), new Object[0]);
        this.asserter.assertExpression("++aDouble", 6.5, new Object[0]);
        this.asserter.assertExpression("++aBigInteger", new BigInteger("7"), new Object[0]);
        this.asserter.assertExpression("++aBigDecimal", new BigDecimal("8.7"), new Object[0]);
        this.asserter.failExpression("++aString", "++", String::contains);
    }

    @Test
    void testRealCoercionEdges() throws Exception {
        ArithmeticTest.assertNullOperand(() -> this.jexla.toDouble(null));
        Assertions.assertEquals((double)0.0, (double)this.jexlb.toDouble(null), (double)1.0E-6);
        Assertions.assertEquals((double)32.0, (double)this.jexlb.toDouble((Object)Character.valueOf(' ')), (double)1.0E-6);
        ArithmeticTest.assertArithmeticException(() -> this.jexla.toDouble((Object)this.date));
        Assertions.assertTrue((boolean)Double.isNaN(this.jexla.toDouble((Object)"")));
        Assertions.assertEquals((Object)"", (Object)this.jexla.toString((Object)Double.NaN));
        ArithmeticTest.assertNullOperand(() -> this.jexla.toBigInteger(null));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.toBigInteger((Object)this.date));
        Assertions.assertEquals((Object)BigInteger.ZERO, (Object)this.jexla.toBigInteger((Object)Double.NaN));
        Assertions.assertEquals((Object)BigInteger.ZERO, (Object)this.jexla.toBigInteger((Object)""));
        Assertions.assertEquals((Object)BigInteger.ZERO, (Object)this.jexla.toBigInteger((Object)Character.valueOf('\u0000')));
        ArithmeticTest.assertNullOperand(() -> this.jexla.toBigDecimal(null));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.toBigDecimal((Object)this.date));
        Assertions.assertEquals((Object)BigDecimal.ZERO, (Object)this.jexla.toBigDecimal((Object)Double.NaN));
        Assertions.assertEquals((Object)BigDecimal.ZERO, (Object)this.jexla.toBigDecimal((Object)""));
        Assertions.assertEquals((Object)BigDecimal.ZERO, (Object)this.jexla.toBigDecimal((Object)Character.valueOf('\u0000')));
        Double d64d3 = 2.1333333333333333;
        Assertions.assertEquals((double)d64d3, (double)((Number)this.JEXL.createExpression("6.4 / 3").evaluate(null)).doubleValue(), (double)1.0E-6);
        this.asserter.assertExpression("6.4 / 3", d64d3, new Object[0]);
        Assertions.assertEquals((double)d64d3, (double)((Number)this.JEXL.createExpression("6.4 / 3d").evaluate(null)).doubleValue(), (double)1.0E-6);
        this.asserter.assertExpression("6.4 / 3d", d64d3, new Object[0]);
        Assertions.assertEquals((double)21.333333333333332, (double)((Number)this.JEXL.createExpression("64d / 3").evaluate(null)).doubleValue(), (double)1.0E-6);
        this.asserter.assertExpression("64 / 3d", 21.333333333333332, new Object[0]);
    }

    @Test
    void testRightNullOperand() throws Exception {
        this.asserter.setVariable("left", 9);
        this.asserter.setVariable("right", null);
        this.asserter.failExpression("left + right", ".*null.*");
        this.asserter.failExpression("left - right", ".*null.*");
        this.asserter.failExpression("left * right", ".*null.*");
        this.asserter.failExpression("left / right", ".*null.*");
        this.asserter.failExpression("left % right", ".*null.*");
        this.asserter.failExpression("left & right", ".*null.*");
        this.asserter.failExpression("left | right", ".*null.*");
        this.asserter.failExpression("left ^ right", ".*null.*");
        this.asserter.failExpression("left < right", ".*null.*");
        this.asserter.failExpression("left <= right", ".*null.*");
        this.asserter.failExpression("left > right", ".*null.*");
        this.asserter.failExpression("left >= right", ".*null.*");
    }

    @Test
    void testRightNullOperand2() throws Exception {
        this.asserter.setVariable("left", 9);
        this.asserter.setVariable("y.right", null);
        this.asserter.failExpression("left + y.right", ".*null.*");
        this.asserter.failExpression("left - y.right", ".*null.*");
        this.asserter.failExpression("left * y.right", ".*null.*");
        this.asserter.failExpression("left / y.right", ".*null.*");
        this.asserter.failExpression("left % y.right", ".*null.*");
        this.asserter.failExpression("left & y.right", ".*null.*");
        this.asserter.failExpression("left | y.right", ".*null.*");
        this.asserter.failExpression("left ^ y.right", ".*null.*");
        this.asserter.failExpression("left < y.right", ".*null.*");
        this.asserter.failExpression("left <= y.right", ".*null.*");
        this.asserter.failExpression("left > y.right", ".*null.*");
        this.asserter.failExpression("left >= y.right", ".*null.*");
    }

    @Test
    void testUnaryMinus() throws Exception {
        this.asserter.setVariable("aByte", (byte)1);
        this.asserter.setVariable("aShort", (short)2);
        this.asserter.setVariable("anInteger", 3);
        this.asserter.setVariable("aLong", 4L);
        this.asserter.setVariable("aFloat", Float.valueOf(5.5f));
        this.asserter.setVariable("aDouble", 6.6);
        this.asserter.setVariable("aBigInteger", new BigInteger("7"));
        this.asserter.setVariable("aBigDecimal", new BigDecimal("8.8"));
        for (int i = 0; i < 2; ++i) {
            this.asserter.assertExpression("-3", Integer.valueOf("-3"), new Object[0]);
            this.asserter.assertExpression("-3.0", Double.valueOf("-3.0"), new Object[0]);
            this.asserter.assertExpression("-aByte", (byte)-1, new Object[0]);
            this.asserter.assertExpression("-aShort", (short)-2, new Object[0]);
            this.asserter.assertExpression("-anInteger", -3, new Object[0]);
            this.asserter.assertExpression("-aLong", -4L, new Object[0]);
            this.asserter.assertExpression("-aFloat", Float.valueOf(-5.5f), new Object[0]);
            this.asserter.assertExpression("-aDouble", -6.6, new Object[0]);
            this.asserter.assertExpression("-aBigInteger", new BigInteger("-7"), new Object[0]);
            this.asserter.assertExpression("-aBigDecimal", new BigDecimal("-8.8"), new Object[0]);
        }
    }

    @Test
    void testUnaryopsEdges() {
        ArithmeticTest.assertArithmeticException(() -> this.jexla.positivize((Object)this.date));
        ArithmeticTest.assertNullOperand(() -> this.jexla.positivize(null));
        Assertions.assertNull((Object)this.jexlb.positivize(null));
        Assertions.assertEquals((Object)42, (Object)this.jexla.positivize((Object)Character.valueOf('*')));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.jexla.positivize((Object)Boolean.TRUE));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.jexla.positivize((Object)Boolean.FALSE));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.jexla.positivize((Object)new AtomicBoolean(true)));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.jexla.positivize((Object)new AtomicBoolean()));
        ArithmeticTest.assertNullOperand(() -> this.jexla.negate(null));
        Assertions.assertNull((Object)this.jexlb.negate(null));
        ArithmeticTest.assertArithmeticException(() -> this.jexla.negate((Object)this.date));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.jexla.negate((Object)Boolean.TRUE));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.jexla.negate((Object)Boolean.FALSE));
    }

    @Test
    void testUnaryPlus() throws Exception {
        this.asserter.setVariable("aByte", (byte)1);
        this.asserter.setVariable("aShort", (short)2);
        this.asserter.setVariable("anInteger", 3);
        this.asserter.setVariable("aLong", 4L);
        this.asserter.setVariable("aFloat", Float.valueOf(5.5f));
        this.asserter.setVariable("aDouble", 6.6);
        this.asserter.setVariable("aBigInteger", new BigInteger("7"));
        this.asserter.setVariable("aBigDecimal", new BigDecimal("8.8"));
        for (int i = 0; i < 2; ++i) {
            this.asserter.assertExpression("+3", Integer.valueOf("3"), new Object[0]);
            this.asserter.assertExpression("+3.0", Double.valueOf("3.0"), new Object[0]);
            this.asserter.assertExpression("+aByte", 1, new Object[0]);
            this.asserter.assertExpression("+aShort", 2, new Object[0]);
            this.asserter.assertExpression("+anInteger", 3, new Object[0]);
            this.asserter.assertExpression("+aLong", 4L, new Object[0]);
            this.asserter.assertExpression("+aFloat", Float.valueOf(5.5f), new Object[0]);
            this.asserter.assertExpression("+aDouble", 6.6, new Object[0]);
            this.asserter.assertExpression("+aBigInteger", new BigInteger("7"), new Object[0]);
            this.asserter.assertExpression("+aBigDecimal", new BigDecimal("8.8"), new Object[0]);
        }
    }

    @Test
    void testUndefinedVar() throws Exception {
        this.asserter.failExpression("objects[1].status", ".*variable 'objects' is undefined.*");
    }

    @Test
    void testXmlArithmetic() throws Exception {
        Object xx;
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlEngine jexl = new JexlBuilder().strict(true).safe(false).arithmetic((JexlArithmetic)new XmlArithmetic(false)).create();
        JexlScript e0 = jexl.createScript("x.empty()", new String[]{"x"});
        JexlScript e1 = jexl.createScript("empty(x)", new String[]{"x"});
        JexlScript s0 = jexl.createScript("x.size()", new String[]{"x"});
        JexlScript s1 = jexl.createScript("size(x)", new String[]{"x"});
        Boolean empty = (Boolean)e1.execute(null, new Object[]{null});
        Assertions.assertTrue((boolean)empty);
        int size = (Integer)s1.execute(null, new Object[]{null});
        Assertions.assertEquals((int)0, (int)size);
        try {
            xx = e0.execute(null, new Object[]{null});
            Assertions.assertNull((Object)xx);
        }
        catch (JexlException.Variable xvar) {
            Assertions.assertNotNull((Object)((Object)xvar));
        }
        try {
            xx = s0.execute(null, new Object[]{null});
            Assertions.assertNull((Object)xx);
        }
        catch (JexlException.Variable xvar) {
            Assertions.assertNotNull((Object)((Object)xvar));
        }
        JexlOptions options = ctxt.getEngineOptions();
        options.setSafe(true);
        Object x0 = e0.execute((JexlContext)ctxt, new Object[]{null});
        Assertions.assertNull((Object)x0);
        Object x1 = s0.execute((JexlContext)ctxt, new Object[]{null});
        Assertions.assertNull((Object)x1);
        Document xml = ArithmeticTest.getDocument("<node info='123'/>");
        Node x = xml.getLastChild();
        empty = (Boolean)e0.execute(null, new Object[]{x});
        Assertions.assertFalse((boolean)empty);
        empty = (Boolean)e1.execute(null, new Object[]{x});
        Assertions.assertFalse((boolean)empty);
        size = (Integer)s0.execute(null, new Object[]{x});
        Assertions.assertEquals((int)0, (int)size);
        size = (Integer)s1.execute(null, new Object[]{x});
        Assertions.assertEquals((int)0, (int)size);
        xml = ArithmeticTest.getDocument("<node><a/><b/></node>");
        x = xml.getLastChild();
        empty = (Boolean)e0.execute(null, new Object[]{x});
        Assertions.assertFalse((boolean)empty);
        empty = (Boolean)e1.execute(null, new Object[]{x});
        Assertions.assertFalse((boolean)empty);
        size = (Integer)s0.execute(null, new Object[]{x});
        Assertions.assertEquals((int)2, (int)size);
        size = (Integer)s1.execute(null, new Object[]{x});
        Assertions.assertEquals((int)2, (int)size);
        xml = ArithmeticTest.getDocument("<node/>");
        x = xml.getLastChild();
        empty = (Boolean)e0.execute(null, new Object[]{x});
        Assertions.assertTrue((boolean)empty);
        empty = (Boolean)e1.execute(null, new Object[]{x});
        Assertions.assertTrue((boolean)empty);
        size = (Integer)s0.execute(null, new Object[]{x});
        Assertions.assertEquals((int)0, (int)size);
        size = (Integer)s1.execute(null, new Object[]{x});
        Assertions.assertEquals((int)0, (int)size);
        xml = ArithmeticTest.getDocument("<node info='123'/>");
        NamedNodeMap nnm = xml.getLastChild().getAttributes();
        Attr info = (Attr)nnm.getNamedItem("info");
        Assertions.assertEquals((Object)"123", (Object)info.getValue());
        MapContext jc = new MapContext();
        jc.set("x", (Object)xml.getLastChild());
        String y = "456";
        jc.set("y", (Object)"456");
        JexlScript s = jexl.createScript("x.attribute.info = y");
        try {
            Object r = s.execute((JexlContext)jc);
            nnm = xml.getLastChild().getAttributes();
            info = (Attr)nnm.getNamedItem("info");
            Assertions.assertEquals((Object)"456", (Object)r);
            Assertions.assertEquals((Object)"456", (Object)info.getValue());
        }
        catch (JexlException.Property xprop) {
            Assertions.assertTrue((boolean)xprop.getMessage().contains("info"));
            Assertions.assertTrue((ArithmeticTest.getJavaVersion() > 11 ? 1 : 0) != 0);
        }
    }

    @Test
    void testShortCircuitAnd() {
        String src = "(x, y, z) -> x && y && z";
        JexlBuilder builder = new JexlBuilder();
        JexlEngine jexl = builder.create();
        JexlScript script = jexl.createScript("(x, y, z) -> x && y && z");
        Object result = script.execute(null, new Object[]{true, "foo", 42});
        Assertions.assertEquals((Object)42, (Object)result);
        result = script.execute(null, new Object[]{true, "", 42});
        Assertions.assertEquals((Object)"", (Object)result);
    }

    @Test
    void testShortCircuitOr() {
        OptContext optc = new OptContext();
        String src = "(x, y, z) -> x || y || z";
        JexlBuilder builder = new JexlBuilder();
        JexlEngine jexl = builder.create();
        JexlOptions options = builder.options();
        optc.setOptions(options);
        JexlScript script = jexl.createScript("(x, y, z) -> x || y || z");
        Object result = script.execute((JexlContext)optc, new Object[]{0, "", 42});
        Assertions.assertEquals((Object)42, (Object)result);
        result = script.execute((JexlContext)optc, new Object[]{true, 42, null});
        Assertions.assertEquals((Object)true, (Object)result);
        options.setBooleanLogical(true);
        result = script.execute((JexlContext)optc, new Object[]{0, "", Double.NaN});
        Assertions.assertEquals((Object)false, (Object)result);
        result = script.execute((JexlContext)optc, new Object[]{0, "", Collections.emptySet()});
        Assertions.assertEquals((Object)true, (Object)result);
    }

    @Test
    void testLogicalValue() {
        String src = "function sanitize(const n) { n == 0 ? NaN : n }; sanitize(x) && 420 / x";
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript("function sanitize(const n) { n == 0 ? NaN : n }; sanitize(x) && 420 / x", new String[]{"x"});
        Object result = script.execute(null, new Object[]{10});
        Assertions.assertEquals((Object)42, (Object)result);
        result = script.execute(null, new Object[]{0});
        Assertions.assertTrue((boolean)Double.isNaN(((Number)result).doubleValue()));
    }

    private static /* synthetic */ void lambda$testFailAllOperators$0(JexlScript script, JexlContext jc) throws Throwable {
        script.execute(jc, new Object[]{new Var(42), new Var(43)});
    }

    public static class Var {
        int value;

        Var(int v) {
            this.value = v;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public static class ArithmeticPlus
    extends JexlArithmetic {
        public ArithmeticPlus(boolean strict) {
            super(strict);
        }

        public Var add(Var lhs, Var rhs) {
            return new Var(lhs.value + rhs.value);
        }

        public Var and(Var lhs, Var rhs) {
            return new Var(lhs.value & rhs.value);
        }

        public Var complement(Var arg) {
            return new Var(~arg.value);
        }

        public Boolean contains(Var lhs, Var rhs) {
            return lhs.toString().contains(rhs.toString());
        }

        public Var divide(Var lhs, Var rhs) {
            return new Var(lhs.value / rhs.value);
        }

        public Boolean endsWith(Var lhs, Var rhs) {
            return lhs.toString().endsWith(rhs.toString());
        }

        public boolean equals(Var lhs, Var rhs) {
            return lhs.value == rhs.value;
        }

        public boolean greaterThan(Var lhs, Var rhs) {
            return lhs.value > rhs.value;
        }

        public boolean greaterThanOrEqual(Var lhs, Var rhs) {
            return lhs.value >= rhs.value;
        }

        public boolean lessThan(Var lhs, Var rhs) {
            return lhs.value < rhs.value;
        }

        public boolean lessThanOrEqual(Var lhs, Var rhs) {
            return lhs.value <= rhs.value;
        }

        public Var mod(Var lhs, Var rhs) {
            return new Var(lhs.value / rhs.value);
        }

        public Var multiply(Var lhs, Var rhs) {
            return new Var(lhs.value * rhs.value);
        }

        public Object negate(String str) {
            int length = str.length();
            StringBuilder strb = new StringBuilder(str.length());
            for (int c = length - 1; c >= 0; --c) {
                strb.append(str.charAt(c));
            }
            return strb.toString();
        }

        public Var negate(Var arg) {
            return new Var(-arg.value);
        }

        public Object not(Var x) {
            throw new NullPointerException("make it fail");
        }

        public Var or(Var lhs, Var rhs) {
            return new Var(lhs.value | rhs.value);
        }

        public Var shiftLeft(Var lhs, Var rhs) {
            return new Var(lhs.value << rhs.value);
        }

        public Var shiftRight(Var lhs, Var rhs) {
            return new Var(lhs.value >> rhs.value);
        }

        public Var shiftRightUnsigned(Var lhs, Var rhs) {
            return new Var(lhs.value >>> rhs.value);
        }

        public Boolean startsWith(Var lhs, Var rhs) {
            return lhs.toString().startsWith(rhs.toString());
        }

        public Object subtract(String x, String y) {
            int ix = x.indexOf(y);
            if (ix < 0) {
                return x;
            }
            StringBuilder strb = new StringBuilder(x.substring(0, ix));
            strb.append(x.substring(ix + y.length()));
            return strb.toString();
        }

        public Var subtract(Var lhs, Var rhs) {
            return new Var(lhs.value - rhs.value);
        }

        public Var xor(Var lhs, Var rhs) {
            return new Var(lhs.value ^ rhs.value);
        }
    }

    public static class EmptyTestContext
    extends MapContext
    implements JexlContext.NamespaceResolver {
        public static int log(Object fmt, int ... arr) {
            return arr == null ? 0 : arr.length;
        }

        public static int log(Object fmt, Object ... arr) {
            return arr == null ? 0 : arr.length;
        }

        public Object resolveNamespace(String name) {
            return this;
        }
    }

    public static class ArithmeticFail
    extends JexlArithmetic {
        public ArithmeticFail(boolean strict) {
            super(strict);
        }

        public Object add(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object and(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object complement(Object arg) {
            throw new ArithmeticException(Objects.toString(arg));
        }

        public Boolean contains(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object decrement(Object arg) {
            throw new ArithmeticException(Objects.toString(arg));
        }

        public Object divide(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Boolean endsWith(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public boolean equals(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public boolean greaterThan(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public boolean greaterThanOrEqual(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object increment(Object arg) {
            throw new ArithmeticException(Objects.toString(arg));
        }

        public boolean lessThan(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public boolean lessThanOrEqual(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object mod(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object multiply(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object negate(Object arg) {
            throw new ArithmeticException(Objects.toString(arg));
        }

        public Object not(Object arg) {
            throw new ArithmeticException(Objects.toString(arg));
        }

        public Object or(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object shiftLeft(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object shiftRight(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object shiftRightUnsigned(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Boolean startsWith(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public boolean strictEquals(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public Object subtract(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }

        public boolean toBoolean(Object x) {
            throw new ArithmeticException(Objects.toString(x));
        }

        public Object xor(Object lhs, Object rhs) {
            throw new ArithmeticException(lhs + " o " + rhs);
        }
    }

    public static class Arithmetic132
    extends JexlArithmetic {
        public Arithmetic132() {
            super(false);
        }

        public Object divide(Object left, Object right) {
            if (left == null && right == null) {
                return this.controlNullNullOperands(JexlOperator.DIVIDE);
            }
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = this.toBigDecimal(left);
                BigDecimal r = this.toBigDecimal(right);
                if (BigDecimal.ZERO.equals(r)) {
                    return this.divideZero(l);
                }
                BigDecimal result = l.divide(r, this.getMathContext());
                return this.narrowBigDecimal(left, right, result);
            }
            if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
                double l = this.toDouble(left);
                double r = this.toDouble(right);
                return l / r;
            }
            BigInteger l = this.toBigInteger(left);
            BigInteger r = this.toBigInteger(right);
            if (BigInteger.ZERO.equals(r)) {
                return this.divideZero(l);
            }
            BigInteger result = l.divide(r);
            return this.narrowBigInteger(left, right, result);
        }

        protected double divideZero(BigDecimal x) {
            int ls = x.signum();
            if (ls < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (ls > 0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }

        protected double divideZero(BigInteger x) {
            int ls = x.signum();
            if (ls < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (ls > 0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }

        public Object mod(Object left, Object right) {
            if (left == null && right == null) {
                return this.controlNullNullOperands(JexlOperator.MOD);
            }
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = this.toBigDecimal(left);
                BigDecimal r = this.toBigDecimal(right);
                if (BigDecimal.ZERO.equals(r)) {
                    return this.divideZero(l);
                }
                BigDecimal remainder = l.remainder(r, this.getMathContext());
                return this.narrowBigDecimal(left, right, remainder);
            }
            if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
                double l = this.toDouble(left);
                double r = this.toDouble(right);
                return l % r;
            }
            BigInteger l = this.toBigInteger(left);
            BigInteger r = this.toBigInteger(right);
            BigInteger result = l.mod(r);
            if (BigInteger.ZERO.equals(r)) {
                return this.divideZero(l);
            }
            return this.narrowBigInteger(left, right, result);
        }
    }

    public static class InstanceofContext
    extends MapContext
    implements JexlContext.ClassNameResolver {
        public String resolveClassName(String name) {
            if ("Double".equals(name)) {
                return Double.class.getName();
            }
            return null;
        }
    }

    public static class Callable173 {
        public Object call(Integer ... arg) {
            return arg[0] * arg[1];
        }

        public Object call(String ... arg) {
            return 42;
        }
    }

    public static class XmlArithmetic
    extends JexlArithmetic {
        public XmlArithmetic(boolean astrict) {
            super(astrict);
        }

        public XmlArithmetic(boolean astrict, MathContext bigdContext, int bigdScale) {
            super(astrict, bigdContext, bigdScale);
        }

        public boolean empty(Element elt) {
            return !elt.hasAttributes() && !elt.hasChildNodes();
        }

        public int size(Element elt) {
            return elt.getChildNodes().getLength();
        }
    }

    public static class OptContext
    extends MapContext
    implements JexlContext.OptionsHandle {
        private JexlOptions options;

        public JexlOptions getEngineOptions() {
            return this.options;
        }

        void setOptions(JexlOptions options) {
            this.options = options;
        }
    }
}

