/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.annotations.NoJexl;
import org.apache.commons.jexl3.internal.introspection.ArrayIterator;
import org.apache.commons.jexl3.internal.introspection.ArrayListWrapper;
import org.apache.commons.jexl3.internal.introspection.Permissions;
import org.junit.Assert;
import org.junit.Test;

public class MiscIntrospectionTest {
    @Test
    public void testEmptyContext() {
        try {
            JexlEngine.EMPTY_CONTEXT.set("nope", (Object)42);
            Assert.fail((String)"empty context should be readonly");
        }
        catch (UnsupportedOperationException xun) {
            Assert.assertNotNull((Object)xun);
        }
    }

    @Test
    public void testArrayIterator() {
        try {
            new ArrayIterator(new ArrayList());
        }
        catch (IllegalArgumentException xill) {
            Assert.assertNotNull((Object)xill);
        }
        ArrayIterator ai0 = new ArrayIterator(null);
        Assert.assertFalse((boolean)ai0.hasNext());
        try {
            ai0.next();
            Assert.fail((String)"should have failed");
        }
        catch (NoSuchElementException no) {
            Assert.assertNotNull((Object)no);
        }
        ai0 = new ArrayIterator((Object)new int[]{42});
        Assert.assertTrue((boolean)ai0.hasNext());
        Assert.assertEquals((Object)42, (Object)ai0.next());
        Assert.assertFalse((boolean)ai0.hasNext());
        try {
            ai0.next();
            Assert.fail((String)"iterator on null?");
        }
        catch (NoSuchElementException no) {
            Assert.assertNotNull((Object)no);
        }
        try {
            ai0.remove();
            Assert.fail((String)"should have failed");
        }
        catch (UnsupportedOperationException no) {
            Assert.assertNotNull((Object)no);
        }
    }

    @Test
    public void testArrayListWrapper() {
        try {
            new ArrayListWrapper((Object)1);
            Assert.fail((String)"non-array wrap?");
        }
        catch (IllegalArgumentException xil) {
            Assert.assertNotNull((Object)xil);
        }
        Integer[] ai = new Integer[]{1, 2};
        ArrayListWrapper alw = new ArrayListWrapper((Object)ai);
        Assert.assertEquals((long)1L, (long)alw.indexOf((Object)2));
        Assert.assertEquals((long)-1L, (long)alw.indexOf(null));
    }

    @Test
    public void testPermissions() throws Exception {
        Permissions p = Permissions.DEFAULT;
        Assert.assertFalse((boolean)p.allow((Field)null));
        Assert.assertFalse((boolean)p.allow((Package)null));
        Assert.assertFalse((boolean)p.allow((Method)null));
        Assert.assertFalse((boolean)p.allow((Constructor)null));
        Assert.assertFalse((boolean)p.allow((Class)null));
        Assert.assertTrue((boolean)p.allow(A2.class));
        Assert.assertFalse((boolean)p.allow(A3.class));
        Assert.assertFalse((boolean)p.allow(A5.class));
        Method mA = A.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA);
        Method mA0 = A0.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA0);
        Method mA1 = A1.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA1);
        Method mA2 = A2.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA1);
        Method mA3 = A2.class.getDeclaredMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA1);
        Assert.assertTrue((boolean)p.allow(mA));
        Assert.assertFalse((boolean)p.allow(mA0));
        Assert.assertFalse((boolean)p.allow(mA1));
        Assert.assertFalse((boolean)p.allow(mA2));
        Assert.assertFalse((boolean)p.allow(mA3));
        Field fA = A.class.getField("i");
        Assert.assertNotNull((Object)fA);
        Assert.assertTrue((boolean)p.allow(fA));
        Field fA0 = A0.class.getField("i0");
        Assert.assertNotNull((Object)fA0);
        Assert.assertFalse((boolean)p.allow(fA0));
        Field fA1 = A1.class.getDeclaredField("i1");
        Assert.assertNotNull((Object)fA1);
        Assert.assertFalse((boolean)p.allow(fA0));
        Constructor cA = A.class.getConstructor(new Class[0]);
        Assert.assertNotNull(cA);
        Assert.assertTrue((boolean)p.allow(cA));
        Constructor cA0 = A0.class.getConstructor(new Class[0]);
        Assert.assertNotNull(cA0);
        Assert.assertFalse((boolean)p.allow(cA0));
        Constructor cA3 = A3.class.getDeclaredConstructor(new Class[0]);
        Assert.assertNotNull(cA3);
        Assert.assertFalse((boolean)p.allow(cA3));
    }

    @NoJexl
    public static interface InterNoJexl5 {
        public int method();
    }

    public static class A5
    implements InterNoJexl5 {
        @Override
        public int method() {
            return 0;
        }
    }

    protected static class A3 {
        protected int i3;

        protected A3() {
        }

        int method() {
            return 4;
        }
    }

    @NoJexl
    public static class A2
    extends A {
        @Override
        public int method() {
            return 3;
        }
    }

    public static class A1
    extends A
    implements InterNoJexl1 {
        private int i1;

        @NoJexl
        public A1() {
        }

        @Override
        public int method() {
            return 2;
        }
    }

    public static class A0
    extends A
    implements InterNoJexl0 {
        @NoJexl
        public int i0;

        @NoJexl
        public A0() {
        }

        @Override
        public int method() {
            return 1;
        }
    }

    public static interface InterNoJexl1 {
        @NoJexl
        public int method();
    }

    @NoJexl
    public static interface InterNoJexl0 {
        public int method();
    }

    public static class A {
        public int i;

        public int method() {
            return 0;
        }
    }
}

