/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3;

import java.util.Hashtable;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class JCSvsHashtablePerformanceTest
extends TestCase {
    float ratioPut;
    float ratioGet;
    float target = 3.5f;
    int loops = 20;
    int tries = 50000;

    public void testSimpleLoad() throws Exception {
        Log log1 = LogManager.getLog(LRUMemoryCache.class);
        if (log1.isDebugEnabled()) {
            System.out.println("The log level must be at info or above for the a performance test.");
            return;
        }
        Log log2 = LogManager.getLog(JCS.class);
        if (log2.isDebugEnabled()) {
            System.out.println("The log level must be at info or above for the a performance test.");
            return;
        }
        this.doWork();
        JCSvsHashtablePerformanceTest.assertTrue((this.ratioPut < this.target ? 1 : 0) != 0);
        JCSvsHashtablePerformanceTest.assertTrue((this.ratioGet < this.target ? 1 : 0) != 0);
    }

    public void doWork() {
        long start = 0L;
        long end = 0L;
        long time = 0L;
        float tPer = 0.0f;
        long putTotalJCS = 0L;
        long getTotalJCS = 0L;
        long putTotalHashtable = 0L;
        long getTotalHashtable = 0L;
        try {
            JCS.setConfigFilename((String)"/TestJCSvHashtablePerf.ccf");
            CacheAccess cache = JCS.getInstance((String)"testCache1");
            for (int j = 0; j < this.loops; ++j) {
                int i;
                int i2;
                String name = "JCS      ";
                start = System.currentTimeMillis();
                for (i2 = 0; i2 < this.tries; ++i2) {
                    cache.put((Object)("key:" + i2), (Object)("data" + i2));
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalJCS += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(name + " put time for " + this.tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i2 = 0; i2 < this.tries; ++i2) {
                    cache.get((Object)("key:" + i2));
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalJCS += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(name + " get time for " + this.tries + " = " + time + "; millis per = " + tPer);
                name = "Hashtable";
                Hashtable<String, String> cache2 = new Hashtable<String, String>();
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    cache2.put("key:" + i, "data" + i);
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalHashtable += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(name + " put time for " + this.tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    cache2.get("key:" + i);
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalHashtable += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(name + " get time for " + this.tries + " = " + time + "; millis per = " + tPer);
                System.out.println("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println(e);
        }
        long putAvJCS = putTotalJCS / (long)this.loops;
        long getAvJCS = getTotalJCS / (long)this.loops;
        long putAvHashtable = putTotalHashtable / (long)this.loops;
        long getAvHashtable = getTotalHashtable / (long)this.loops;
        System.out.println("Finished " + this.loops + " loops of " + this.tries + " gets and puts");
        System.out.println("\n");
        System.out.println("Put average for JCS       = " + putAvJCS);
        System.out.println("Put average for Hashtable = " + putAvHashtable);
        this.ratioPut = Float.intBitsToFloat((int)putAvJCS) / Float.intBitsToFloat((int)putAvHashtable);
        System.out.println("JCS puts took " + this.ratioPut + " times the Hashtable, the goal is <" + this.target + "x");
        System.out.println("\n");
        System.out.println("Get average for JCS       = " + getAvJCS);
        System.out.println("Get average for Hashtable = " + getAvHashtable);
        this.ratioGet = Float.intBitsToFloat((int)getAvJCS) / Float.intBitsToFloat((int)getAvHashtable);
        System.out.println("JCS gets took " + this.ratioGet + " times the Hashtable, the goal is <" + this.target + "x");
    }
}

