/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.junit.Assert;
import org.junit.Test;

public class ExpiryListenerTest {
    @Test
    public void listener() throws InterruptedException {
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = cachingProvider.getCacheManager();
        CacheEntryExpiredListenerImpl listener = new CacheEntryExpiredListenerImpl();
        cacheManager.createCache("default", (Configuration)new MutableConfiguration().setExpiryPolicyFactory((Factory)new FactoryBuilder.SingletonFactory((Object)new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 1L)))).addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf((Serializable)listener), null, false, false)));
        Cache cache = cacheManager.getCache("default");
        Assert.assertFalse((boolean)cache.containsKey((Object)"foo"));
        cache.put((Object)"foo", (Object)"bar");
        Thread.sleep(10L);
        Assert.assertFalse((boolean)cache.containsKey((Object)"foo"));
        cachingProvider.close();
        Assert.assertEquals((long)1L, (long)listener.events.size());
    }

    private static class CacheEntryExpiredListenerImpl
    implements CacheEntryExpiredListener<String, String>,
    Serializable {
        private static final long serialVersionUID = -5070377769541346377L;
        private final Collection<CacheEntryEvent<? extends String, ? extends String>> events = new ArrayList<CacheEntryEvent<? extends String, ? extends String>>();

        private CacheEntryExpiredListenerImpl() {
        }

        public void onExpired(Iterable<CacheEntryEvent<? extends String, ? extends String>> cacheEntryEvents) throws CacheEntryListenerException {
            for (CacheEntryEvent<? extends String, ? extends String> cacheEntryEvent : cacheEntryEvents) {
                this.events.add(cacheEntryEvent);
            }
        }
    }
}

