/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.memory;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.memory.behavior.IMemoryCache;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;

public class MockMemoryCache<K, V>
implements IMemoryCache<K, V> {
    private ICompositeCacheAttributes cacheAttr;
    private final HashMap<K, ICacheElement<K, V>> map = new HashMap();
    public int waterfallCallCount;
    public int lastNumberOfFreedElements;

    public void initialize(CompositeCache<K, V> cache) {
    }

    public void dispose() throws IOException {
    }

    public int getSize() {
        return this.map.size();
    }

    public IStats getStatistics() {
        return null;
    }

    public Set<K> getKeySet() {
        return new LinkedHashSet<K>(this.map.keySet());
    }

    public boolean remove(K key) throws IOException {
        return this.map.remove(key) != null;
    }

    public void removeAll() throws IOException {
        this.map.clear();
    }

    public ICacheElement<K, V> get(K key) throws IOException {
        return this.map.get(key);
    }

    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) throws IOException {
        HashMap<K, ICacheElement<K, V>> elements = new HashMap<K, ICacheElement<K, V>>();
        if (keys != null && !keys.isEmpty()) {
            for (K key : keys) {
                ICacheElement<K, V> element = this.get(key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    public ICacheElement<K, V> getQuiet(K key) throws IOException {
        return this.map.get(key);
    }

    public void waterfal(ICacheElement<K, V> ce) throws IOException {
        ++this.waterfallCallCount;
    }

    public void update(ICacheElement<K, V> ce) throws IOException {
        if (ce != null) {
            this.map.put(ce.getKey(), ce);
        }
    }

    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cacheAttr;
    }

    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.cacheAttr = cattr;
    }

    public CompositeCache<K, V> getCompositeCache() {
        return null;
    }

    public Set<K> getGroupKeys(String group) {
        return null;
    }

    public Set<String> getGroupNames() {
        return null;
    }

    public int freeElements(int numberToFree) throws IOException {
        this.lastNumberOfFreedElements = numberToFree;
        return 0;
    }
}

