/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.io.Serializable;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPService;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class LateralTCPFilterRemoveHashCodeUnitTest
extends TestCase {
    private static final boolean isSysOut = false;
    private final int serverPort = 2001;

    public LateralTCPFilterRemoveHashCodeUnitTest(String testName) {
        super(testName);
    }

    public void setUp() {
        System.setProperty("jcs.auxiliary.LTCP.attributes.TcpServers", "localhost:2001");
        JCS.setConfigFilename((String)"/TestTCPLateralRemoveFilter.ccf");
    }

    public void test() throws Exception {
        this.runTestForRegion("region1", 200, 1);
    }

    public void runTestForRegion(String region, int numOps, int testNum) throws Exception {
        CacheAccess cache = JCS.getInstance((String)region);
        Thread.sleep(100L);
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(1102);
        lattr2.setTransmissionType(ILateralCacheAttributes.Type.TCP);
        lattr2.setTcpServer("localhost:2001");
        lattr2.setIssueRemoveOnPut(true);
        lattr2.setAllowPut(false);
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2, (IElementSerializer)new StandardSerializer());
        service.setListenerId(123456L);
        String keyToBeRemovedOnPut = "test1";
        String keyToNotBeRemovedOnPut = "test2";
        Serializable dataToPassHashCodeCompare = new Serializable(){
            private static final long serialVersionUID = 1L;

            public int hashCode() {
                return 1;
            }
        };
        cache.put((Object)"test1", (Object)"this should get removed.");
        CacheElement element1 = new CacheElement(region, (Object)"test1", (Object)(region + ":data-this shouldn't get there"));
        service.update((ICacheElement)element1);
        cache.put((Object)"test2", (Object)dataToPassHashCodeCompare);
        CacheElement element2 = new CacheElement(region, (Object)"test2", (Object)dataToPassHashCodeCompare);
        service.update((ICacheElement)element2);
        CacheAccess jcs = JCS.getInstance((String)region);
        String key = "testKey" + testNum;
        String data = "testData" + testNum;
        jcs.put((Object)key, (Object)data);
        String value = (String)jcs.get((Object)key);
        LateralTCPFilterRemoveHashCodeUnitTest.assertEquals((String)"Couldn't put normally.", (String)data, (String)value);
        for (int i = 1; i < numOps; ++i) {
            String keyL = "key" + i;
            String dataL = (String)jcs.get((Object)keyL);
            if (dataL == null) continue;
            LateralTCPFilterRemoveHashCodeUnitTest.assertTrue((String)"Incorrect region detected.", (boolean)dataL.startsWith(region));
        }
        Thread.sleep(200L);
        Object testObj1 = cache.get((Object)"test1");
        LateralTCPFilterRemoveHashCodeUnitTest.p("test object1 = " + testObj1);
        LateralTCPFilterRemoveHashCodeUnitTest.assertNull((String)"The test object should have been remvoed by a put.", (Object)testObj1);
        Object testObj2 = cache.get((Object)"test2");
        LateralTCPFilterRemoveHashCodeUnitTest.p("test object2 = " + testObj2 + " hashCode = ");
        if (testObj2 != null) {
            LateralTCPFilterRemoveHashCodeUnitTest.p("test2 hashCode = " + testObj2.hashCode());
        }
        LateralTCPFilterRemoveHashCodeUnitTest.assertNotNull((String)"This should not have been removed, since the hascode were the same.", (Object)testObj2);
    }

    public static void p(String s) {
    }
}

