/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.core.input;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.geometry.io.core.AbstractGeometryIOMetadata;
import org.apache.commons.geometry.io.core.input.GeometryInput;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;

public class FileGeometryInput
extends AbstractGeometryIOMetadata
implements GeometryInput {
    private final Path file;

    public FileGeometryInput(Path file) {
        this(file, null);
    }

    public FileGeometryInput(Path file, Charset charset) {
        super(GeometryIOUtils.getFileName(file), charset);
        this.file = file;
    }

    public Path getFile() {
        return this.file;
    }

    @Override
    public InputStream getInputStream() {
        return GeometryIOUtils.getUnchecked(() -> new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0])));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[file= ").append(this.getFile()).append(']');
        return sb.toString();
    }
}

