/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.Util;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FileUploadTest {
    @Parameterized.Parameter
    public FileUpload upload;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<? extends Object> data() {
        return Util.fileUploadImplementations();
    }

    private void assertHeaders(String[] headerNames, String[] headerValues, FileItem item, int index) {
        for (int i = 0; i < headerNames.length; ++i) {
            String value = item.getHeaders().getHeader(headerNames[i]);
            if (i == index) {
                Assert.assertEquals((Object)headerValues[i], (Object)value);
                continue;
            }
            Assert.assertNull((Object)value);
        }
    }

    @Test
    public void testContentTypeAttachment() throws IOException, FileUploadException {
        List<FileItem> fileItems = Util.parseUpload(this.upload, "-----1234\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n-----1234\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed, boundary=---9876\r\n\r\n-----9876\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n-----9876--\r\n-----1234--\r\n");
        Assert.assertEquals((long)2L, (long)fileItems.size());
        FileItem field = fileItems.get(0);
        Assert.assertEquals((Object)"field1", (Object)field.getFieldName());
        Assert.assertTrue((boolean)field.isFormField());
        Assert.assertEquals((Object)"Joe Blow", (Object)field.getString());
        FileItem file = fileItems.get(1);
        Assert.assertEquals((Object)"pics", (Object)file.getFieldName());
        Assert.assertFalse((boolean)file.isFormField());
        Assert.assertEquals((Object)"... contents of file1.txt ...", (Object)file.getString());
        Assert.assertEquals((Object)"text/plain", (Object)file.getContentType());
        Assert.assertEquals((Object)"file1.txt", (Object)file.getName());
    }

    @Test
    public void testEmptyFile() throws UnsupportedEncodingException, FileUploadException {
        List<FileItem> fileItems = Util.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"\"\r\n\r\n\r\n-----1234--\r\n");
        Assert.assertEquals((long)1L, (long)fileItems.size());
        FileItem file = fileItems.get(0);
        Assert.assertFalse((boolean)file.isFormField());
        Assert.assertEquals((Object)"", (Object)file.getString());
        Assert.assertEquals((Object)"", (Object)file.getName());
    }

    @Test
    public void testFilenameCaseSensitivity() throws IOException, FileUploadException {
        List<FileItem> fileItems = Util.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"FiLe\"; filename=\"FOO.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n");
        Assert.assertEquals((long)1L, (long)fileItems.size());
        FileItem file = fileItems.get(0);
        Assert.assertEquals((Object)"FiLe", (Object)file.getFieldName());
        Assert.assertEquals((Object)"FOO.tab", (Object)file.getName());
    }

    @Test
    public void testFileUpload() throws IOException, FileUploadException {
        List<FileItem> fileItems = Util.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assert.assertEquals((long)4L, (long)fileItems.size());
        FileItem file = fileItems.get(0);
        Assert.assertEquals((Object)"file", (Object)file.getFieldName());
        Assert.assertFalse((boolean)file.isFormField());
        Assert.assertEquals((Object)"This is the content of the file\n", (Object)file.getString());
        Assert.assertEquals((Object)"text/whatever", (Object)file.getContentType());
        Assert.assertEquals((Object)"foo.tab", (Object)file.getName());
        FileItem field = fileItems.get(1);
        Assert.assertEquals((Object)"field", (Object)field.getFieldName());
        Assert.assertTrue((boolean)field.isFormField());
        Assert.assertEquals((Object)"fieldValue", (Object)field.getString());
        FileItem multi0 = fileItems.get(2);
        Assert.assertEquals((Object)"multi", (Object)multi0.getFieldName());
        Assert.assertTrue((boolean)multi0.isFormField());
        Assert.assertEquals((Object)"value1", (Object)multi0.getString());
        FileItem multi1 = fileItems.get(3);
        Assert.assertEquals((Object)"multi", (Object)multi1.getFieldName());
        Assert.assertTrue((boolean)multi1.isFormField());
        Assert.assertEquals((Object)"value2", (Object)multi1.getString());
    }

    @Test
    public void testFileUpload130() throws Exception {
        String[] headerNames = new String[]{"SomeHeader", "OtherHeader", "YetAnotherHeader", "WhatAHeader"};
        String[] headerValues = new String[]{"present", "Is there", "Here", "Is That"};
        List<FileItem> fileItems = Util.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n" + headerNames[0] + ": " + headerValues[0] + "\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; \r\n\tname=\"field\"\r\n" + headerNames[1] + ": " + headerValues[1] + "\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data;\r\n     name=\"multi\"\r\n" + headerNames[2] + ": " + headerValues[2] + "\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n" + headerNames[3] + ": " + headerValues[3] + "\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assert.assertEquals((long)4L, (long)fileItems.size());
        FileItem file = fileItems.get(0);
        this.assertHeaders(headerNames, headerValues, file, 0);
        FileItem field = fileItems.get(1);
        this.assertHeaders(headerNames, headerValues, field, 1);
        FileItem multi0 = fileItems.get(2);
        this.assertHeaders(headerNames, headerValues, multi0, 2);
        FileItem multi1 = fileItems.get(3);
        this.assertHeaders(headerNames, headerValues, multi1, 3);
    }

    @Test
    public void testFILEUPLOAD62() throws Exception {
        String contentType = "multipart/form-data; boundary=AaB03x";
        String request = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed; boundary=BbC04y\r\n\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file2.gif\"\r\nContent-type: image/gif\r\nContent-Transfer-Encoding: binary\r\n\r\n...contents of file2.gif...\r\n--BbC04y--\r\n--AaB03x--";
        List<FileItem> fileItems = Util.parseUpload(this.upload, "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed; boundary=BbC04y\r\n\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file2.gif\"\r\nContent-type: image/gif\r\nContent-Transfer-Encoding: binary\r\n\r\n...contents of file2.gif...\r\n--BbC04y--\r\n--AaB03x--".getBytes("US-ASCII"), "multipart/form-data; boundary=AaB03x");
        Assert.assertEquals((long)3L, (long)fileItems.size());
        FileItem item0 = fileItems.get(0);
        Assert.assertEquals((Object)"field1", (Object)item0.getFieldName());
        Assert.assertNull((Object)item0.getName());
        Assert.assertEquals((Object)"Joe Blow", (Object)new String(item0.get()));
        FileItem item1 = fileItems.get(1);
        Assert.assertEquals((Object)"pics", (Object)item1.getFieldName());
        Assert.assertEquals((Object)"file1.txt", (Object)item1.getName());
        Assert.assertEquals((Object)"... contents of file1.txt ...", (Object)new String(item1.get()));
        FileItem item2 = fileItems.get(2);
        Assert.assertEquals((Object)"pics", (Object)item2.getFieldName());
        Assert.assertEquals((Object)"file2.gif", (Object)item2.getName());
        Assert.assertEquals((Object)"...contents of file2.gif...", (Object)new String(item2.get()));
    }

    @Test
    public void testFoldedHeaders() throws IOException, FileUploadException {
        List<FileItem> fileItems = Util.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; \r\n\tname=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data;\r\n     name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assert.assertEquals((long)4L, (long)fileItems.size());
        FileItem file = fileItems.get(0);
        Assert.assertEquals((Object)"file", (Object)file.getFieldName());
        Assert.assertFalse((boolean)file.isFormField());
        Assert.assertEquals((Object)"This is the content of the file\n", (Object)file.getString());
        Assert.assertEquals((Object)"text/whatever", (Object)file.getContentType());
        Assert.assertEquals((Object)"foo.tab", (Object)file.getName());
        FileItem field = fileItems.get(1);
        Assert.assertEquals((Object)"field", (Object)field.getFieldName());
        Assert.assertTrue((boolean)field.isFormField());
        Assert.assertEquals((Object)"fieldValue", (Object)field.getString());
        FileItem multi0 = fileItems.get(2);
        Assert.assertEquals((Object)"multi", (Object)multi0.getFieldName());
        Assert.assertTrue((boolean)multi0.isFormField());
        Assert.assertEquals((Object)"value1", (Object)multi0.getString());
        FileItem multi1 = fileItems.get(3);
        Assert.assertEquals((Object)"multi", (Object)multi1.getFieldName());
        Assert.assertTrue((boolean)multi1.isFormField());
        Assert.assertEquals((Object)"value2", (Object)multi1.getString());
    }

    @Test
    public void testIE5MacBug() throws UnsupportedEncodingException, FileUploadException {
        List<FileItem> fileItems = Util.parseUpload(this.upload, "-----1234\r\nContent-Disposition: form-data; name=\"field1\"\r\n\r\nfieldValue\r\n-----1234\nContent-Disposition: form-data; name=\"submitName.x\"\r\n\r\n42\r\n-----1234\nContent-Disposition: form-data; name=\"submitName.y\"\r\n\r\n21\r\n-----1234\r\nContent-Disposition: form-data; name=\"field2\"\r\n\r\nfieldValue2\r\n-----1234--\r\n");
        Assert.assertEquals((long)4L, (long)fileItems.size());
        FileItem field1 = fileItems.get(0);
        Assert.assertEquals((Object)"field1", (Object)field1.getFieldName());
        Assert.assertTrue((boolean)field1.isFormField());
        Assert.assertEquals((Object)"fieldValue", (Object)field1.getString());
        FileItem submitX = fileItems.get(1);
        Assert.assertEquals((Object)"submitName.x", (Object)submitX.getFieldName());
        Assert.assertTrue((boolean)submitX.isFormField());
        Assert.assertEquals((Object)"42", (Object)submitX.getString());
        FileItem submitY = fileItems.get(2);
        Assert.assertEquals((Object)"submitName.y", (Object)submitY.getFieldName());
        Assert.assertTrue((boolean)submitY.isFormField());
        Assert.assertEquals((Object)"21", (Object)submitY.getString());
        FileItem field2 = fileItems.get(3);
        Assert.assertEquals((Object)"field2", (Object)field2.getFieldName());
        Assert.assertTrue((boolean)field2.isFormField());
        Assert.assertEquals((Object)"fieldValue2", (Object)field2.getString());
    }

    @Test
    public void testMultipartRelated() throws FileUploadException {
        String soapEnvelope = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">\r\n  <soap:Header></soap:Header>\r\n  <soap:Body>\r\n    <ns1:Test xmlns:ns1=\"http://www.test.org/some-test-namespace\">\r\n      <ns1:Attachment>\r\n        <xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"ref-to-attachment%40some.domain.org\"/>\r\n      </ns1:Attachment>\r\n    </ns1:Test>\r\n  </soap:Body>\r\n</soap:Envelope>";
        String content = "-----1234\r\ncontent-type: application/xop+xml; type=\"application/soap+xml\"\r\n\r\n<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">\r\n  <soap:Header></soap:Header>\r\n  <soap:Body>\r\n    <ns1:Test xmlns:ns1=\"http://www.test.org/some-test-namespace\">\r\n      <ns1:Attachment>\r\n        <xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"ref-to-attachment%40some.domain.org\"/>\r\n      </ns1:Attachment>\r\n    </ns1:Test>\r\n  </soap:Body>\r\n</soap:Envelope>\r\n-----1234\r\nContent-type: text/plain\r\ncontent-id: <ref-to-attachment@some.domain.org>\r\n\r\nsome text/plain content\r\n-----1234--\r\n";
        List<FileItem> fileItems = Util.parseUpload(this.upload, "-----1234\r\ncontent-type: application/xop+xml; type=\"application/soap+xml\"\r\n\r\n<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">\r\n  <soap:Header></soap:Header>\r\n  <soap:Body>\r\n    <ns1:Test xmlns:ns1=\"http://www.test.org/some-test-namespace\">\r\n      <ns1:Attachment>\r\n        <xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"ref-to-attachment%40some.domain.org\"/>\r\n      </ns1:Attachment>\r\n    </ns1:Test>\r\n  </soap:Body>\r\n</soap:Envelope>\r\n-----1234\r\nContent-type: text/plain\r\ncontent-id: <ref-to-attachment@some.domain.org>\r\n\r\nsome text/plain content\r\n-----1234--\r\n".getBytes(StandardCharsets.US_ASCII), "multipart/related; boundary=---1234; type=\"application/xop+xml\"; start-info=\"application/soap+xml\"");
        Assert.assertEquals((long)2L, (long)fileItems.size());
        FileItem part1 = fileItems.get(0);
        Assert.assertNull((Object)part1.getFieldName());
        Assert.assertFalse((boolean)part1.isFormField());
        Assert.assertEquals((Object)"<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">\r\n  <soap:Header></soap:Header>\r\n  <soap:Body>\r\n    <ns1:Test xmlns:ns1=\"http://www.test.org/some-test-namespace\">\r\n      <ns1:Attachment>\r\n        <xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"ref-to-attachment%40some.domain.org\"/>\r\n      </ns1:Attachment>\r\n    </ns1:Test>\r\n  </soap:Body>\r\n</soap:Envelope>", (Object)part1.getString());
        FileItem part2 = fileItems.get(1);
        Assert.assertNull((Object)part2.getFieldName());
        Assert.assertFalse((boolean)part2.isFormField());
        Assert.assertEquals((Object)"some text/plain content", (Object)part2.getString());
        Assert.assertEquals((Object)"text/plain", (Object)part2.getContentType());
        Assert.assertNull((Object)part2.getName());
    }

    @Test
    public void testOpenStreamSecondCall() throws IOException, FileUploadException {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n";
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(-1L);
        upload.setSizeMax(300L);
        MockHttpServletRequest req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        req.setContentLength(-1L);
        req.setReadLimit(10);
        FileItemIterator it = upload.getItemIterator((HttpServletRequest)req);
        Assert.assertTrue((boolean)it.hasNext());
        FileItemStream item = it.next();
        Assert.assertFalse((boolean)item.isFormField());
        Assert.assertEquals((Object)"file1", (Object)item.getFieldName());
        Assert.assertEquals((Object)"foo1.tab", (Object)item.getName());
        try (InputStream stream = item.openStream();){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Streams.copy((InputStream)stream, (OutputStream)baos, (boolean)true);
        }
        Assertions.assertThrows(IOException.class, () -> ((FileItemStream)item).openStream(), (String)"Attempt to open a closed stream did not throw an exception");
        Assert.assertFalse((boolean)it.hasNext());
    }
}

