/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JToolTip;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ListUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.Control;
import org.scopemvc.core.Controller;
import org.scopemvc.core.Selector;
import org.scopemvc.core.View;
import org.scopemvc.view.swing.ListSelectionParent;
import org.scopemvc.view.swing.Refreshable;
import org.scopemvc.view.swing.SListCellRenderer;
import org.scopemvc.view.swing.SListModel;
import org.scopemvc.view.swing.SListSelectionModel;
import org.scopemvc.view.swing.SwingUtil;
import org.scopemvc.view.swing.ValidationHelper;

public class SList
extends JList
implements View,
Refreshable,
ListSelectionParent {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SList == null ? (class$org$scopemvc$view$swing$SList = SList.class$("org.scopemvc.view.swing.SList")) : class$org$scopemvc$view$swing$SList);
    private String selectionControlID;
    private String doubleClickControlID;
    private ValidationHelper validationHelper = new ValidationHelper(this);
    private boolean readOnly = false;
    private boolean userEnabled = true;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SList;

    public SList() {
        this.setCellRenderer((ListCellRenderer)new SListCellRenderer());
        this.setModel((ListModel)new SListModel(this));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && SList.this.doubleClickControlID != null) {
                    Control control = new Control(SList.this.doubleClickControlID);
                    SList.this.issueControl(control);
                }
            }
        });
        this.setSelectionModel(this.createSelectionModel());
        this.setSelectionMode(0);
        this.updateUI();
    }

    public final Object getBoundModel() {
        return ((SListModel)this.getModel()).getBoundModel();
    }

    public final Selector getSelector() {
        return ((SListModel)this.getModel()).getSelector();
    }

    public final Selector getSelectionSelector() {
        return ((SListSelectionModel)this.getSelectionModel()).getSelector();
    }

    public final Selector getRendererSelector() {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getCellRenderer();
        return sListCellRenderer.getTextSelector();
    }

    public final Selector getRendererIconSelector() {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getCellRenderer();
        return sListCellRenderer.getIconSelector();
    }

    public final Selector getSizeSelector() {
        return ((SListModel)this.getModel()).getSizeSelector();
    }

    public final String getChangeSelectionControlID() {
        return this.selectionControlID;
    }

    public final String getDoubleClickControlID() {
        return this.doubleClickControlID;
    }

    public Controller getController() {
        return null;
    }

    public void issueChangeSelectionControl() {
        if (this.selectionControlID != null) {
            Control control = new Control(this.selectionControlID);
            this.issueControl(control);
        }
    }

    public void issueControl(Control control) {
        SwingUtil.issueControl(this, control);
    }

    public final void setBoundModel(Object object) {
        ((SListModel)this.getModel()).setBoundModel(object);
        ((SListSelectionModel)this.getSelectionModel()).setBoundModel(object);
    }

    public final void setSelector(Selector selector) {
        ((SListModel)this.getModel()).setSelector(selector);
    }

    public final void setSelector(String string) {
        ((SListModel)this.getModel()).setSelector(string);
    }

    public final void setSelectorString(String string) {
        this.setSelector(string);
    }

    public final void setSelectionSelector(Selector selector) {
        ((SListSelectionModel)this.getSelectionModel()).setSelector(selector);
    }

    public final void setSelectionSelector(String string) {
        ((SListSelectionModel)this.getSelectionModel()).setSelector(string);
    }

    public final void setSelectionSelectorString(String string) {
        this.setSelectionSelector(string);
    }

    public final void setSizeSelector(Selector selector) {
        ((SListModel)this.getModel()).setSizeSelector(selector);
    }

    public final void setSizeSelector(String string) {
        ((SListModel)this.getModel()).setSizeSelector(string);
    }

    public final void setSizeSelectorString(String string) {
        this.setSizeSelector(string);
    }

    public final void setRendererSelector(Selector selector) {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getCellRenderer();
        sListCellRenderer.setTextSelector(selector);
    }

    public final void setRendererSelector(String string) {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getCellRenderer();
        sListCellRenderer.setTextSelector(string);
    }

    public final void setRendererSelectorString(String string) {
        this.setRendererSelector(string);
    }

    public final void setRendererIconSelector(Selector selector) {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getCellRenderer();
        sListCellRenderer.setIconSelector(selector);
    }

    public final void setRendererIconSelector(String string) {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getCellRenderer();
        sListCellRenderer.setIconSelector(string);
    }

    public final void setRendererIconSelectorString(String string) {
        this.setRendererIconSelector(string);
    }

    public final void setChangeSelectionControlID(String string) {
        this.selectionControlID = string;
    }

    public final void setDoubleClickControlID(String string) {
        this.doubleClickControlID = string;
    }

    public void setEnabled(boolean bl) {
        this.userEnabled = bl;
        super.setEnabled(this.userEnabled && !this.readOnly);
    }

    public void setUI(ListUI listUI) {
        if (this.getCellRenderer() == null) {
            this.setCellRenderer((ListCellRenderer)new SListCellRenderer());
        }
        super.setUI(listUI);
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        if (!(listCellRenderer instanceof SListCellRenderer)) {
            throw new IllegalArgumentException("Renderer must be an instance of SListCellRenderer");
        }
        super.setCellRenderer(listCellRenderer);
    }

    public void setModel(ListModel listModel) {
        if (!(listModel instanceof SListModel)) {
            throw new IllegalArgumentException("Model must be a SListModel");
        }
        super.setModel(listModel);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (!(listSelectionModel instanceof SListSelectionModel)) {
            throw new IllegalArgumentException("Model must be a SListSelectionModel");
        }
        super.setSelectionModel(listSelectionModel);
    }

    public void setListModel(Object object) {
        ((SListModel)this.getModel()).setListModel(object);
    }

    public void setController(Controller controller) {
        throw new UnsupportedOperationException("Can't assign a Controller to a " + this.getClass());
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        super.setEnabled(this.userEnabled && !this.readOnly);
    }

    public int findIndexFor(Object object) {
        if (object == null) {
            return -1;
        }
        int n = this.getModel().getSize() - 1;
        while (n >= 0) {
            if (object.equals(this.getModel().getElementAt(n))) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public Object findElementAt(int n) {
        if (n < 0) {
            return null;
        }
        try {
            return this.getModel().getElementAt(n);
        }
        catch (Exception exception) {
            LOG.warn("Can't findElementAt: " + n, exception);
            return null;
        }
    }

    public void refresh() {
        ((SListModel)this.getModel()).refresh();
        this.refreshSelection();
    }

    public void refreshSelection() {
        ((SListSelectionModel)this.getSelectionModel()).refresh();
    }

    public void validationFailed(Exception exception) {
        this.validationHelper.validationFailed(exception);
    }

    public void validationSuccess() {
        this.validationHelper.validationSuccess();
    }

    public JToolTip createToolTip() {
        return this.validationHelper.createToolTip(super.createToolTip());
    }

    protected ListSelectionModel createSelectionModel() {
        return new SListSelectionModel(this, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

