/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.value;

import java.io.Serializable;
import java.util.Objects;
import org.apache.cayenne.value.json.JsonUtils;
import org.apache.cayenne.value.json.MalformedJsonException;

public class Json
implements Serializable {
    private static final long serialVersionUID = 7594825997288498022L;
    private final String json;

    public Json(String json) {
        if (json.isBlank()) {
            throw new MalformedJsonException("Unexpected EOF");
        }
        this.json = json;
    }

    public String getRawJson() {
        return this.json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Json other = (Json)o;
        return JsonUtils.compare(this.json, other.json);
    }

    public int hashCode() {
        return Objects.hash(this.json);
    }

    public String toString() {
        return "JSON value: " + this.json;
    }
}

