/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.ValueInjector;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class DataContextObjectCreator {
    final DataContext context;

    DataContextObjectCreator(DataContext context) {
        this.context = context;
    }

    <T> T newObject(Class<T> persistentClass) {
        if (persistentClass == null) {
            throw new NullPointerException("Null 'persistentClass'");
        }
        ObjEntity entity = this.context.getEntityResolver().getObjEntity(persistentClass);
        if (entity == null) {
            throw new IllegalArgumentException("Class is not mapped with Cayenne: " + persistentClass.getName());
        }
        Persistent object = this.newObject(entity.getName());
        return (T)object;
    }

    Persistent newObject(String entityName) {
        Persistent object;
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(entityName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid entity name: " + entityName);
        }
        try {
            object = (Persistent)descriptor.createObject();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error instantiating object.", (Throwable)ex, new Object[0]);
        }
        descriptor.injectValueHolders(object);
        object.setObjectId(ObjectId.of(entityName));
        this.injectInitialValue(object);
        return object;
    }

    void registerNewObject(Object object) {
        ClassDescriptor descriptor;
        if (object == null) {
            throw new NullPointerException("Can't register null object.");
        }
        ObjEntity entity = this.context.getEntityResolver().getObjEntity((Persistent)object);
        if (entity == null) {
            throw new IllegalArgumentException("Can't find ObjEntity for Persistent class: " + object.getClass().getName() + ", class is likely not mapped.");
        }
        final Persistent persistent = (Persistent)object;
        if (persistent.getObjectId() != null) {
            if (persistent.getObjectContext() == this.context) {
                return;
            }
            if (persistent.getObjectContext() != null) {
                throw new IllegalStateException("Persistent is already registered with another DataContext. Try using 'localObjects()' instead.");
            }
        } else {
            persistent.setObjectId(ObjectId.of(entity.getName()));
        }
        if ((descriptor = this.context.getEntityResolver().getClassDescriptor(entity.getName())) == null) {
            throw new IllegalArgumentException("Invalid entity name: " + entity.getName());
        }
        this.injectInitialValue(object);
        descriptor.visitProperties(new PropertyVisitor(){

            @Override
            public boolean visitToMany(ToManyProperty property) {
                property.injectValueHolder(persistent);
                if (!property.isFault(persistent)) {
                    Object value = property.readProperty(persistent);
                    Set collection = value instanceof Map ? ((Map)value).entrySet() : (Set)value;
                    for (Object e : collection) {
                        if (!(e instanceof Persistent)) continue;
                        Persistent targetDO = (Persistent)e;
                        DataContextObjectCreator.this.registerNewObject(targetDO);
                        DataContextObjectCreator.this.context.getObjectStore().arcCreated(persistent.getObjectId(), targetDO.getObjectId(), new ArcId(property));
                    }
                }
                return true;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                Object target = property.readPropertyDirectly(persistent);
                if (target instanceof Persistent) {
                    Persistent targetDO = (Persistent)target;
                    DataContextObjectCreator.this.registerNewObject(targetDO);
                    DataContextObjectCreator.this.context.getObjectStore().arcCreated(persistent.getObjectId(), targetDO.getObjectId(), new ArcId(property));
                }
                return true;
            }

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void injectInitialValue(Object obj) {
        ObjEntity entity;
        GraphManager graphManager;
        Persistent object = (Persistent)obj;
        object.setObjectContext(this.context);
        object.setPersistenceState(2);
        GraphManager graphManager2 = graphManager = this.context.getGraphManager();
        synchronized (graphManager2) {
            graphManager.registerNode(object.getObjectId(), object);
            graphManager.nodeCreated(object.getObjectId());
        }
        try {
            entity = this.context.getEntityResolver().getObjEntity(object.getObjectId().getEntityName());
        }
        catch (CayenneRuntimeException ex) {
            entity = null;
        }
        if (entity != null && entity.getDeclaredQualifier() instanceof ValueInjector) {
            ((ValueInjector)((Object)entity.getDeclaredQualifier())).injectValue(object);
        }
        this.context.getEntityResolver().getCallbackRegistry().performCallbacks(LifecycleEvent.POST_ADD, object);
    }
}

