/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.db;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AbstractToDbToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class AddColumnToDb
extends AbstractToDbToken.EntityAndColumn {
    public AddColumnToDb(DbEntity entity, DbAttribute column) {
        super("Add Column", 50, entity, column);
    }

    protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(context.quotedFullyQualifiedName(this.getEntity()));
        sqlBuffer.append(" ADD COLUMN ");
        sqlBuffer.append(context.quotedName(this.getColumn()));
        sqlBuffer.append(" ");
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuffer sqlBuffer = new StringBuffer();
        QuotingStrategy context = adapter.getQuotingStrategy();
        this.appendPrefix(sqlBuffer, context);
        sqlBuffer.append(JdbcAdapter.getType((DbAdapter)adapter, (DbAttribute)this.getColumn()));
        sqlBuffer.append(JdbcAdapter.sizeAndPrecision((DbAdapter)adapter, (DbAttribute)this.getColumn()));
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createDropColumnToModel(this.getEntity(), this.getColumn());
    }
}

