/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.SelectPropertiesPanel;
import org.apache.cayenne.swing.components.JCayenneCheckBox;

public class ObjectQueryPropertiesPanel
extends SelectPropertiesPanel {
    protected JCheckBox dataRows;

    public ObjectQueryPropertiesPanel(ProjectController mediator) {
        super(mediator);
    }

    @Override
    protected void initView() {
        super.initView();
        this.dataRows = new JCayenneCheckBox();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, left:max(50dlu;pref), fill:max(150dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("", cc.xywh(1, 1, 4, 1));
        builder.addLabel("Result Caching:", cc.xy(1, 3));
        builder.add((Component)this.cacheStrategy, cc.xywh(3, 3, 2, 1));
        this.cacheGroupsLabel = builder.addLabel("Cache Group:", cc.xy(1, 7));
        builder.add((Component)this.cacheGroups.getComponent(), cc.xywh(3, 7, 2, 1));
        builder.addLabel("Fetch Data Rows:", cc.xy(1, 9));
        builder.add((Component)this.dataRows, cc.xy(3, 9));
        builder.addLabel("Fetch Offset, Rows:", cc.xy(1, 11));
        builder.add((Component)this.fetchOffset.getComponent(), cc.xy(3, 11));
        builder.addLabel("Fetch Limit, Rows:", cc.xy(1, 13));
        builder.add((Component)this.fetchLimit.getComponent(), cc.xy(3, 13));
        builder.addLabel("Page Size:", cc.xy(1, 15));
        builder.add((Component)this.pageSize.getComponent(), cc.xy(3, 15));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    protected void initController() {
        super.initController();
        this.dataRows.addItemListener(e -> {
            Boolean b = this.dataRows.isSelected() ? Boolean.TRUE : Boolean.FALSE;
            this.setQueryProperty("cayenne.GenericSelectQuery.fetchingDataRows", String.valueOf(b));
        });
    }

    @Override
    public void initFromModel(QueryDescriptor query) {
        super.initFromModel(query);
        this.dataRows.setSelected(Boolean.valueOf(query.getProperty("cayenne.GenericSelectQuery.fetchingDataRows")));
    }
}

