/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.IntegerConverter;

public class LongConverter
implements BytesConverter<Long> {
    public static final BytesConverter INSTANCE = new LongConverter();
    private static final int BYTES = 8;

    static long getLong(byte[] bytes) {
        if (bytes.length < 8) {
            return IntegerConverter.getInt(bytes);
        }
        if (bytes.length > 8) {
            throw new IllegalArgumentException("byte[] is too large for a single long value: " + bytes.length);
        }
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    static byte[] getBytes(long k) {
        if (k >= Integer.MIN_VALUE && k <= Integer.MAX_VALUE) {
            return IntegerConverter.getBytes((int)k);
        }
        return new byte[]{(byte)(k >> 56), (byte)(k >> 48), (byte)(k >> 40), (byte)(k >> 32), (byte)(k >> 24), (byte)(k >> 16), (byte)(k >> 8), (byte)k};
    }

    @Override
    public Long fromBytes(byte[] bytes) {
        return LongConverter.getLong(bytes);
    }

    @Override
    public byte[] toBytes(Long value) {
        return LongConverter.getBytes(value);
    }
}

