/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.util.CayenneMapEntry;

public final class CellRenderers {
    protected static Icon domainIcon = ModelerUtil.buildIcon("icon-dom.png");
    protected static Icon nodeIcon = ModelerUtil.buildIcon("icon-node.png");
    protected static Icon mapIcon = ModelerUtil.buildIcon("icon-datamap.png");
    protected static Icon dbEntityIcon = ModelerUtil.buildIcon("icon-dbentity.png");
    protected static Icon objEntityIcon = ModelerUtil.buildIcon("icon-objentity.png");
    protected static Icon procedureIcon = ModelerUtil.buildIcon("icon-stored-procedure.png");
    protected static Icon queryIcon = ModelerUtil.buildIcon("icon-query.png");
    protected static Icon embeddableIcon = ModelerUtil.buildIcon("icon-embeddable.png");
    protected static Icon relationshipIcon = ModelerUtil.buildIcon("icon-relationship.png");
    protected static Icon attributeIcon = ModelerUtil.buildIcon("icon-attribute.png");
    protected static Font defaultFont = UIManager.getFont("Label.font");

    public static Icon iconForObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DataChannelDescriptor) {
            return domainIcon;
        }
        if (object instanceof DataNodeDescriptor) {
            return nodeIcon;
        }
        if (object instanceof DataMap) {
            return mapIcon;
        }
        if (object instanceof DbEntity) {
            return dbEntityIcon;
        }
        if (object instanceof ObjEntity) {
            return objEntityIcon;
        }
        if (object instanceof Procedure) {
            return procedureIcon;
        }
        if (object instanceof QueryDescriptor) {
            return queryIcon;
        }
        if (object instanceof Relationship) {
            return relationshipIcon;
        }
        if (object instanceof Attribute) {
            return attributeIcon;
        }
        if (object instanceof Embeddable) {
            return embeddableIcon;
        }
        return null;
    }

    public static TreeCellRenderer treeRenderer() {
        return new TreeRenderer();
    }

    public static ListCellRenderer<Object> listRenderer() {
        return new ListRenderer(false);
    }

    public static ListCellRenderer<Object> listRendererWithIcons() {
        return new ListRenderer(true);
    }

    public static ListCellRenderer<Object> entityListRendererWithIcons(MappingNamespace namespace) {
        return new EntityRenderer(namespace);
    }

    public static TableCellRenderer entityTableRendererWithIcons(ProjectController mediator) {
        return new EntityTableRenderer(mediator);
    }

    public static String asString(Object obj) {
        return CellRenderers.asString(obj, Application.getInstance().getFrameController().getProjectController().getCurrentDataMap());
    }

    public static String asString(Object obj, MappingNamespace namespace) {
        if (obj instanceof CayenneMapEntry) {
            Entity entity;
            DataMap dataMap;
            CayenneMapEntry mapObject = (CayenneMapEntry)obj;
            String label = mapObject.getName();
            if (mapObject instanceof Entity && (dataMap = (entity = (Entity)mapObject).getDataMap()) != null && dataMap != namespace) {
                label = label + " (" + dataMap.getName() + ")";
            }
            return label;
        }
        if (obj instanceof DataMap) {
            return ((DataMap)obj).getName();
        }
        return obj == null ? null : String.valueOf(obj);
    }

    static final class EntityTableRenderer
    extends DefaultTableCellRenderer {
        private ProjectController mediator;

        public EntityTableRenderer(ProjectController mediator) {
            this.mediator = mediator;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object oldValue = value;
            value = CellRenderers.asString(value, this.mediator.getCurrentDataMap());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Icon icon = CellRenderers.iconForObject(oldValue);
            if (isSelected) {
                // empty if block
            }
            this.setIcon(icon);
            this.setFont(defaultFont);
            return this;
        }
    }

    static final class TreeRenderer
    extends DefaultTreeCellRenderer {
        TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Icon icon = CellRenderers.iconForObject(node.getUserObject());
            if (sel) {
                // empty if block
            }
            this.setIcon(icon);
            this.setFont(defaultFont);
            return this;
        }
    }

    static final class ListRenderer
    extends DefaultListCellRenderer {
        boolean showIcons;

        ListRenderer(boolean showIcons) {
            this.showIcons = showIcons;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String renderedValue = ModelerUtil.getObjectName(value);
            if (renderedValue == null) {
                renderedValue = " ";
            }
            super.getListCellRendererComponent((JList<?>)list, renderedValue, index, isSelected, cellHasFocus);
            if (this.showIcons) {
                Icon icon = CellRenderers.iconForObject(value);
                if (isSelected) {
                    // empty if block
                }
                this.setIcon(icon);
            }
            this.setFont(defaultFont);
            return this;
        }
    }

    static final class EntityRenderer
    extends DefaultListCellRenderer {
        MappingNamespace namespace;

        EntityRenderer(MappingNamespace namespace) {
            this.namespace = namespace;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon = CellRenderers.iconForObject(value);
            value = CellRenderers.asString(value, this.namespace);
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(icon);
            this.setFont(defaultFont);
            return this;
        }
    }
}

