/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.DBWizardAction;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.dialog.db.load.DbLoaderContext;
import org.apache.cayenne.modeler.dialog.db.load.DbLoaderOptionsDialog;
import org.apache.cayenne.modeler.dialog.db.load.LoadDataMapTask;

public class ReverseEngineeringAction
extends DBWizardAction<DbLoaderOptionsDialog> {
    ReverseEngineeringAction(Application application) {
        super(ReverseEngineeringAction.getActionName(), application);
    }

    public static String getActionName() {
        return "Reengineer Database Schema";
    }

    @Override
    public void performAction(ActionEvent event) {
        final DbLoaderContext context = new DbLoaderContext();
        DataSourceWizard connectWizard = this.dataSourceWizardDialog("Reengineer DB Schema: Connect to Database");
        if (connectWizard == null) {
            return;
        }
        context.setProjectController(this.getProjectController());
        try {
            context.setConnection(connectWizard.getDataSource().getConnection());
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(Application.getFrame(), ex.getMessage(), "Error loading schemas dialog", 0);
            return;
        }
        DbLoaderOptionsDialog loaderOptionsDialog = (DbLoaderOptionsDialog)this.loaderOptionDialog(connectWizard);
        if (!context.buildConfig(connectWizard, loaderOptionsDialog)) {
            try {
                context.getConnection().close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return;
        }
        this.runLoaderInThread(context, new Runnable(){

            @Override
            public void run() {
                ReverseEngineeringAction.this.application.getUndoManager().discardAllEdits();
                try {
                    context.getConnection().close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        });
    }

    private void runLoaderInThread(final DbLoaderContext context, final Runnable callback) {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                LoadDataMapTask task = new LoadDataMapTask(Application.getFrame(), "Reengineering DB", context);
                task.startAndWait();
                SwingUtilities.invokeLater(callback);
            }
        });
        th.start();
    }

    @Override
    protected DbLoaderOptionsDialog createDialog(Collection<String> catalogs, Collection<String> schemas, String currentCatalog, String currentSchema) {
        return new DbLoaderOptionsDialog(catalogs, schemas, currentCatalog, currentSchema);
    }
}

