/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.changeset;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.lifecycle.changeset.ChangeSet;
import org.apache.cayenne.lifecycle.changeset.PropertyChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericChangeSet
implements ChangeSet {
    private GraphDiff diff;
    private Map<ObjectId, Map<String, PropertyChange>> changes;

    public GenericChangeSet(GraphDiff diff) {
        this.diff = diff;
    }

    @Override
    public Map<String, PropertyChange> getChanges(Persistent object) {
        Map changes = this.getChanges().get(object.getObjectId());
        return changes != null ? changes : Collections.EMPTY_MAP;
    }

    private Map<ObjectId, Map<String, PropertyChange>> getChanges() {
        if (this.changes == null) {
            this.changes = this.parseDiff();
        }
        return this.changes;
    }

    private Map<ObjectId, Map<String, PropertyChange>> parseDiff() {
        final HashMap<ObjectId, Map<String, PropertyChange>> changes = new HashMap<ObjectId, Map<String, PropertyChange>>();
        this.diff.apply(new GraphChangeHandler(){

            private Map<String, PropertyChange> getChangeMap(Object id) {
                HashMap map = (HashMap)changes.get(id);
                if (map == null) {
                    map = new HashMap();
                    changes.put((ObjectId)id, map);
                }
                return map;
            }

            PropertyChange getChange(Object id, String property, Object oldValue) {
                Map<String, PropertyChange> map = this.getChangeMap(id);
                PropertyChange change = map.get(property);
                if (change == null) {
                    change = new PropertyChange(property, oldValue);
                    map.put(property, change);
                }
                return change;
            }

            public void nodeRemoved(Object nodeId) {
            }

            public void nodeCreated(Object nodeId) {
            }

            public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
                this.getChange(nodeId, (String)arcId, null);
            }

            public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
                this.getChange(nodeId, (String)arcId, null);
            }

            public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
                this.getChange(nodeId, property, oldValue).setNewValue(newValue);
            }

            public void nodeIdChanged(Object nodeId, Object newId) {
                Map<String, PropertyChange> map = this.getChangeMap(nodeId);
                changes.put((ObjectId)newId, map);
                this.getChange(nodeId, "cayenne:objectId", nodeId).setNewValue(newId);
            }
        });
        return changes;
    }
}

