/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class DbKeyGenerator
implements CayenneMapEntry,
XMLSerializable,
Serializable {
    public static final String ORACLE_TYPE = "ORACLE";
    public static final String NAMED_SEQUENCE_TABLE_TYPE = "NAMED_SEQUENCE_TABLE";
    protected String name;
    protected DbEntity dbEntity;
    protected String generatorType;
    protected Integer keyCacheSize;
    protected String generatorName;

    public DbKeyGenerator() {
    }

    public DbKeyGenerator(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getParent() {
        return this.getDbEntity();
    }

    public void setParent(Object parent) {
        if (parent != null && !(parent instanceof DbEntity)) {
            throw new IllegalArgumentException("Expected null or DbEntity, got: " + parent);
        }
        this.setDbEntity((DbEntity)parent);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        if (this.getGeneratorType() == null) {
            return;
        }
        encoder.println("<db-key-generator>");
        encoder.indent(1);
        encoder.print("<db-generator-type>");
        encoder.print(this.getGeneratorType());
        encoder.println("</db-generator-type>");
        if (this.getGeneratorName() != null) {
            encoder.print("<db-generator-name>");
            encoder.print(this.getGeneratorName());
            encoder.println("</db-generator-name>");
        }
        if (this.getKeyCacheSize() != null) {
            encoder.print("<db-key-cache-size>");
            encoder.print(String.valueOf(this.getKeyCacheSize()));
            encoder.println("</db-key-cache-size>");
        }
        encoder.indent(-1);
        encoder.println("</db-key-generator>");
    }

    public DbEntity getDbEntity() {
        return this.dbEntity;
    }

    public void setDbEntity(DbEntity dbEntity) {
        this.dbEntity = dbEntity;
    }

    public void setGeneratorType(String generatorType) {
        this.generatorType = generatorType;
        if (this.generatorType != null) {
            this.generatorType = this.generatorType.trim().toUpperCase();
            if (!ORACLE_TYPE.equals(this.generatorType) && !NAMED_SEQUENCE_TABLE_TYPE.equals(this.generatorType)) {
                this.generatorType = null;
            }
        }
    }

    public String getGeneratorType() {
        return this.generatorType;
    }

    public void setKeyCacheSize(Integer keyCacheSize) {
        this.keyCacheSize = keyCacheSize;
        if (this.keyCacheSize != null && this.keyCacheSize < 1) {
            this.keyCacheSize = null;
        }
    }

    public Integer getKeyCacheSize() {
        return this.keyCacheSize;
    }

    public void setGeneratorName(String generatorName) {
        this.generatorName = generatorName;
        if (this.generatorName != null) {
            this.generatorName = this.generatorName.trim();
            if (this.generatorName.length() == 0) {
                this.generatorName = null;
            }
        }
    }

    public String getGeneratorName() {
        return this.generatorName;
    }

    public String toString() {
        return "{Type=" + this.generatorType + ", Name=" + this.generatorName + ", Cache=" + this.keyCacheSize + "}";
    }
}

