/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.audit;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.cayenne.lifecycle.audit.AuditableOperation;
import org.apache.cayenne.lifecycle.audit.AuditableProcessor;

class AuditableAggregator {
    private static final int[] OP_PRECEDENCE = new int[AuditableOperation.values().length];
    private AuditableProcessor delegate;
    private Map<Object, AuditableOperation> ops;

    AuditableAggregator(AuditableProcessor delegate) {
        this.delegate = delegate;
        this.ops = new IdentityHashMap<Object, AuditableOperation>();
    }

    void audit(Object object, AuditableOperation operation) {
        AuditableOperation oldOp = this.ops.put(object, operation);
        if (oldOp != null && OP_PRECEDENCE[operation.ordinal()] < OP_PRECEDENCE[oldOp.ordinal()]) {
            this.ops.put(object, oldOp);
        }
    }

    void postSync() {
        for (Map.Entry<Object, AuditableOperation> op : this.ops.entrySet()) {
            this.delegate.audit(op.getKey(), op.getValue());
        }
    }

    static {
        AuditableAggregator.OP_PRECEDENCE[AuditableOperation.DELETE.ordinal()] = 3;
        AuditableAggregator.OP_PRECEDENCE[AuditableOperation.INSERT.ordinal()] = 2;
        AuditableAggregator.OP_PRECEDENCE[AuditableOperation.UPDATE.ordinal()] = 1;
    }
}

