/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateObjEntityUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.EntityMergeSupport;
import org.apache.cayenne.util.NameConverter;
import org.apache.cayenne.util.NamedObjectFactory;

public class CreateObjEntityAction
extends CayenneAction {
    public static String getActionName() {
        return "Create ObjEntity";
    }

    public CreateObjEntityAction(Application application) {
        super(CreateObjEntityAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-new_objentity.gif";
    }

    public void performAction(ActionEvent e) {
        this.createObjEntity();
    }

    protected void createObjEntity() {
        String pkg;
        ProjectController mediator = this.getProjectController();
        DataMap dataMap = mediator.getCurrentDataMap();
        ObjEntity entity = (ObjEntity)NamedObjectFactory.createObject(ObjEntity.class, mediator.getCurrentDataMap());
        entity.setSuperClassName(dataMap.getDefaultSuperclass());
        entity.setDeclaredLockType(dataMap.getDefaultLockType());
        DbEntity dbEntity = mediator.getCurrentDbEntity();
        if (dbEntity != null) {
            entity.setDbEntity(dbEntity);
            String baseName = NameConverter.underscoredToJava(dbEntity.getName(), true);
            String entityName = NamedObjectFactory.createName(ObjEntity.class, dbEntity.getDataMap(), baseName);
            entity.setName(entityName);
        }
        if ((pkg = dataMap.getDefaultPackage()) != null) {
            if (!pkg.endsWith(".")) {
                pkg = pkg + ".";
            }
            entity.setClassName(pkg + entity.getName());
        }
        if (dataMap.isClientSupported()) {
            String clientPkg = dataMap.getDefaultClientPackage();
            if (clientPkg != null) {
                if (!clientPkg.endsWith(".")) {
                    clientPkg = clientPkg + ".";
                }
                entity.setClientClassName(clientPkg + entity.getName());
            }
            entity.setClientSuperClassName(dataMap.getDefaultClientSuperclass());
        }
        dataMap.addObjEntity(entity);
        EntityMergeSupport merger = new EntityMergeSupport(dataMap);
        merger.addEntityMergeListener(DeleteRuleUpdater.getEntityMergeListener());
        merger.synchronizeWithDbEntity(entity);
        CreateObjEntityAction.fireObjEntityEvent(this, mediator, dataMap, entity);
        this.application.getUndoManager().addEdit(new CreateObjEntityUndoableEdit(dataMap, entity));
    }

    public void createObjEntity(DataMap dataMap, ObjEntity entity) {
        ProjectController mediator = this.getProjectController();
        dataMap.addObjEntity(entity);
        CreateObjEntityAction.fireObjEntityEvent(this, mediator, dataMap, entity);
    }

    static void fireObjEntityEvent(Object src, ProjectController mediator, DataMap dataMap, ObjEntity entity) {
        mediator.fireObjEntityEvent(new EntityEvent(src, (Entity)entity, 2));
        EntityDisplayEvent displayEvent = new EntityDisplayEvent(src, entity, dataMap, mediator.getCurrentDataNode(), (DataChannelDescriptor)mediator.getProject().getRootNode());
        displayEvent.setMainTabFocus(true);
        mediator.fireObjEntityDisplayEvent(displayEvent);
    }

    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ObjEntity) {
            return ((ObjEntity)object).getParent() != null && ((ObjEntity)object).getParent() instanceof DataMap;
        }
        return false;
    }
}

