/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.Map;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Scope;
import org.apache.cayenne.di.spi.Binding;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.FieldInjectingProvider;
import org.apache.cayenne.di.spi.InstanceProvider;
import org.apache.cayenne.di.spi.MapProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMapBuilder<T>
implements MapBuilder<T> {
    private DefaultInjector injector;
    private Key<Map<String, ?>> bindingKey;

    DefaultMapBuilder(Key<Map<String, ?>> bindingKey, DefaultInjector injector) {
        this.injector = injector;
        this.bindingKey = bindingKey;
        this.getMapProvider();
    }

    @Override
    public MapBuilder<T> put(String key, Class<? extends T> interfaceType) throws ConfigurationException {
        this.getMapProvider().put(key, this.injector.getProvider(interfaceType));
        return this;
    }

    @Override
    public MapBuilder<T> put(String key, T value) throws ConfigurationException {
        InstanceProvider<T> provider0 = new InstanceProvider<T>(value);
        FieldInjectingProvider<T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
        this.getMapProvider().put(key, provider1);
        return this;
    }

    @Override
    public MapBuilder<T> putAll(Map<String, T> map) throws ConfigurationException {
        MapProvider provider = this.getMapProvider();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            InstanceProvider<T> provider0 = new InstanceProvider<T>(entry.getValue());
            FieldInjectingProvider<T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
            provider.put(entry.getKey(), provider1);
        }
        return this;
    }

    private MapProvider getMapProvider() {
        MapProvider provider = null;
        Binding<Map<String, ?>> binding = this.injector.getBinding(this.bindingKey);
        if (binding == null) {
            provider = new MapProvider();
            this.injector.putBinding(this.bindingKey, provider);
        } else {
            provider = (MapProvider)binding.getUnscoped();
        }
        return provider;
    }

    @Override
    public void in(Scope scope) {
        this.injector.changeBindingScope(this.bindingKey, scope);
    }
}

