/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlite;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.cayenne.access.types.UtilDateType;

class SQLiteDateType
extends UtilDateType {
    private DateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat timeFormat = new SimpleDateFormat("kk:mm:ss");

    public Date materializeObject(ResultSet rs, int index, int type) throws Exception {
        String string = rs.getString(index);
        if (string == null) {
            return null;
        }
        long ts = this.getLongTimestamp(string);
        if (ts >= 0L) {
            return new Date(ts);
        }
        switch (type) {
            case 93: {
                return this.getTimestamp(string);
            }
            case 91: {
                return this.getDate(string);
            }
            case 92: {
                return rs.getTime(index);
            }
        }
        return this.getTimestamp(string);
    }

    public Date materializeObject(CallableStatement rs, int index, int type) throws Exception {
        String string = rs.getString(index);
        if (string == null) {
            return null;
        }
        long ts = this.getLongTimestamp(string);
        if (ts >= 0L) {
            return new Date(ts);
        }
        switch (type) {
            case 93: {
                return this.getTimestamp(string);
            }
            case 91: {
                return this.getDate(string);
            }
            case 92: {
                return this.getTime(string);
            }
        }
        return this.getTimestamp(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getTimestamp(String string) throws SQLException {
        try {
            DateFormat dateFormat = this.timestampFormat;
            synchronized (dateFormat) {
                return this.timestampFormat.parse(string);
            }
        }
        catch (ParseException e) {
            try {
                DateFormat dateFormat = this.dateFormat;
                synchronized (dateFormat) {
                    return this.dateFormat.parse(string);
                }
            }
            catch (ParseException e1) {
                throw new SQLException("Unparsable timestamp string: " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getDate(String string) throws SQLException {
        try {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                return this.dateFormat.parse(string);
            }
        }
        catch (ParseException e) {
            throw new SQLException("Unparsable date string: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getTime(String string) throws SQLException {
        try {
            DateFormat dateFormat = this.timeFormat;
            synchronized (dateFormat) {
                return this.timeFormat.parse(string);
            }
        }
        catch (ParseException e) {
            throw new SQLException("Unparsable time string: " + string);
        }
    }

    protected long getLongTimestamp(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }
}

