/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.jdbc.DataRowPostProcessor;
import org.apache.cayenne.access.jdbc.RowReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompoundRowReader
implements RowReader<Object[]> {
    private RowReader<?>[] readers;

    CompoundRowReader(int width) {
        this.readers = new RowReader[width];
    }

    void addRowReader(int pos, RowReader<?> reader) {
        this.readers[pos] = reader;
    }

    @Override
    public Object[] readRow(ResultSet resultSet) throws CayenneException {
        int width = this.readers.length;
        Object[] row = new Object[width];
        for (int i = 0; i < width; ++i) {
            row[i] = this.readers[i].readRow(resultSet);
        }
        return row;
    }

    @Override
    public void setPostProcessor(DataRowPostProcessor postProcessor) {
        for (RowReader<?> reader : this.readers) {
            reader.setPostProcessor(postProcessor);
        }
    }
}

