/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	camelv1 "github.com/apache/camel-kamelets/crds/pkg/apis/camel/v1"
	applyconfigurationcamelv1 "github.com/apache/camel-kamelets/crds/pkg/client/camel/applyconfiguration/camel/v1"
	scheme "github.com/apache/camel-kamelets/crds/pkg/client/camel/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// KameletsGetter has a method to return a KameletInterface.
// A group's client should implement this interface.
type KameletsGetter interface {
	Kamelets(namespace string) KameletInterface
}

// KameletInterface has methods to work with Kamelet resources.
type KameletInterface interface {
	Create(ctx context.Context, kamelet *camelv1.Kamelet, opts metav1.CreateOptions) (*camelv1.Kamelet, error)
	Update(ctx context.Context, kamelet *camelv1.Kamelet, opts metav1.UpdateOptions) (*camelv1.Kamelet, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, kamelet *camelv1.Kamelet, opts metav1.UpdateOptions) (*camelv1.Kamelet, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*camelv1.Kamelet, error)
	List(ctx context.Context, opts metav1.ListOptions) (*camelv1.KameletList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *camelv1.Kamelet, err error)
	Apply(ctx context.Context, kamelet *applyconfigurationcamelv1.KameletApplyConfiguration, opts metav1.ApplyOptions) (result *camelv1.Kamelet, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, kamelet *applyconfigurationcamelv1.KameletApplyConfiguration, opts metav1.ApplyOptions) (result *camelv1.Kamelet, err error)
	KameletExpansion
}

// kamelets implements KameletInterface
type kamelets struct {
	*gentype.ClientWithListAndApply[*camelv1.Kamelet, *camelv1.KameletList, *applyconfigurationcamelv1.KameletApplyConfiguration]
}

// newKamelets returns a Kamelets
func newKamelets(c *CamelV1Client, namespace string) *kamelets {
	return &kamelets{
		gentype.NewClientWithListAndApply[*camelv1.Kamelet, *camelv1.KameletList, *applyconfigurationcamelv1.KameletApplyConfiguration](
			"kamelets",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *camelv1.Kamelet { return &camelv1.Kamelet{} },
			func() *camelv1.KameletList { return &camelv1.KameletList{} },
		),
	}
}
