/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
)

// CatalogApplyConfiguration represents an declarative configuration of the Catalog type for use
// with apply.
type CatalogApplyConfiguration struct {
	Version  *string             `json:"version,omitempty"`
	Provider *v1.RuntimeProvider `json:"provider,omitempty"`
}

// CatalogApplyConfiguration constructs an declarative configuration of the Catalog type for use with
// apply.
func Catalog() *CatalogApplyConfiguration {
	return &CatalogApplyConfiguration{}
}

// WithVersion sets the Version field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Version field is set to the value of the last call.
func (b *CatalogApplyConfiguration) WithVersion(value string) *CatalogApplyConfiguration {
	b.Version = &value
	return b
}

// WithProvider sets the Provider field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Provider field is set to the value of the last call.
func (b *CatalogApplyConfiguration) WithProvider(value v1.RuntimeProvider) *CatalogApplyConfiguration {
	b.Provider = &value
	return b
}
