/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Classes;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Cpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.GarbageCollector;
import io.opentelemetry.instrumentation.runtimemetrics.java8.MemoryPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Threads;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalBufferPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalCpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalFileDescriptor;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalMemoryPools;
import java.util.ArrayList;
import java.util.List;

public class JmxRuntimeMetricsFactory {
    public static List<AutoCloseable> buildObservables(OpenTelemetry openTelemetry, boolean emitExperimentalTelemetry, boolean captureGcCause) {
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        observables.addAll(Classes.registerObservers(openTelemetry));
        observables.addAll(Cpu.registerObservers(openTelemetry));
        observables.addAll(GarbageCollector.registerObservers(openTelemetry, captureGcCause));
        observables.addAll(MemoryPools.registerObservers(openTelemetry));
        observables.addAll(Threads.registerObservers(openTelemetry));
        if (emitExperimentalTelemetry) {
            observables.addAll(ExperimentalBufferPools.registerObservers(openTelemetry));
            observables.addAll(ExperimentalCpu.registerObservers(openTelemetry));
            observables.addAll(ExperimentalMemoryPools.registerObservers(openTelemetry));
            observables.addAll(ExperimentalFileDescriptor.registerObservers(openTelemetry));
        }
        return observables;
    }

    private JmxRuntimeMetricsFactory() {
    }
}

