/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.DisconnectableZooKeeper;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUpgradeTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(SessionUpgradeTest.class);
    public static final int CONNECTION_TIMEOUT = ClientBase.CONNECTION_TIMEOUT;
    private final QuorumBase qb = new QuorumBase();

    @BeforeEach
    public void setUp() throws Exception {
        LOG.info("STARTING quorum {}", (Object)this.getClass().getName());
        this.qb.localSessionsEnabled = true;
        this.qb.localSessionsUpgradingEnabled = true;
        this.qb.setUp();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
    }

    @AfterEach
    public void tearDown() throws Exception {
        LOG.info("STOPPING quorum {}", (Object)this.getClass().getName());
        this.qb.tearDown();
    }

    @Test
    public void testLocalSessionsWithoutEphemeralOnFollower() throws Exception {
        this.testLocalSessionsWithoutEphemeral(false);
    }

    @Test
    public void testLocalSessionsWithoutEphemeralOnLeader() throws Exception {
        this.testLocalSessionsWithoutEphemeral(true);
    }

    private void testLocalSessionsWithoutEphemeral(boolean testLeader) throws Exception {
        DisconnectableZooKeeper zknew2;
        String nodePrefix = "/testLocalSessions-" + (testLeader ? "leaderTest-" : "followerTest-");
        int leaderIdx = this.qb.getLeaderIndex();
        Assertions.assertFalse((leaderIdx == -1 ? 1 : 0) != 0, (String)"No leader in quorum?");
        int followerIdx = (leaderIdx + 1) % 5;
        int otherFollowerIdx = (leaderIdx + 2) % 5;
        int testPeerIdx = testLeader ? leaderIdx : followerIdx;
        String[] hostPorts = this.qb.hostPort.split(",");
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(hostPorts[testPeerIdx], CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        for (int i = 0; i < 5; ++i) {
            zk.create(nodePrefix + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        long localSessionId = zk.getSessionId();
        byte[] localSessionPwd = (byte[])zk.getSessionPasswd().clone();
        try {
            watcher.reset();
            zknew2 = new DisconnectableZooKeeper(hostPorts[otherFollowerIdx], CONNECTION_TIMEOUT, watcher, localSessionId, localSessionPwd);
            zknew2.create(nodePrefix + "5", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"Connection on the same session ID should fail.");
        }
        catch (KeeperException.SessionExpiredException zknew2) {
        }
        catch (KeeperException.ConnectionLossException zknew2) {
            // empty catch block
        }
        if (!testLeader) {
            try {
                watcher.reset();
                zknew2 = new DisconnectableZooKeeper(hostPorts[leaderIdx], CONNECTION_TIMEOUT, watcher, localSessionId, localSessionPwd);
                zknew2.create(nodePrefix + "5", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                Assertions.fail((String)"Connection on the same session ID should fail.");
            }
            catch (KeeperException.SessionExpiredException sessionExpiredException) {
            }
            catch (KeeperException.ConnectionLossException connectionLossException) {
                // empty catch block
            }
        }
        zk.disconnect();
        watcher.reset();
        zk = new DisconnectableZooKeeper(hostPorts[testPeerIdx], CONNECTION_TIMEOUT, watcher, localSessionId, localSessionPwd);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        zk.create(nodePrefix + "6", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        try {
            watcher.reset();
            zk = new DisconnectableZooKeeper(hostPorts[testPeerIdx], CONNECTION_TIMEOUT, watcher, localSessionId, localSessionPwd);
            zk.create(nodePrefix + "7", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"Reconnecting to a closed session ID should fail.");
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
    }

    @Test
    public void testUpgradeWithEphemeralOnFollower() throws Exception {
        this.testUpgradeWithEphemeral(false);
    }

    @Test
    public void testUpgradeWithEphemeralOnLeader() throws Exception {
        this.testUpgradeWithEphemeral(true);
    }

    private void testUpgradeWithEphemeral(boolean testLeader) throws Exception {
        String nodePrefix = "/testUpgrade-" + (testLeader ? "leaderTest-" : "followerTest-");
        int leaderIdx = this.qb.getLeaderIndex();
        Assertions.assertFalse((leaderIdx == -1 ? 1 : 0) != 0, (String)"No leader in quorum?");
        int followerIdx = (leaderIdx + 1) % 5;
        int otherFollowerIdx = (leaderIdx + 2) % 5;
        int testPeerIdx = testLeader ? leaderIdx : followerIdx;
        String[] hostPorts = this.qb.hostPort.split(",");
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(hostPorts[testPeerIdx], CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        for (int i = 0; i < 5; ++i) {
            zk.create(nodePrefix + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        long localSessionId = zk.getSessionId();
        byte[] localSessionPwd = (byte[])zk.getSessionPasswd().clone();
        zk.disconnect();
        watcher.reset();
        zk = new DisconnectableZooKeeper(hostPorts[otherFollowerIdx], CONNECTION_TIMEOUT, watcher, localSessionId, localSessionPwd);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertNotNull((Object)zk.exists(nodePrefix + i, null));
        }
        zk.close();
        try {
            watcher.reset();
            zk = new DisconnectableZooKeeper(hostPorts[otherFollowerIdx], CONNECTION_TIMEOUT, watcher, localSessionId, localSessionPwd);
            zk.exists(nodePrefix + "0", null);
            Assertions.fail((String)"Reconnecting to a closed session ID should fail.");
        }
        catch (KeeperException.SessionExpiredException i) {
            // empty catch block
        }
        watcher.reset();
        zk = new DisconnectableZooKeeper(hostPorts[testPeerIdx], CONNECTION_TIMEOUT, watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertNull((Object)zk.exists(nodePrefix + i, null));
        }
    }
}

